/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.adapters;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.restapi.server.jaxrs.adapters.DocumentModelListPaginableAdapter;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.IllegalParameterException;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="search", type="SearchService")
@Produces(value={"application/json", "application/json+esentity"})
public class SearchAdapter
extends DocumentModelListPaginableAdapter {
    public static final String NAME = "search";
    public static final String pageProviderName = "REST_API_SEARCH_ADAPTER";

    private String extractQueryFromRequest(HttpServletRequest request) {
        Object query = request.getParameter("query");
        if (query == null) {
            DocumentModel doc;
            String fullText = request.getParameter("fullText");
            if (fullText == null) {
                throw new IllegalParameterException("Expecting a query or a fullText parameter");
            }
            String orderBy = request.getParameter("orderBy");
            Object orderClause = "";
            if (orderBy != null) {
                orderClause = " ORDER BY " + orderBy;
            }
            String path = (doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class)).isFolder() ? doc.getPathAsString() : doc.getPath().removeLastSegments(1).toString();
            query = "SELECT * FROM Document WHERE (ecm:fulltext = \"" + fullText + "\") AND (ecm:isVersion = 0) AND (ecm:path STARTSWITH \"" + path + "\")" + (String)orderClause;
        }
        return query;
    }

    @Override
    protected PageProviderDefinition getPageProviderDefinition() {
        String query = this.extractQueryFromRequest(this.ctx.getRequest());
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProviderDefinition ppdefinition = ppService.getPageProviderDefinition(pageProviderName);
        ppdefinition.setPattern(query);
        if (this.maxResults != null && !this.maxResults.isEmpty() && !this.maxResults.equals("-1")) {
            ppdefinition.getProperties().put("maxResults", this.maxResults);
        }
        return ppdefinition;
    }
}

