/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.comment;

import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="comment", type="commentAdapter")
@Produces(value={"application/json"})
public class CommentAdapter
extends DefaultAdapter {
    public static final String NAME = "comment";

    @POST
    public Response createComment(Comment comment) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        comment.setAuthor(this.getContext().getCoreSession().getPrincipal().getName());
        Comment result = commentManager.createComment(this.getContext().getCoreSession(), comment);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @GET
    public PartialList<Comment> getComments(@QueryParam(value="pageSize") @DefaultValue(value="0") Long pageSize, @QueryParam(value="currentPageIndex") @DefaultValue(value="0") Long currentPageIndex) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        return commentManager.getComments(this.getContext().getCoreSession(), doc.getId(), pageSize, currentPageIndex, false);
    }

    @GET
    @Path(value="{commentId}")
    public Comment getComment(@PathParam(value="commentId") String commentId) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        return commentManager.getComment(this.getContext().getCoreSession(), commentId);
    }

    @GET
    @Path(value="external/{entityId}")
    public Comment getExternalComment(@PathParam(value="entityId") String entityId) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        return commentManager.getExternalComment(this.getContext().getCoreSession(), entityId);
    }

    @PUT
    @Path(value="{commentId}")
    public Response updateComment(@PathParam(value="commentId") String commentId, Comment comment) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        CoreSession session = this.getContext().getCoreSession();
        String author = commentManager.getComment(session, commentId).getAuthor();
        comment.setAuthor(author);
        Comment updatedComment = commentManager.updateComment(session, commentId, comment);
        return Response.ok((Object)updatedComment).build();
    }

    @PUT
    @Path(value="external/{entityId}")
    public Comment updateExternalComment(@PathParam(value="entityId") String entityId, Comment comment) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        CoreSession session = this.getContext().getCoreSession();
        String author = commentManager.getExternalComment(session, entityId).getAuthor();
        comment.setAuthor(author);
        commentManager.updateExternalComment(session, entityId, comment);
        return comment;
    }

    @DELETE
    @Path(value="{commentId}")
    public Response deleteComment(@PathParam(value="commentId") String commentId) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        commentManager.deleteComment(this.getContext().getCoreSession(), commentId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="external/{entityId}")
    public Response deleteExternalComment(@PathParam(value="entityId") String entityId) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        commentManager.deleteExternalComment(this.getContext().getCoreSession(), entityId);
        return Response.noContent().build();
    }
}

