/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.search.core;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.search.core.SavedSearch;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SavedSearchWriter
extends ExtensibleEntityJsonWriter<SavedSearch> {
    public static final String ENTITY_TYPE = "savedSearch";
    @Inject
    private SchemaManager schemaManager;

    public SavedSearchWriter() {
        super(ENTITY_TYPE, SavedSearch.class);
    }

    protected void writeEntityBody(SavedSearch search, JsonGenerator jg) throws IOException {
        jg.writeStringField("id", search.getId());
        jg.writeStringField("title", search.getTitle());
        jg.writeStringField("queryParams", search.getQueryParams());
        jg.writeStringField("query", search.getQuery());
        jg.writeStringField("queryLanguage", search.getQueryLanguage());
        jg.writeStringField("pageProviderName", search.getPageProviderName());
        jg.writeStringField("pageSize", search.getPageSize() == null ? null : search.getPageSize().toString());
        jg.writeStringField("currentPageIndex", search.getCurrentPageIndex() == null ? null : search.getCurrentPageIndex().toString());
        jg.writeStringField("maxResults", search.getMaxResults() == null ? null : search.getMaxResults().toString());
        jg.writeStringField("sortBy", search.getSortBy());
        jg.writeStringField("sortOrder", search.getSortOrder());
        jg.writeStringField("contentViewData", search.getContentViewData());
        Map<String, String> params = search.getNamedParams();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        jg.writeObjectFieldStart("params");
        for (String param : params.keySet()) {
            jg.writeStringField(param, search.getNamedParams().get(param));
        }
        Set schemas = this.ctx.getProperties();
        if (schemas.size() > 0) {
            DocumentModel doc = search.getDocument();
            if (schemas.contains("*")) {
                for (String schema : doc.getSchemas()) {
                    this.writeSchemaProperties(jg, doc, schema);
                }
            } else {
                for (String schema : schemas) {
                    if (!doc.hasSchema(schema)) continue;
                    this.writeSchemaProperties(jg, doc, schema);
                }
            }
        }
        jg.writeEndObject();
    }

    private void writeSchemaProperties(JsonGenerator jg, DocumentModel doc, String schemaName) throws IOException {
        Writer propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        try (Closeable resource = this.ctx.wrap().with(ENTITY_TYPE, (Object)doc).open();){
            Schema schema = this.schemaManager.getSchema(schemaName);
            Object prefix = schema.getNamespace().prefix;
            if (prefix == null || ((String)prefix).length() == 0) {
                prefix = schemaName;
            }
            prefix = (String)prefix + ":";
            for (Field field : schema.getFields()) {
                String prefixedName = (String)prefix + field.getName().getLocalName();
                jg.writeFieldName(prefixedName);
                Property property = doc.getProperty(prefixedName);
                OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
            }
        }
    }
}

