/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.impl.SuperKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;

public class AdapterKeyedRegistry
extends SuperKeyedRegistry<TypeAdapterKey, TypeAdapter> {
    protected final Set<Class<?>> blacklist = new HashSet();

    public AdapterKeyedRegistry() {
        this.blacklist.add(Serializable.class);
        this.blacklist.add(Cloneable.class);
        this.blacklist.add(Comparable.class);
    }

    @Override
    protected boolean isRoot(TypeAdapterKey key) {
        return key.input == Object.class;
    }

    @Override
    protected List<TypeAdapterKey> getSuperKeys(TypeAdapterKey key) {
        ArrayList<TypeAdapterKey> result = new ArrayList<TypeAdapterKey>();
        Class<?> cl = key.input.getSuperclass();
        if (cl != null) {
            result.add(new TypeAdapterKey(cl, key.output));
        }
        for (Class<?> itf : key.input.getInterfaces()) {
            if (this.blacklist.contains(itf)) continue;
            result.add(new TypeAdapterKey(itf, key.output));
        }
        return result;
    }

    @Override
    protected boolean isCachingEnabled(TypeAdapterKey key) {
        return !Proxy.isProxyClass(key.input);
    }
}

