/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationFilter;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class AutomationFilterRegistry
extends ContributionFragmentRegistry<AutomationFilter> {
    protected final Map<String, AutomationFilter> automationFilters = new HashMap<String, AutomationFilter>();
    protected volatile Map<String, AutomationFilter> lookup;

    public synchronized void addContribution(AutomationFilter automationFilter, boolean replace) throws OperationException {
        if (!replace && this.automationFilters.containsKey(automationFilter.getId())) {
            throw new OperationException("An automation filter is already bound to: " + automationFilter.getId() + ". Use 'replace=true' to replace an existing automation filter");
        }
        super.addContribution((Object)automationFilter);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public String getContributionId(AutomationFilter contrib) {
        return contrib.getId();
    }

    public void contributionUpdated(String id, AutomationFilter contrib, AutomationFilter newOrigContrib) {
        this.automationFilters.put(id, contrib);
        this.lookup = null;
    }

    public void contributionRemoved(String id, AutomationFilter origContrib) {
        this.automationFilters.remove(id);
        this.lookup = null;
    }

    public AutomationFilter clone(AutomationFilter orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(AutomationFilter src, AutomationFilter dst) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AutomationFilter> lookup() {
        Map<String, AutomationFilter> _lookup = this.lookup;
        if (_lookup == null) {
            AutomationFilterRegistry automationFilterRegistry = this;
            synchronized (automationFilterRegistry) {
                _lookup = this.lookup = new HashMap<String, AutomationFilter>(this.automationFilters);
            }
        }
        return _lookup;
    }

    public AutomationFilter getAutomationFilter(String id) {
        return this.automationFilters.get(id);
    }
}

