/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.ExitException;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.scripting.Expression;

public class OperationChainCompiler {
    private static final Log log = LogFactory.getLog(OperationChainCompiler.class);
    protected final AutomationService service;
    protected final LoadingCache<Connector, OperationMethod> cache;
    protected static final int MAX_CACHE_SIZE = 1000;

    protected OperationChainCompiler(AutomationService service) {
        this.service = service;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Connector, OperationMethod>(){

            public OperationMethod load(Connector connector) throws OperationException {
                return connector.connect();
            }
        });
    }

    public CompiledChain compile(ChainTypeImpl typeof, Class<?> typein) throws OperationException {
        OperationMethod operationMethod;
        Connector connector = new Connector(typeof, typein);
        try {
            operationMethod = (OperationMethod)this.cache.get((Object)connector);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OperationException) {
                throw (OperationException)cause;
            }
            throw new OperationException(cause);
        }
        return new CompiledChainImpl(typeof, typein, operationMethod);
    }

    protected class CompiledChainImpl
    implements CompiledChain {
        protected final ChainTypeImpl typeof;
        protected final Class<?> typein;
        protected final OperationMethod head;

        protected CompiledChainImpl(ChainTypeImpl typeof, Class<?> typein, OperationMethod head) {
            this.typeof = typeof;
            this.typein = typein;
            this.head = head;
        }

        @Override
        public Object invoke(OperationContext ctx) throws OperationException {
            return ctx.callWithChainParameters(() -> {
                ctx.getCallback().onChainEnter(this.typeof);
                try {
                    Object object = this.head.invoke(ctx);
                    return object;
                }
                catch (ExitException e) {
                    if (e.isRollback()) {
                        ctx.setRollback();
                    }
                    Object object = ctx.getInput();
                    return object;
                }
                catch (OperationException op) {
                    throw ctx.getCallback().onError(op);
                }
                finally {
                    ctx.getCallback().onChainExit();
                }
            }, this.typeof.getChainParameters());
        }

        public String toString() {
            return "CompiledChainImpl [op=" + this.typeof + ",input=" + this.typein + "]";
        }
    }

    protected class OperationMethod {
        protected final OperationType typeof;
        protected final OperationParameters params;
        protected InvokableMethod method;
        protected OperationMethod prev;
        protected OperationMethod next;

        protected OperationMethod(OperationParameters params, OperationMethod prev) throws OperationNotFoundException {
            this.typeof = OperationChainCompiler.this.service.getOperation(params.id());
            this.params = params;
            this.prev = prev;
        }

        protected Object invoke(OperationContext context) throws OperationException {
            context.getCallback().onOperationEnter(context, this.typeof, this.method, this.params.map());
            Object output = this.method.invoke(context, this.params.map());
            if (output instanceof Expression) {
                output = ((Expression)output).eval(context);
            }
            context.getCallback().onOperationExit(output);
            context.setInput(output);
            if (this.next != null) {
                return this.next.invoke(context);
            }
            return output;
        }

        void solve(Class<?> in) throws InvalidChainException {
            InvokableMethod[] methods = this.typeof.getMethodsMatchingInput(in);
            if (methods.length == 0) {
                throw new InvalidChainException("Cannot find any valid path in operation chain - no method found for operation '" + this.typeof.getId() + "' and for first input type '" + in.getName() + "'");
            }
            if (this.next == null) {
                this.method = methods[0];
                return;
            }
            for (InvokableMethod m : methods) {
                Class<?> nextIn = m.getOutputType();
                if (nextIn == Void.TYPE || nextIn.equals(Object.class)) {
                    nextIn = in;
                }
                try {
                    this.next.solve(nextIn);
                    this.method = m;
                    return;
                }
                catch (InvalidChainException invalidChainException) {
                }
            }
            throw new InvalidChainException("Cannot find any valid path in operation chain - no method found for operation '" + this.typeof.getId() + "' and for first input type '" + in.getName() + "'");
        }
    }

    protected class Connector {
        protected final ChainTypeImpl typeof;
        protected final Class<?> typein;

        protected Connector(ChainTypeImpl typeof, Class<?> typein) {
            this.typeof = typeof;
            this.typein = typein;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + this.typeof.hashCode();
            result = prime * result + this.typein.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Connector)) {
                return false;
            }
            Connector other = (Connector)obj;
            return this.typeof.equals(other.typeof) && this.typein.equals(other.typein);
        }

        protected OperationMethod connect() throws OperationException {
            OperationMethod head = null;
            OperationMethod prev = null;
            for (OperationParameters params : this.typeof.chain.getOperations()) {
                OperationMethod next = new OperationMethod(params, prev);
                if (prev != null) {
                    prev.next = next;
                }
                if (next.prev == null) {
                    head = next;
                }
                prev = next;
            }
            if (head != null) {
                head.solve(this.typein);
            }
            return head;
        }
    }
}

