/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Blob.PostToURL", category="Files", label="HTTP Post", description="Post the input file to a target HTTP URL. Returns back the input file.", aliases={"Blob.Post"})
public class PostBlob {
    public static final String ID = "Blob.PostToURL";
    @Param(name="url")
    protected String url;

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob blob) throws IOException {
        URL target = new URL(this.url);
        URLConnection conn = target.openConnection();
        conn.setDoOutput(true);
        try (InputStream in = blob.getStream();
             OutputStream out = conn.getOutputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        return blob;
    }
}

