/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.stream.Collectors;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.Order", category="Document", label="Order Document", description="Given a parent document, order the source child before the destination child.", since="10.1")
public class OrderDocument {
    public static final String ID = "Document.Order";
    public static final String NOT_SAME_FOLDER_ERROR_MSG = "The document can only be ordered within the same folder.";
    @Param(name="before", required=false)
    protected DocumentModel before;
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        try {
            this.session.orderBefore(doc.getParentRef(), doc.getName(), this.before != null ? this.before.getName() : null);
            this.session.save();
            return this.session.getDocument(doc.getRef());
        }
        catch (DocumentNotFoundException e) {
            throw new NuxeoException(NOT_SAME_FOLDER_ERROR_MSG);
        }
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        return (DocumentModelList)docs.stream().map(doc -> this.run((DocumentModel)doc)).collect(Collectors.toCollection(DocumentModelListImpl::new));
    }
}

