/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.CreatablePropertyTypes;
import org.apache.chemistry.opencmis.commons.data.NewTypeSettableAttributes;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CreatablePropertyTypesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.NewTypeSettableAttributesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.security.DefaultPermissionProvider;
import org.nuxeo.ecm.core.security.PermissionVisibilityDescriptor;
import org.nuxeo.runtime.api.Framework;

public class NuxeoRepository {
    @Deprecated
    public static final String NUXEO_VERSION_PROP = "org.nuxeo.distribution.version";
    public static final String NUXEO_URL_PROP = "nuxeo.url";
    public static final String SUPPORTS_JOINS_PROP = "org.nuxeo.cmis.joins";
    public static final String SUPPORTS_PROXIES_PROP = "org.nuxeo.cmis.proxies";
    public static final String ELASTICSEARCH_PROP = "org.nuxeo.cmis.elasticsearch";
    public static final String RELAX_CMIS_SPEC = "org.nuxeo.cmis.relaxSpec";
    private static final String NUXEO_CONTEXT_PATH_PROP = "org.nuxeo.ecm.contextPath";
    private static final String NUXEO_CONTEXT_PATH_DEFAULT = "/nuxeo";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String NUXEO_VH_HEADER = "nuxeo-virtual-host";
    private static final String VH_PARAM = "nuxeo.virtual.host";
    public static final String NUXEO_READ_REMOVE = "ReadRemove";
    protected final String repositoryId;
    protected final String rootFolderId;
    protected boolean supportsJoins;
    protected boolean supportsProxies = true;
    protected boolean useElasticsearch;
    protected Map<CmisVersion, TypeManagerImpl> typeManagerByCmisVersion = new HashMap<CmisVersion, TypeManagerImpl>();

    public NuxeoRepository(String repositoryId, String rootFolderId) {
        this.repositoryId = repositoryId;
        this.rootFolderId = rootFolderId;
        if (Framework.isBooleanPropertyTrue((String)SUPPORTS_JOINS_PROP)) {
            this.setSupportsJoins(true);
        }
        if (Framework.isBooleanPropertyFalse((String)SUPPORTS_PROXIES_PROP)) {
            this.setSupportsProxies(false);
        }
        if (Framework.isBooleanPropertyTrue((String)ELASTICSEARCH_PROP)) {
            this.setUseElasticsearch(true);
        }
    }

    public void setSupportsJoins(boolean supportsJoins) {
        this.supportsJoins = supportsJoins;
    }

    public boolean supportsJoins() {
        return this.supportsJoins;
    }

    public void setSupportsProxies(boolean supportsProxies) {
        this.supportsProxies = supportsProxies;
    }

    public boolean supportsProxies() {
        return this.supportsProxies;
    }

    public void setUseElasticsearch(boolean useElasticsearch) {
        this.useElasticsearch = useElasticsearch;
    }

    public boolean useElasticsearch() {
        return this.useElasticsearch;
    }

    public String getId() {
        return this.repositoryId;
    }

    public TypeManagerImpl getTypeManager(CmisVersion cmisVersion) {
        TypeManagerImpl typeManager = this.typeManagerByCmisVersion.get(cmisVersion);
        if (typeManager == null) {
            typeManager = this.initializeTypes(cmisVersion);
            this.typeManagerByCmisVersion.put(cmisVersion, typeManager);
        }
        return typeManager;
    }

    protected TypeManagerImpl initializeTypes(CmisVersion cmisVersion) {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        HashMap<String, List<String>> typesChildren = new HashMap<String, List<String>>();
        for (DocumentType dt : schemaManager.getDocumentTypes()) {
            Type st = dt.getSuperType();
            if (st == null) continue;
            String name = st.getName();
            LinkedList<String> siblings = (LinkedList<String>)typesChildren.get(name);
            if (siblings == null) {
                siblings = new LinkedList<String>();
                typesChildren.put(name, siblings);
            }
            siblings.add(dt.getName());
        }
        HashSet<String> done = new HashSet<String>();
        TypeManagerImpl typeManager = new TypeManagerImpl();
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_DOCUMENT, schemaManager, cmisVersion));
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_FOLDER, schemaManager, cmisVersion));
        typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_RELATIONSHIP, schemaManager, cmisVersion));
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            typeManager.addTypeDefinition(NuxeoTypeHelper.constructCmisBase(BaseTypeId.CMIS_SECONDARY, schemaManager, cmisVersion));
        }
        this.addTypesRecursively(typeManager, "Document", typesChildren, done, schemaManager, cmisVersion);
        this.addTypesRecursively(typeManager, "Folder", typesChildren, done, schemaManager, cmisVersion);
        this.addTypesRecursively(typeManager, "Relation", typesChildren, done, schemaManager, cmisVersion);
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            this.addSecondaryTypes(typeManager, schemaManager, cmisVersion);
        }
        return typeManager;
    }

    protected void addTypesRecursively(TypeManagerImpl typeManager, String name, Map<String, List<String>> typesChildren, Set<String> done, SchemaManager schemaManager, CmisVersion cmisVersion) {
        List<String> children;
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        DocumentType dt = schemaManager.getDocumentType(name);
        String parentTypeId = NuxeoTypeHelper.getParentTypeId(dt);
        if (parentTypeId != null) {
            TypeDefinitionContainer parentType = typeManager.getTypeById(parentTypeId);
            if (parentType == null) {
                parentTypeId = BaseTypeId.CMIS_DOCUMENT.value();
            } else if (parentType.getTypeDefinition().getBaseTypeId() != BaseTypeId.CMIS_FOLDER && dt.isFolder()) {
                parentTypeId = BaseTypeId.CMIS_FOLDER.value();
            }
            typeManager.addTypeDefinition(NuxeoTypeHelper.constructDocumentType(dt, parentTypeId, cmisVersion));
        }
        if ((children = typesChildren.get(name)) == null) {
            return;
        }
        for (String sub : children) {
            this.addTypesRecursively(typeManager, sub, typesChildren, done, schemaManager, cmisVersion);
        }
    }

    protected void addSecondaryTypes(TypeManagerImpl typeManager, SchemaManager schemaManager, CmisVersion cmisVersion) {
        for (CompositeType type : schemaManager.getFacets()) {
            typeManager.addTypeDefinition(NuxeoTypeHelper.constructSecondaryType(type, cmisVersion), false);
        }
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public RepositoryInfo getRepositoryInfo(String latestChangeLogToken, CallContext callContext) {
        CmisVersion cmisVersion = callContext.getCmisVersion();
        RepositoryInfoImpl repositoryInfo = new RepositoryInfoImpl();
        repositoryInfo.setId(this.repositoryId);
        repositoryInfo.setName("Nuxeo Repository " + this.repositoryId);
        repositoryInfo.setDescription("Nuxeo Repository " + this.repositoryId);
        repositoryInfo.setCmisVersionSupported(cmisVersion.value());
        repositoryInfo.setPrincipalAnonymous("Guest");
        repositoryInfo.setPrincipalAnyone("Everyone");
        repositoryInfo.setThinClientUri(NuxeoRepository.getBaseURL(callContext));
        repositoryInfo.setChangesIncomplete(Boolean.FALSE);
        repositoryInfo.setChangesOnType(Arrays.asList(BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER));
        repositoryInfo.setLatestChangeLogToken(latestChangeLogToken);
        repositoryInfo.setVendorName("Nuxeo");
        repositoryInfo.setProductName("Nuxeo OpenCMIS Connector");
        String version = Framework.getProperty((String)NUXEO_VERSION_PROP, (String)"5.5 dev");
        repositoryInfo.setProductVersion(version);
        repositoryInfo.setRootFolder(this.rootFolderId);
        repositoryInfo.setExtensionFeature(Collections.emptyList());
        RepositoryCapabilitiesImpl caps = new RepositoryCapabilitiesImpl();
        caps.setAllVersionsSearchable(Boolean.TRUE);
        caps.setCapabilityAcl(CapabilityAcl.MANAGE);
        caps.setCapabilityChanges(CapabilityChanges.OBJECTIDSONLY);
        caps.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.PWCONLY);
        caps.setCapabilityJoin(this.supportsJoins ? CapabilityJoin.INNERANDOUTER : CapabilityJoin.NONE);
        caps.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        caps.setCapabilityRendition(CapabilityRenditions.READ);
        caps.setIsPwcSearchable(Boolean.TRUE);
        caps.setIsPwcUpdatable(Boolean.TRUE);
        caps.setSupportsGetDescendants(Boolean.TRUE);
        caps.setSupportsGetFolderTree(Boolean.TRUE);
        caps.setSupportsMultifiling(Boolean.FALSE);
        caps.setSupportsUnfiling(Boolean.FALSE);
        caps.setSupportsVersionSpecificFiling(Boolean.FALSE);
        caps.setNewTypeSettableAttributes((NewTypeSettableAttributes)new NewTypeSettableAttributesImpl());
        caps.setCreatablePropertyTypes((CreatablePropertyTypes)new CreatablePropertyTypesImpl());
        repositoryInfo.setCapabilities((RepositoryCapabilities)caps);
        AclCapabilitiesDataImpl aclCaps = new AclCapabilitiesDataImpl();
        aclCaps.setAclPropagation(AclPropagation.PROPAGATE);
        aclCaps.setSupportedPermissions(SupportedPermissions.REPOSITORY);
        ArrayList<PermissionDefinition> permDefs = new ArrayList<PermissionDefinition>();
        NuxeoRepository.addPermissionDefinitions(permDefs);
        aclCaps.setPermissionDefinitionData(permDefs);
        HashMap<String, PermissionMapping> permMap = new HashMap<String, PermissionMapping>();
        NuxeoRepository.addPermissionMapping(permMap, "canGetDescendents.Folder", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetChildren.Folder", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetParents.Folder", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetFolderParent.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canCreateDocument.Folder", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canCreateFolder.Folder", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canCreateRelationship.Source", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canCreateRelationship.Target", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetProperties.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canViewContent.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canUpdateProperties.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canMove.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canMove.Target", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canMove.Source", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canDelete.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canDeleteTree.Folder", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canSetContent.Document", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canDeleteContent.Document", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canAddToFolder.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canAddToFolder.Folder", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canRemoveFromFolder.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canRemoveFromFolder.Folder", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canCheckout.Document", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canCancelCheckout.Document", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canCheckin.Document", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canGetAllVersions.VersionSeries", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetObjectRelationships.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canAddPolicy.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canAddPolicy.Policy", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canRemovePolicy.Object", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canRemovePolicy.Policy", "cmis:write");
        NuxeoRepository.addPermissionMapping(permMap, "canGetAppliedPolicies.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canGetACL.Object", "cmis:read");
        NuxeoRepository.addPermissionMapping(permMap, "canApplyACL.Object", "cmis:all");
        aclCaps.setPermissionMappingData(permMap);
        repositoryInfo.setAclCapabilities((AclCapabilities)aclCaps);
        return repositoryInfo;
    }

    protected static void addPermissionDefinitions(List<PermissionDefinition> permDefs) {
        Map map;
        NuxeoRepository.addPermissionDefinition(permDefs, "cmis:read", "Read");
        NuxeoRepository.addPermissionDefinition(permDefs, "cmis:write", "Write");
        NuxeoRepository.addPermissionDefinition(permDefs, "cmis:all", "All");
        NuxeoRepository.addPermissionDefinition(permDefs, NUXEO_READ_REMOVE, "Remove");
        HashSet<String> done = new HashSet<String>();
        done.add("Read");
        done.add("ReadWrite");
        done.add("Everything");
        done.add(NUXEO_READ_REMOVE);
        DefaultPermissionProvider permissionProvider = (DefaultPermissionProvider)Framework.getService(PermissionProvider.class);
        permissionProvider.getUserVisiblePermissionDescriptors();
        try {
            Field f = DefaultPermissionProvider.class.getDeclaredField("mergedPermissionsVisibility");
            f.setAccessible(true);
            map = (Map)f.get(permissionProvider);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry en : map.entrySet()) {
            for (String permission : ((PermissionVisibilityDescriptor)en.getValue()).getSortedItems()) {
                if (!done.add(permission)) continue;
                NuxeoRepository.addPermissionDefinition(permDefs, permission, permission);
            }
        }
    }

    protected static void addPermissionDefinition(List<PermissionDefinition> permDefs, String permission, String description) {
        PermissionDefinitionDataImpl pd = new PermissionDefinitionDataImpl();
        pd.setId(permission);
        pd.setDescription(description);
        permDefs.add((PermissionDefinition)pd);
    }

    protected static void addPermissionMapping(Map<String, PermissionMapping> permMap, String key, String permission) {
        PermissionMappingDataImpl pm = new PermissionMappingDataImpl();
        pm.setKey(key);
        pm.setPermissions(Collections.singletonList(permission));
        permMap.put(key, (PermissionMapping)pm);
    }

    private static String getBaseURL(CallContext callContext) {
        HttpServletRequest request = (HttpServletRequest)callContext.get("httpServletRequest");
        if (request != null) {
            String baseURL = NuxeoRepository.getServerURL(request);
            String contextPath = request.getContextPath();
            if (contextPath == null) {
                contextPath = Framework.getProperty((String)NUXEO_CONTEXT_PATH_PROP, (String)NUXEO_CONTEXT_PATH_DEFAULT);
            }
            return baseURL + contextPath + "/";
        }
        return Framework.getProperty((String)NUXEO_URL_PROP);
    }

    private static String getServerURL(HttpServletRequest request) {
        String url = null;
        String nuxeoVH = request.getHeader(NUXEO_VH_HEADER);
        if (nuxeoVH == null) {
            nuxeoVH = Framework.getProperty((String)VH_PARAM);
        }
        if (nuxeoVH != null && nuxeoVH.startsWith("http")) {
            url = nuxeoVH;
        } else {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            String forwardedHost = request.getHeader(X_FORWARDED_HOST);
            if (forwardedHost != null) {
                if (forwardedHost.contains(":")) {
                    String[] split = forwardedHost.split(":");
                    serverName = split[0];
                    serverPort = Integer.parseInt(split[1]);
                } else {
                    serverName = forwardedHost;
                    serverPort = 80;
                }
            }
            url = NuxeoRepository.buildURL(scheme, serverName, serverPort);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static String buildURL(String scheme, String serverName, int serverPort) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(serverName);
        if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
            sb.append(':');
            sb.append(serverPort);
        }
        return sb.toString();
    }
}

