/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.factory;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.factory.DefaultCacheKeyFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.DefaultGroupExtractor;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.ResourceType;

public class NuxeoWroPageCacheKeyFactory
extends DefaultCacheKeyFactory {
    private static final Log log = LogFactory.getLog(NuxeoWroPageCacheKeyFactory.class);
    protected static final String URI_MARKER = "/resource/page/";
    @Inject
    private GroupExtractor groupExtractor;
    @Inject
    private ReadOnlyContext context;

    public CacheKey create(HttpServletRequest request) {
        Map params;
        Validate.notNull((Object)request);
        CacheKey key = null;
        DefaultGroupExtractor ext = new DefaultGroupExtractor(){

            public String getGroupName(HttpServletRequest request) {
                Validate.notNull((Object)request);
                String uri = request.getRequestURI();
                String includeUriPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                uri = includeUriPath != null ? includeUriPath : uri;
                String groupName = FilenameUtils.removeExtension((String)this.getPageName(this.stripSessionID(uri)));
                return StringUtils.isEmpty((CharSequence)groupName) ? null : groupName;
            }

            private String stripSessionID(String uri) {
                if (uri == null) {
                    return null;
                }
                return uri.replaceFirst("(?i)(;jsessionid.*)", "");
            }

            protected String getPageName(String filename) {
                if (filename == null) {
                    return null;
                }
                int index = filename.indexOf(NuxeoWroPageCacheKeyFactory.URI_MARKER);
                if (index != -1) {
                    return filename.substring(index + NuxeoWroPageCacheKeyFactory.URI_MARKER.length());
                }
                return null;
            }
        };
        String groupName = ext.getGroupName(request);
        ResourceType resourceType = this.groupExtractor.getResourceType(request);
        boolean minimize = this.isMinimized(request);
        if (groupName != null && resourceType != null) {
            key = new CacheKey(groupName, resourceType, minimize);
        }
        if (key != null && (params = URIUtils.getRequestParameters((String)request.getQueryString())) != null) {
            for (Map.Entry entry : params.entrySet()) {
                key.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cache key for request '%s' '%s': %s", request.getRequestURL(), request.getQueryString(), key));
        }
        return key;
    }

    private boolean isMinimized(HttpServletRequest request) {
        return this.context.getConfig().isMinimizeEnabled() ? this.groupExtractor.isMinimized(request) : false;
    }
}

