/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.provider;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.runtime.api.Framework;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;

public class NuxeoUriLocator
implements UriLocator {
    private static final Log log = LogFactory.getLog(NuxeoUriLocator.class);
    public static final String ALIAS = "nuxeoUri";
    @Inject
    UriLocatorFactory uriLocatorFactory;

    public boolean accept(String uri) {
        return uri != null && uri.startsWith("nuxeo:");
    }

    public InputStream locate(String uri) throws IOException {
        Resource resource = NuxeoUriLocator.getResource(uri);
        if (resource != null) {
            String ruri = resource.getURI();
            if (ruri == null) {
                log.error((Object)("Cannot handle resource '" + resource.getName() + "': no resolved uri"));
                return null;
            }
            UriLocator uriLocator = this.uriLocatorFactory.getInstance(ruri);
            if (uriLocator != null) {
                return uriLocator.locate(ruri);
            }
        }
        return null;
    }

    public static Resource getResource(String uri) {
        String name = uri.substring("nuxeo:".length());
        WebResourceManager service = (WebResourceManager)Framework.getService(WebResourceManager.class);
        return service.getResource(name);
    }

    public static String getUri(Resource resource) {
        return "nuxeo:" + resource.getName();
    }

    public static boolean isProcessorEnabled(String alias, String uri) {
        Resource res = NuxeoUriLocator.getResource(uri);
        if (res != null) {
            return res.getProcessors().contains(alias);
        }
        return false;
    }
}

