/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.storage.QueryOptimizer;

public class DBSQueryOptimizer
extends QueryOptimizer {
    protected static final Pattern CORRELATED_WILDCARD_SPLIT = Pattern.compile("(([^*]+)/(\\*\\d+))/(.*)");
    protected static final Pattern CORRELATED_ECM_TAG = Pattern.compile("ecm:tag/\\*\\d+");
    protected static final String CORRELATED_ECM_TAG_IMPLICIT = "__ecm_tag_correlated__";

    public String getCorrelatedWildcardPrefix(String name) {
        if (name.startsWith("ecm:tag")) {
            if (name.equals("ecm:tag")) {
                return CORRELATED_ECM_TAG_IMPLICIT;
            }
            if (CORRELATED_ECM_TAG.matcher(name).matches()) {
                return name;
            }
            return "";
        }
        Matcher m = CORRELATED_WILDCARD_SPLIT.matcher(name);
        if (!m.matches()) {
            return "";
        }
        String start = m.group(2);
        String wildcard = m.group(3);
        String end = m.group(4);
        if (start.equals("ecm:acl")) {
            if (end.equals("name")) {
                return "ecm:acp/" + wildcard;
            }
            return "ecm:acp/" + wildcard + "/acl/" + wildcard;
        }
        return m.group(1);
    }
}

