/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.MLRequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.ml.CloseJobRequest;
import org.elasticsearch.client.ml.CloseJobResponse;
import org.elasticsearch.client.ml.DeleteCalendarRequest;
import org.elasticsearch.client.ml.DeleteDatafeedRequest;
import org.elasticsearch.client.ml.DeleteForecastRequest;
import org.elasticsearch.client.ml.DeleteJobRequest;
import org.elasticsearch.client.ml.DeleteJobResponse;
import org.elasticsearch.client.ml.FlushJobRequest;
import org.elasticsearch.client.ml.FlushJobResponse;
import org.elasticsearch.client.ml.ForecastJobRequest;
import org.elasticsearch.client.ml.ForecastJobResponse;
import org.elasticsearch.client.ml.GetBucketsRequest;
import org.elasticsearch.client.ml.GetBucketsResponse;
import org.elasticsearch.client.ml.GetCalendarsRequest;
import org.elasticsearch.client.ml.GetCalendarsResponse;
import org.elasticsearch.client.ml.GetCategoriesRequest;
import org.elasticsearch.client.ml.GetCategoriesResponse;
import org.elasticsearch.client.ml.GetDatafeedRequest;
import org.elasticsearch.client.ml.GetDatafeedResponse;
import org.elasticsearch.client.ml.GetDatafeedStatsRequest;
import org.elasticsearch.client.ml.GetDatafeedStatsResponse;
import org.elasticsearch.client.ml.GetInfluencersRequest;
import org.elasticsearch.client.ml.GetInfluencersResponse;
import org.elasticsearch.client.ml.GetJobRequest;
import org.elasticsearch.client.ml.GetJobResponse;
import org.elasticsearch.client.ml.GetJobStatsRequest;
import org.elasticsearch.client.ml.GetJobStatsResponse;
import org.elasticsearch.client.ml.GetOverallBucketsRequest;
import org.elasticsearch.client.ml.GetOverallBucketsResponse;
import org.elasticsearch.client.ml.GetRecordsRequest;
import org.elasticsearch.client.ml.GetRecordsResponse;
import org.elasticsearch.client.ml.OpenJobRequest;
import org.elasticsearch.client.ml.OpenJobResponse;
import org.elasticsearch.client.ml.PostDataRequest;
import org.elasticsearch.client.ml.PostDataResponse;
import org.elasticsearch.client.ml.PreviewDatafeedRequest;
import org.elasticsearch.client.ml.PreviewDatafeedResponse;
import org.elasticsearch.client.ml.PutCalendarRequest;
import org.elasticsearch.client.ml.PutCalendarResponse;
import org.elasticsearch.client.ml.PutDatafeedRequest;
import org.elasticsearch.client.ml.PutDatafeedResponse;
import org.elasticsearch.client.ml.PutJobRequest;
import org.elasticsearch.client.ml.PutJobResponse;
import org.elasticsearch.client.ml.StartDatafeedRequest;
import org.elasticsearch.client.ml.StartDatafeedResponse;
import org.elasticsearch.client.ml.StopDatafeedRequest;
import org.elasticsearch.client.ml.StopDatafeedResponse;
import org.elasticsearch.client.ml.UpdateJobRequest;

public final class MachineLearningClient {
    private final RestHighLevelClient restHighLevelClient;

    MachineLearningClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutJobResponse putJob(PutJobRequest request, RequestOptions options) throws IOException {
        return (PutJobResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::putJob, options, PutJobResponse::fromXContent, Collections.emptySet());
    }

    public void putJobAsync(PutJobRequest request, RequestOptions options, ActionListener<PutJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::putJob, options, PutJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetJobResponse getJob(GetJobRequest request, RequestOptions options) throws IOException {
        return (GetJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getJob, options, GetJobResponse::fromXContent, Collections.emptySet()));
    }

    public void getJobAsync(GetJobRequest request, RequestOptions options, ActionListener<GetJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getJob, options, GetJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetJobStatsResponse getJobStats(GetJobStatsRequest request, RequestOptions options) throws IOException {
        return (GetJobStatsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getJobStats, options, GetJobStatsResponse::fromXContent, Collections.emptySet()));
    }

    public void getJobStatsAsync(GetJobStatsRequest request, RequestOptions options, ActionListener<GetJobStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getJobStats, options, GetJobStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteJobResponse deleteJob(DeleteJobRequest request, RequestOptions options) throws IOException {
        return (DeleteJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::deleteJob, options, DeleteJobResponse::fromXContent, Collections.emptySet()));
    }

    public void deleteJobAsync(DeleteJobRequest request, RequestOptions options, ActionListener<DeleteJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::deleteJob, options, DeleteJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public OpenJobResponse openJob(OpenJobRequest request, RequestOptions options) throws IOException {
        return (OpenJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::openJob, options, OpenJobResponse::fromXContent, Collections.emptySet()));
    }

    public void openJobAsync(OpenJobRequest request, RequestOptions options, ActionListener<OpenJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::openJob, options, OpenJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public CloseJobResponse closeJob(CloseJobRequest request, RequestOptions options) throws IOException {
        return (CloseJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::closeJob, options, CloseJobResponse::fromXContent, Collections.emptySet()));
    }

    public void closeJobAsync(CloseJobRequest request, RequestOptions options, ActionListener<CloseJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::closeJob, options, CloseJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public FlushJobResponse flushJob(FlushJobRequest request, RequestOptions options) throws IOException {
        return (FlushJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::flushJob, options, FlushJobResponse::fromXContent, Collections.emptySet()));
    }

    public void flushJobAsync(FlushJobRequest request, RequestOptions options, ActionListener<FlushJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::flushJob, options, FlushJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public ForecastJobResponse forecastJob(ForecastJobRequest request, RequestOptions options) throws IOException {
        return (ForecastJobResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::forecastJob, options, ForecastJobResponse::fromXContent, Collections.emptySet()));
    }

    public void forecastJobAsync(ForecastJobRequest request, RequestOptions options, ActionListener<ForecastJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::forecastJob, options, ForecastJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteForecast(DeleteForecastRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::deleteForecast, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteForecastAsync(DeleteForecastRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::deleteForecast, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutDatafeedResponse putDatafeed(PutDatafeedRequest request, RequestOptions options) throws IOException {
        return (PutDatafeedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::putDatafeed, options, PutDatafeedResponse::fromXContent, Collections.emptySet());
    }

    public void putDatafeedAsync(PutDatafeedRequest request, RequestOptions options, ActionListener<PutDatafeedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::putDatafeed, options, PutDatafeedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetDatafeedResponse getDatafeed(GetDatafeedRequest request, RequestOptions options) throws IOException {
        return (GetDatafeedResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getDatafeed, options, GetDatafeedResponse::fromXContent, Collections.emptySet()));
    }

    public void getDatafeedAsync(GetDatafeedRequest request, RequestOptions options, ActionListener<GetDatafeedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getDatafeed, options, GetDatafeedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteDatafeed(DeleteDatafeedRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::deleteDatafeed, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteDatafeedAsync(DeleteDatafeedRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::deleteDatafeed, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartDatafeedResponse startDatafeed(StartDatafeedRequest request, RequestOptions options) throws IOException {
        return (StartDatafeedResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::startDatafeed, options, StartDatafeedResponse::fromXContent, Collections.emptySet()));
    }

    public void startDatafeedAsync(StartDatafeedRequest request, RequestOptions options, ActionListener<StartDatafeedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::startDatafeed, options, StartDatafeedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StopDatafeedResponse stopDatafeed(StopDatafeedRequest request, RequestOptions options) throws IOException {
        return (StopDatafeedResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::stopDatafeed, options, StopDatafeedResponse::fromXContent, Collections.emptySet()));
    }

    public void stopDatafeedAsync(StopDatafeedRequest request, RequestOptions options, ActionListener<StopDatafeedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::stopDatafeed, options, StopDatafeedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetDatafeedStatsResponse getDatafeedStats(GetDatafeedStatsRequest request, RequestOptions options) throws IOException {
        return (GetDatafeedStatsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getDatafeedStats, options, GetDatafeedStatsResponse::fromXContent, Collections.emptySet()));
    }

    public PreviewDatafeedResponse previewDatafeed(PreviewDatafeedRequest request, RequestOptions options) throws IOException {
        return (PreviewDatafeedResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::previewDatafeed, options, PreviewDatafeedResponse::fromXContent, Collections.emptySet()));
    }

    public void getDatafeedStatsAsync(GetDatafeedStatsRequest request, RequestOptions options, ActionListener<GetDatafeedStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getDatafeedStats, options, GetDatafeedStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public void previewDatafeedAsync(PreviewDatafeedRequest request, RequestOptions options, ActionListener<PreviewDatafeedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::previewDatafeed, options, PreviewDatafeedResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutJobResponse updateJob(UpdateJobRequest request, RequestOptions options) throws IOException {
        return (PutJobResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::updateJob, options, PutJobResponse::fromXContent, Collections.emptySet());
    }

    public void updateJobAsync(UpdateJobRequest request, RequestOptions options, ActionListener<PutJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::updateJob, options, PutJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetBucketsResponse getBuckets(GetBucketsRequest request, RequestOptions options) throws IOException {
        return (GetBucketsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getBuckets, options, GetBucketsResponse::fromXContent, Collections.emptySet()));
    }

    public void getBucketsAsync(GetBucketsRequest request, RequestOptions options, ActionListener<GetBucketsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getBuckets, options, GetBucketsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetCategoriesResponse getCategories(GetCategoriesRequest request, RequestOptions options) throws IOException {
        return (GetCategoriesResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getCategories, options, GetCategoriesResponse::fromXContent, Collections.emptySet()));
    }

    public void getCategoriesAsync(GetCategoriesRequest request, RequestOptions options, ActionListener<GetCategoriesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getCategories, options, GetCategoriesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetOverallBucketsResponse getOverallBuckets(GetOverallBucketsRequest request, RequestOptions options) throws IOException {
        return (GetOverallBucketsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getOverallBuckets, options, GetOverallBucketsResponse::fromXContent, Collections.emptySet()));
    }

    public void getOverallBucketsAsync(GetOverallBucketsRequest request, RequestOptions options, ActionListener<GetOverallBucketsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getOverallBuckets, options, GetOverallBucketsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRecordsResponse getRecords(GetRecordsRequest request, RequestOptions options) throws IOException {
        return (GetRecordsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getRecords, options, GetRecordsResponse::fromXContent, Collections.emptySet()));
    }

    public void getRecordsAsync(GetRecordsRequest request, RequestOptions options, ActionListener<GetRecordsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getRecords, options, GetRecordsResponse::fromXContent, listener, Collections.emptySet());
    }

    public PostDataResponse postData(PostDataRequest request, RequestOptions options) throws IOException {
        return (PostDataResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::postData, options, PostDataResponse::fromXContent, Collections.emptySet()));
    }

    public void postDataAsync(PostDataRequest request, RequestOptions options, ActionListener<PostDataResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::postData, options, PostDataResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetCalendarsResponse getCalendars(GetCalendarsRequest request, RequestOptions options) throws IOException {
        return (GetCalendarsResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getCalendars, options, GetCalendarsResponse::fromXContent, Collections.emptySet()));
    }

    public void getCalendarsAsync(GetCalendarsRequest request, RequestOptions options, ActionListener<GetCalendarsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getCalendars, options, GetCalendarsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetInfluencersResponse getInfluencers(GetInfluencersRequest request, RequestOptions options) throws IOException {
        return (GetInfluencersResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::getInfluencers, options, GetInfluencersResponse::fromXContent, Collections.emptySet()));
    }

    public void getInfluencersAsync(GetInfluencersRequest request, RequestOptions options, ActionListener<GetInfluencersResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::getInfluencers, options, GetInfluencersResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutCalendarResponse putCalendar(PutCalendarRequest request, RequestOptions options) throws IOException {
        return (PutCalendarResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::putCalendar, options, PutCalendarResponse::fromXContent, Collections.emptySet());
    }

    public void putCalendarAsync(PutCalendarRequest request, RequestOptions options, ActionListener<PutCalendarResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::putCalendar, options, PutCalendarResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteCalendar(DeleteCalendarRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, MLRequestConverters::deleteCalendar, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteCalendarAsync(DeleteCalendarRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, MLRequestConverters::deleteCalendar, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

