/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class ACLJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "acls";
    public static final String USERNAME_PROPERTY = "username";
    public static final String CREATOR_PROPERTY = "creator";
    public static final String EXTENDED_ACLS_PROPERTY = "extended";
    public static final String COMPATIBILITY_CONFIGURATION_PARAM = "nuxeo.permissions.acl.enricher.compatibility";

    public ACLJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        ACP item = document.getACP();
        jg.writeArrayFieldStart(NAME);
        for (ACL acl : item.getACLs()) {
            jg.writeStartObject();
            jg.writeStringField("name", acl.getName());
            this.writeACEsField(jg, "aces", acl, document);
            ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
            if (configurationService.isBooleanTrue(COMPATIBILITY_CONFIGURATION_PARAM)) {
                this.writeACEsField(jg, "ace", acl, document);
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    protected void writeACEsField(JsonGenerator jg, String fieldName, ACL acl, DocumentModel document) throws IOException {
        jg.writeArrayFieldStart(fieldName);
        for (ACE ace : acl.getACEs()) {
            jg.writeStartObject();
            jg.writeStringField("id", ace.getId());
            String username = ace.getUsername();
            this.writePrincipalOrGroup(USERNAME_PROPERTY, username, jg);
            jg.writeBooleanField("externalUser", NuxeoPrincipal.isTransientUsername((String)username));
            jg.writeStringField("permission", ace.getPermission());
            jg.writeBooleanField("granted", ace.isGranted());
            this.writePrincipalOrGroup(CREATOR_PROPERTY, ace.getCreator(), jg);
            jg.writeStringField("begin", DateUtils.formatISODateTime((Calendar)ace.getBegin()));
            jg.writeStringField("end", DateUtils.formatISODateTime((Calendar)ace.getEnd()));
            jg.writeStringField("status", ace.getStatus().toString().toLowerCase());
            if (this.ctx.getFetched(NAME).contains(EXTENDED_ACLS_PROPERTY)) {
                Map<String, Serializable> m = this.computeAdditionalFields(document, acl.getName(), ace.getId());
                for (Map.Entry<String, Serializable> entry : m.entrySet()) {
                    jg.writeObjectField(entry.getKey(), (Object)entry.getValue());
                }
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    protected void writePrincipalOrGroup(String propertyName, String value, JsonGenerator jg) throws IOException {
        if (value != null && this.ctx.getFetched(NAME).contains(propertyName)) {
            try (Closeable resource = this.ctx.wrap().controlDepth().open();){
                UserManager userManager = (UserManager)Framework.getService(UserManager.class);
                NuxeoPrincipal entity = userManager.getPrincipal(value);
                if (entity == null) {
                    entity = userManager.getGroup(value);
                }
                if (entity != null) {
                    this.writeEntityField(propertyName, entity, jg);
                    return;
                }
            }
            catch (MaxDepthReachedException maxDepthReachedException) {
                // empty catch block
            }
        }
        jg.writeStringField(propertyName, value);
    }

    protected Map<String, Serializable> computeAdditionalFields(DocumentModel doc, String aclName, String aceId) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        Framework.doPrivileged(() -> {
            try (Session session = directoryService.open("aceinfo");){
                String id = this.computeDirectoryId(doc, aclName, aceId);
                DocumentModel entry = session.getEntry(id);
                if (entry != null) {
                    m.put("notify", entry.getPropertyValue("aceinfo:notify"));
                    m.put("comment", entry.getPropertyValue("aceinfo:comment"));
                }
            }
        });
        return m;
    }

    protected String computeDirectoryId(DocumentModel doc, String aclName, String aceId) {
        return String.format("%s:%s:%s:%s", doc.getId(), doc.getRepositoryName(), aclName, aceId);
    }
}

