/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SCQIndexing
implements Demarshallable,
WriteMarshallable,
Closeable {
    private static final boolean IGNORE_INDEXING_FAILURE = Boolean.getBoolean("queue.ignoreIndexingFailure");
    private static Boolean REPORT_LINEAR_SCAN = Boolean.getBoolean("chronicle.queue.report.linear.scan.latency");
    final LongValue nextEntryToBeIndexed;
    private final int indexCount;
    private final int indexCountBits;
    private final int indexSpacing;
    private final int indexSpacingBits;
    private final LongValue index2Index;
    private final Supplier<LongArrayValues> longArraySupplier;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> index2indexArray;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> indexArray;
    @NotNull
    private final WriteMarshallable index2IndexTemplate;
    @NotNull
    private final WriteMarshallable indexTemplate;
    LongValue writePosition;
    Sequence sequence;
    int linearScanCount;

    @UsedViaReflection
    private SCQIndexing(@NotNull WireIn wire) {
        this(wire.read((WireKey)IndexingFields.indexCount).int32(), wire.read((WireKey)IndexingFields.indexSpacing).int32(), wire.read((WireKey)IndexingFields.index2Index).int64ForBinding(wire.newLongReference()), wire.read((WireKey)IndexingFields.lastIndex).int64ForBinding(wire.newLongReference()), () -> ((WireIn)wire).newLongArrayReference());
    }

    SCQIndexing(@NotNull WireType wireType, int indexCount, int indexSpacing) {
        this(indexCount, indexSpacing, (LongValue)wireType.newLongReference().get(), (LongValue)wireType.newLongReference().get(), wireType.newLongArrayReference());
    }

    private SCQIndexing(int indexCount, int indexSpacing, LongValue index2Index, LongValue nextEntryToBeIndexed, Supplier<LongArrayValues> longArraySupplier) {
        this.indexCount = indexCount;
        this.indexCountBits = Maths.intLog2(indexCount);
        this.indexSpacing = indexSpacing;
        this.indexSpacingBits = Maths.intLog2(indexSpacing);
        this.index2Index = index2Index;
        this.nextEntryToBeIndexed = nextEntryToBeIndexed;
        this.longArraySupplier = longArraySupplier;
        this.index2indexArray = new ThreadLocal();
        this.indexArray = new ThreadLocal();
        this.index2IndexTemplate = w -> w.writeEventName(() -> "index2index").int64array((long)indexCount);
        this.indexTemplate = w -> w.writeEventName(() -> "index").int64array((long)indexCount);
    }

    @NotNull
    private LongArrayValuesHolder getIndex2IndexArray() {
        return ThreadLocalHelper.getTL(this.index2indexArray, this.longArraySupplier, las -> new LongArrayValuesHolder((LongArrayValues)las.get()));
    }

    @NotNull
    private LongArrayValuesHolder getIndexArray() {
        return ThreadLocalHelper.getTL(this.indexArray, this.longArraySupplier, las -> new LongArrayValuesHolder((LongArrayValues)las.get()));
    }

    public long toAddress0(long index) {
        long siftedIndex = index >> this.indexSpacingBits + this.indexCountBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    long toAddress1(long index) {
        long siftedIndex = index >> this.indexSpacingBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    @Override
    public void close() {
        Closeable.closeQuietly((Object)this.index2Index);
        Closeable.closeQuietly((Object)this.nextEntryToBeIndexed);
        this.closeTL(this.indexArray);
        this.closeTL(this.index2indexArray);
    }

    private void closeTL(ThreadLocal<WeakReference<LongArrayValuesHolder>> tl) {
        WeakReference<LongArrayValuesHolder> weakReference = tl.get();
        if (weakReference == null) {
            return;
        }
        LongArrayValuesHolder holder = (LongArrayValuesHolder)weakReference.get();
        if (holder != null) {
            Closeable.closeQuietly((Object)holder.values);
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)IndexingFields.indexCount).int64((long)this.indexCount).write((WireKey)IndexingFields.indexSpacing).int64((long)this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(0L, this.nextEntryToBeIndexed);
    }

    @NotNull
    private LongArrayValues arrayForAddress(@NotNull Wire wire, long secondaryAddress) {
        LongArrayValuesHolder holder = this.getIndexArray();
        if (holder.address == secondaryAddress) {
            return holder.values;
        }
        holder.address = secondaryAddress;
        wire.bytes().readPositionRemaining(secondaryAddress, 4L);
        wire.readMetaDataHeader();
        return this.array((WireIn)wire, holder.values, false);
    }

    @NotNull
    private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using, boolean index2index) {
        String name;
        StringBuilder sb = Wires.acquireStringBuilder();
        ValueIn valueIn = w.readEventName(sb);
        String string = name = index2index ? "index2index" : "index";
        if (!name.contentEquals(sb)) {
            throw new IllegalStateException("expecting index, was " + sb);
        }
        valueIn.int64array(using, (Object)this, (o1, o2) -> {});
        return using;
    }

    long newIndex(@NotNull WireOut wire, boolean index2index) throws StreamCorruptedException {
        long writePosition = this.writePosition.getVolatileValue();
        Bytes bytes = wire.bytes();
        bytes.writePosition(writePosition);
        long position = wire.enterHeader(this.indexCount * 8 + 128);
        WriteMarshallable writer = index2index ? this.index2IndexTemplate : this.indexTemplate;
        writer.writeMarshallable(wire);
        wire.updateHeader(position, true, 0);
        return position;
    }

    long newIndex(@NotNull Wire wire, @NotNull LongArrayValues index2Index, long index2) throws StreamCorruptedException {
        long pos = this.newIndex((WireOut)wire, false);
        if (!index2Index.compareAndSet(index2, 0L, pos)) {
            throw new IllegalStateException("Index " + index2 + " in index2index was altered while we hold the write lock!");
        }
        index2Index.setMaxUsed(index2 + 1L);
        return pos;
    }

    @NotNull
    ScanResult moveToIndex(@NotNull ExcerptContext ec, long index) {
        return Optional.ofNullable(this.moveToIndex0(ec, index)).orElseGet(() -> this.moveToIndexFromTheStart(ec, index));
    }

    @NotNull
    private ScanResult moveToIndexFromTheStart(@NotNull ExcerptContext ec, long index) {
        try {
            Wire wire = ec.wire();
            wire.bytes().readPositionUnlimited(0L);
            if (wire.readDataHeader()) {
                return this.linearScan(wire, index, 0L, wire.bytes().readPosition());
            }
        }
        catch (EOFException fallback) {
            return ScanResult.END_OF_FILE;
        }
        return ScanResult.NOT_FOUND;
    }

    @Nullable
    ScanResult moveToIndex0(@NotNull ExcerptContext ec, long index) {
        try {
            Wire wire = ec.wireForIndex();
            LongArrayValues index2index = this.getIndex2index(wire);
            long secondaryAddress = 0L;
            long startIndex = index & (long)(-this.indexSpacing);
            for (long primaryOffset = this.toAddress0(index); primaryOffset >= 0L && (secondaryAddress = index2index.getValueAt(primaryOffset)) == 0L; --primaryOffset) {
                startIndex -= (long)(this.indexCount * this.indexSpacing);
            }
            if (secondaryAddress <= 0L) {
                return null;
            }
            LongArrayValues array1 = this.arrayForAddress(wire, secondaryAddress);
            long secondaryOffset = this.toAddress1(index);
            do {
                long fromAddress;
                if ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                    startIndex -= (long)this.indexSpacing;
                    continue;
                }
                if (index == startIndex) {
                    ec.wire().bytes().readPositionUnlimited(fromAddress);
                    return ScanResult.FOUND;
                }
                return this.linearScan(ec.wire(), index, startIndex, fromAddress);
            } while (--secondaryOffset >= 0L);
            return null;
        }
        catch (IllegalStateException e) {
            return this.linearScan(ec.wire(), index, -1L, 0L);
        }
    }

    @NotNull
    private ScanResult linearScan(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        long start = System.nanoTime();
        if (toIndex == fromKnownIndex) {
            return ScanResult.FOUND;
        }
        ScanResult scanResult = this.linearScan0(wire, toIndex, fromKnownIndex, knownAddress);
        if (REPORT_LINEAR_SCAN.booleanValue()) {
            this.checkLinearScanTime(toIndex, fromKnownIndex, start);
        }
        return scanResult;
    }

    private void checkLinearScanTime(long toIndex, long fromKnownIndex, long start) {
        long end = System.nanoTime();
        if ((double)end > (double)start + 50000.0) {
            assert (this.printLinearScanTime(toIndex, fromKnownIndex, start, end, "linearScan by index"));
        } else if (fromKnownIndex > 181502156833030144L) {
            Jvm.debug().on(this.getClass(), "Unexpectedly high " + TimeUnit.NANOSECONDS.toMicros(end - start) + "us fromKnownIndex 0x" + Long.toHexString(fromKnownIndex) + " to 0x" + Long.toHexString(toIndex) + "= ( 0x" + Long.toHexString(toIndex) + "- 0x" + Long.toHexString(fromKnownIndex) + ") = " + (toIndex - fromKnownIndex), new StackTrace("This is a profile stack trace, not an ERROR"));
        }
    }

    private boolean printLinearScanTime(long toIndex, long fromKnownIndex, long start, long end, String desc) {
        int time;
        Jvm.warn().on(this.getClass(), "Took " + (end - start) / 1000L + " us to " + desc + " from " + fromKnownIndex + " to " + toIndex + " = (0x" + Long.toHexString(toIndex) + "-0x" + Long.toHexString(fromKnownIndex) + ")=" + (toIndex - fromKnownIndex));
        int n = time = Jvm.isArm() ? 20000000 : 250000;
        if (toIndex > 0L && end > start + (long)time) {
            Jvm.debug().on(this.getClass(), new StackTrace("This is a profile stack trace, not an ERROR"));
        }
        return true;
    }

    @NotNull
    private ScanResult linearScan0(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        ++this.linearScanCount;
        Bytes bytes = wire.bytes();
        long lastAddress = this.writePosition.getVolatileValue();
        long lastIndex = this.sequence.getSequence(lastAddress);
        if (toIndex == lastIndex) {
            assert (lastAddress >= knownAddress && lastIndex >= fromKnownIndex);
            knownAddress = lastAddress;
            fromKnownIndex = lastIndex;
        }
        bytes.readPositionUnlimited(knownAddress);
        long i = fromKnownIndex;
        while (true) {
            block8: {
                block7: {
                    try {
                        if (!wire.readDataHeader()) break block7;
                        if (i == toIndex) {
                            return ScanResult.FOUND;
                        }
                        int header = bytes.readVolatileInt();
                        if (Wires.isNotComplete((int)header)) {
                            return ScanResult.NOT_REACHED;
                        }
                        bytes.readSkip((long)Wires.lengthOf((int)header));
                        break block8;
                    }
                    catch (EOFException fallback) {
                        if (i != toIndex) break block7;
                        return ScanResult.END_OF_FILE;
                    }
                }
                return i == toIndex ? ScanResult.NOT_FOUND : ScanResult.NOT_REACHED;
            }
            ++i;
        }
    }

    ScanResult linearScanTo(long toIndex, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.linearScan(ec.wire(), toIndex, knownIndex, knownAddress);
    }

    long linearScanByPosition(@NotNull Wire wire, long toPosition, long indexOfNext, long startAddress, boolean inclusive) throws EOFException {
        int time;
        long start = System.nanoTime();
        long index = this.linearScanByPosition0(wire, toPosition, indexOfNext, startAddress, inclusive);
        long end = System.nanoTime();
        int n = time = Jvm.isArm() ? 1000000 : 50000;
        if (end > start + (long)time) {
            this.printLinearScanTime(toPosition, startAddress, start, end, "linearScan by position");
        }
        return index;
    }

    long linearScanByPosition0(@NotNull Wire wire, long toPosition, long indexOfNext, long startAddress, boolean inclusive) throws EOFException {
        long i;
        assert (toPosition >= 0L);
        Bytes bytes = wire.bytes();
        long lastAddress = this.writePosition.getVolatileValue();
        long lastIndex = this.sequence.getSequence(lastAddress);
        if (lastAddress > 0L && toPosition == lastAddress && lastIndex != -1L && lastIndex != Long.MIN_VALUE) {
            bytes.readPositionUnlimited(toPosition);
            i = lastIndex - 1L;
        } else {
            bytes.readPositionUnlimited(startAddress);
            i = indexOfNext - 1L;
        }
        while (bytes.readPosition() <= toPosition) {
            int header;
            WireIn.HeaderType headerType;
            try {
                headerType = wire.readDataHeader(true);
            }
            catch (EOFException e) {
                if (toPosition == Long.MAX_VALUE) {
                    return i;
                }
                throw e;
            }
            if (!inclusive && toPosition == bytes.readPosition()) {
                return i;
            }
            switch (headerType) {
                case NONE: {
                    if (toPosition == Long.MAX_VALUE) {
                        return i;
                    }
                    header = bytes.readVolatileInt(bytes.readPosition());
                    throw new IllegalArgumentException("You can't know the index for an entry which hasn't been written. start: " + startAddress + ", at: " + bytes.readPosition() + ", header: " + Integer.toHexString(header) + ", toPos: " + toPosition);
                }
                case META_DATA: {
                    break;
                }
                case DATA: {
                    ++i;
                }
            }
            if (bytes.readPosition() == toPosition) {
                return i;
            }
            header = bytes.readVolatileInt();
            int len = Wires.lengthOf((int)header);
            assert (Wires.isReady((int)header));
            bytes.readSkip((long)len);
        }
        throw new IllegalArgumentException("position not the start of a message, bytes.readPosition()=" + bytes.readPosition() + ",toPosition=" + toPosition);
    }

    long nextEntryToBeIndexed() {
        return this.nextEntryToBeIndexed.getVolatileValue();
    }

    long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean inclusive) throws StreamCorruptedException {
        Wire wire;
        long lastKnownAddress;
        long indexOfNext;
        block10: {
            indexOfNext = 0L;
            lastKnownAddress = 0L;
            wire = ec.wireForIndex();
            try {
                LongArrayValues index2indexArr = this.getIndex2index(wire);
                int used2 = Maths.toUInt31(index2indexArr.getUsed());
                assert (used2 > 0);
                for (int index2 = used2 - 1; index2 >= 0; --index2) {
                    long secondaryAddress = this.getSecondaryAddress(wire, index2indexArr, index2);
                    if (secondaryAddress == 0L) continue;
                    LongArrayValues indexValues = this.arrayForAddress(wire, secondaryAddress);
                    int used = Maths.toUInt31(indexValues.getUsed());
                    assert (used >= 0);
                    if (used == 0) continue;
                    long posN = indexValues.getVolatileValueAt(0L);
                    assert (posN >= 0L);
                    if (posN > position) continue;
                    for (int index1 = used - 1; index1 >= 0; --index1) {
                        long pos = indexValues.getVolatileValueAt(index1);
                        if (pos == 0L || pos > position) continue;
                        lastKnownAddress = pos;
                        indexOfNext = ((long)index2 << this.indexCountBits + this.indexSpacingBits) + (long)(index1 << this.indexSpacingBits);
                        if (lastKnownAddress == position) {
                            return indexOfNext;
                        }
                        break block10;
                    }
                }
            }
            catch (IllegalStateException e) {
                if (!Jvm.isDebugEnabled(this.getClass())) break block10;
                Jvm.debug().on(this.getClass(), "Attempt to find " + Long.toHexString(position), e);
            }
        }
        try {
            return this.linearScanByPosition(wire, position, indexOfNext, lastKnownAddress, inclusive);
        }
        catch (EOFException e) {
            throw new IllegalStateException(e);
        }
    }

    void initIndex(@NotNull Wire wire) throws StreamCorruptedException {
        long index2Index = this.index2Index.getVolatileValue();
        if (index2Index != 0L) {
            throw new IllegalStateException("Who wrote the index2index?");
        }
        long index = this.newIndex((WireOut)wire, true);
        this.index2Index.compareAndSwapValue(0L, index);
        LongArrayValues index2index = this.getIndex2index(wire);
        this.newIndex(wire, index2index, 0L);
    }

    private LongArrayValues getIndex2index(@NotNull Wire wire) throws UnrecoverableTimeoutException {
        LongArrayValuesHolder holder = this.getIndex2IndexArray();
        LongArrayValues values = holder.values;
        if (((Byteable)values).bytesStore() != null) {
            return values;
        }
        long indexToIndex = this.index2Index.getVolatileValue();
        try (DocumentContext ignored = wire.readingDocument(indexToIndex);){
            LongArrayValues longArrayValues = this.array((WireIn)wire, values, true);
            return longArrayValues;
        }
    }

    private long getSecondaryAddress(@NotNull Wire wire, @NotNull LongArrayValues index2indexArr, int index2) throws UnrecoverableTimeoutException, StreamCorruptedException {
        long secondaryAddress = index2indexArr.getVolatileValueAt(index2);
        if (secondaryAddress == 0L) {
            secondaryAddress = this.newIndex(wire, index2indexArr, index2);
            long sa = index2indexArr.getValueAt(index2);
            if (sa != secondaryAddress) {
                throw new AssertionError();
            }
        }
        return secondaryAddress;
    }

    void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        if (!this.indexable(sequenceNumber)) {
            return;
        }
        Wire wire = ec.wireForIndex();
        Bytes bytes = wire.bytes();
        if (position > bytes.capacity()) {
            throw new IllegalArgumentException("pos: " + position);
        }
        LongArrayValues index2indexArr = this.getIndex2index(wire);
        if (((Byteable)index2indexArr).bytesStore() == null) {
            assert (false);
            return;
        }
        int index2 = (int)(sequenceNumber >>> this.indexCountBits + this.indexSpacingBits);
        if (index2 >= this.indexCount) {
            if (IGNORE_INDEXING_FAILURE) {
                return;
            }
            throw new IllegalStateException("Unable to index " + sequenceNumber);
        }
        long secondaryAddress = this.getSecondaryAddress(wire, index2indexArr, index2);
        if (secondaryAddress > bytes.capacity()) {
            throw new IllegalStateException("sa2: " + secondaryAddress);
        }
        bytes.readLimit(bytes.capacity());
        LongArrayValues indexValues = this.arrayForAddress(wire, secondaryAddress);
        int index3 = (int)(sequenceNumber >>> this.indexSpacingBits & (long)(this.indexCount - 1));
        long posN = indexValues.getValueAt(index3);
        if (posN == 0L) {
            indexValues.setValueAt(index3, position);
            indexValues.setMaxUsed(index3 + 1);
        } else assert (posN == position);
        this.nextEntryToBeIndexed.setMaxValue(sequenceNumber + (long)this.indexSpacing);
    }

    public boolean indexable(long index) {
        return (index & (long)(this.indexSpacing - 1)) == 0L;
    }

    public long lastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        Sequence sequence1 = this.sequence;
        if (sequence1 != null) {
            for (int i = 0; i < 128; ++i) {
                long address = this.writePosition.getVolatileValue();
                if (address == 0L) {
                    return -1L;
                }
                long sequence = sequence1.getSequence(address);
                if (sequence == Long.MIN_VALUE) continue;
                if (sequence == -1L) break;
                return sequence;
            }
        }
        return this.sequenceForPosition(ec, Long.MAX_VALUE, false);
    }

    int indexCount() {
        return this.indexCount;
    }

    int indexSpacing() {
        return this.indexSpacing;
    }

    long moveToEnd(Wire wire) {
        Sequence sequence1 = this.sequence;
        if (sequence1 != null) {
            for (int i = 0; i < 128; ++i) {
                long endAddress = this.writePosition.getVolatileValue();
                if (endAddress == 0L) {
                    return -1L;
                }
                long sequence = sequence1.getSequence(endAddress);
                if (sequence == Long.MIN_VALUE) continue;
                if (sequence == -1L) {
                    return -1L;
                }
                Bytes bytes = wire.bytes();
                bytes.readPosition(endAddress);
                int header;
                while ((header = bytes.readVolatileInt(endAddress)) != 0 && !Wires.isNotComplete((int)header)) {
                    int len = Wires.lengthOf((int)header) + 4;
                    bytes.readSkip((long)len);
                    endAddress += (long)len;
                    if (!Wires.isData((int)header)) continue;
                    ++sequence;
                }
                return sequence;
            }
        }
        return -1L;
    }

    static class LongArrayValuesHolder {
        final LongArrayValues values;
        long address;

        LongArrayValuesHolder(LongArrayValues values) {
            this.values = values;
            this.address = Long.MIN_VALUE;
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }
}

