/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.FulltextConfigurationFactory;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.runtime.api.Framework;

public class Model {
    private static final Log log = LogFactory.getLog(Model.class);
    public static final String ROOT_TYPE = "Root";
    public static final String REPOINFO_TABLE_NAME = "repositories";
    public static final String REPOINFO_REPONAME_KEY = "name";
    public static final String MAIN_KEY = "id";
    public static final String CLUSTER_NODES_TABLE_NAME = "cluster_nodes";
    public static final String CLUSTER_NODES_NODEID_KEY = "nodeid";
    public static final String CLUSTER_NODES_CREATED_KEY = "created";
    public static final String CLUSTER_INVALS_TABLE_NAME = "cluster_invals";
    public static final String CLUSTER_INVALS_NODEID_KEY = "nodeid";
    public static final String CLUSTER_INVALS_ID_KEY = "id";
    public static final String CLUSTER_INVALS_FRAGMENTS_KEY = "fragments";
    public static final String CLUSTER_INVALS_KIND_KEY = "kind";
    public static final String MAIN_PRIMARY_TYPE_PROP = "ecm:primaryType";
    public static final String MAIN_PRIMARY_TYPE_KEY = "primarytype";
    public static final String MAIN_MIXIN_TYPES_PROP = "ecm:mixinTypes";
    public static final String MAIN_MIXIN_TYPES_KEY = "mixintypes";
    public static final String MAIN_IS_RETENTION_ACTIVE_PROP = "ecm:isRetentionActive";
    public static final String MAIN_IS_RETENTION_ACTIVE_KEY = "isretentionactive";
    public static final String MAIN_BASE_VERSION_PROP = "ecm:baseVersion";
    public static final String MAIN_BASE_VERSION_KEY = "baseversionid";
    public static final String MAIN_CHECKED_IN_PROP = "ecm:isCheckedIn";
    public static final String MAIN_CHECKED_IN_KEY = "ischeckedin";
    public static final String MAIN_MAJOR_VERSION_PROP = "ecm:majorVersion";
    public static final String MAIN_MAJOR_VERSION_KEY = "majorversion";
    public static final String MAIN_MINOR_VERSION_PROP = "ecm:minorVersion";
    public static final String MAIN_MINOR_VERSION_KEY = "minorversion";
    public static final String MAIN_IS_VERSION_PROP = "ecm:isVersion";
    public static final String MAIN_IS_VERSION_KEY = "isversion";
    public static final String MAIN_SYS_CHANGE_TOKEN_PROP = "ecm:systemChangeToken";
    public static final String MAIN_SYS_CHANGE_TOKEN_KEY = "systemchangetoken";
    public static final String MAIN_CHANGE_TOKEN_PROP = "ecm:changeToken";
    public static final String MAIN_CHANGE_TOKEN_KEY = "changetoken";
    public static final String MAIN_IS_DELETED_PROP = "ecm:isDeleted";
    public static final String MAIN_IS_DELETED_KEY = "isdeleted";
    public static final String MAIN_DELETED_TIME_PROP = "ecm:deletedTime";
    public static final String MAIN_DELETED_TIME_KEY = "deletedtime";
    public static final String MAIN_IS_TRASHED_PROP = "ecm:isTrashed";
    public static final String MAIN_IS_TRASHED_KEY = "istrashed";
    public static final String UID_SCHEMA_NAME = "uid";
    public static final String UID_MAJOR_VERSION_KEY = "major_version";
    public static final String UID_MINOR_VERSION_KEY = "minor_version";
    public static final String HIER_TABLE_NAME = "hierarchy";
    public static final String HIER_PARENT_KEY = "parentid";
    public static final String HIER_CHILD_NAME_KEY = "name";
    public static final String HIER_CHILD_POS_KEY = "pos";
    public static final String HIER_CHILD_ISPROPERTY_KEY = "isproperty";
    public static final String ANCESTORS_TABLE_NAME = "ancestors";
    public static final String ANCESTORS_ANCESTOR_KEY = "ancestors";
    public static final String COLL_TABLE_POS_KEY = "pos";
    public static final String COLL_TABLE_VALUE_KEY = "item";
    public static final String MISC_TABLE_NAME = "misc";
    public static final String MISC_LIFECYCLE_POLICY_PROP = "ecm:lifeCyclePolicy";
    public static final String MISC_LIFECYCLE_POLICY_KEY = "lifecyclepolicy";
    public static final String MISC_LIFECYCLE_STATE_PROP = "ecm:lifeCycleState";
    public static final String MISC_LIFECYCLE_STATE_KEY = "lifecyclestate";
    public static final String ACL_TABLE_NAME = "acls";
    public static final String ACL_PROP = "ecm:acl";
    public static final String ACL_POS_KEY = "pos";
    public static final String ACL_NAME_KEY = "name";
    public static final String ACL_GRANT_KEY = "grant";
    public static final String ACL_PERMISSION_KEY = "permission";
    public static final String ACL_CREATOR_KEY = "creator";
    public static final String ACL_BEGIN_KEY = "begin";
    public static final String ACL_END_KEY = "end";
    public static final String ACL_STATUS_KEY = "status";
    public static final String ACL_USER_KEY = "user";
    public static final String ACL_GROUP_KEY = "group";
    public static final String VERSION_TABLE_NAME = "versions";
    public static final String VERSION_VERSIONABLE_PROP = "ecm:versionableId";
    public static final String VERSION_VERSIONABLE_KEY = "versionableid";
    public static final String VERSION_CREATED_PROP = "ecm:versionCreated";
    public static final String VERSION_CREATED_KEY = "created";
    public static final String VERSION_LABEL_PROP = "ecm:versionLabel";
    public static final String VERSION_LABEL_KEY = "label";
    public static final String VERSION_DESCRIPTION_PROP = "ecm:versionDescription";
    public static final String VERSION_DESCRIPTION_KEY = "description";
    public static final String VERSION_IS_LATEST_PROP = "ecm:isLatestVersion";
    public static final String VERSION_IS_LATEST_KEY = "islatest";
    public static final String VERSION_IS_LATEST_MAJOR_PROP = "ecm:isLatestMajorVersion";
    public static final String VERSION_IS_LATEST_MAJOR_KEY = "islatestmajor";
    public static final String PROXY_TYPE = "ecm:proxy";
    public static final String PROXY_TABLE_NAME = "proxies";
    public static final String PROXY_TARGET_PROP = "ecm:proxyTargetId";
    public static final String PROXY_TARGET_KEY = "targetid";
    public static final String PROXY_VERSIONABLE_PROP = "ecm:proxyVersionableId";
    public static final String PROXY_VERSIONABLE_KEY = "versionableid";
    public static final String LOCK_TABLE_NAME = "locks";
    public static final String LOCK_OWNER_PROP = "ecm:lockOwner";
    public static final String LOCK_OWNER_KEY = "owner";
    public static final String LOCK_CREATED_PROP = "ecm:lockCreated";
    public static final String LOCK_CREATED_KEY = "created";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";
    public static final String FULLTEXT_TABLE_NAME = "fulltext";
    public static final String FULLTEXT_JOBID_PROP = "ecm:fulltextJobId";
    public static final String FULLTEXT_JOBID_KEY = "jobid";
    public static final String FULLTEXT_FULLTEXT_PROP = "ecm:fulltext";
    public static final String FULLTEXT_FULLTEXT_KEY = "fulltext";
    public static final String FULLTEXT_SIMPLETEXT_PROP = "ecm:simpleText";
    public static final String FULLTEXT_SIMPLETEXT_KEY = "simpletext";
    public static final String FULLTEXT_BINARYTEXT_PROP = "ecm:binaryText";
    public static final String FULLTEXT_BINARYTEXT_KEY = "binarytext";
    public static final String HIER_READ_ACL_TABLE_NAME = "hierarchy_read_acl";
    public static final String HIER_READ_ACL_ID = "id";
    public static final String HIER_READ_ACL_ACL_ID = "acl_id";
    public static final String ACLR_USER_MAP_TABLE_NAME = "aclr_user_map";
    public static final String ACLR_USER_MAP_USER_ID = "user_id";
    public static final String ACLR_USER_MAP_ACL_ID = "acl_id";
    public static final String FIELD_TYPE_LARGETEXT = "largetext";
    public static final String FIELD_TYPE_ARRAY = "array";
    public static final String FIELD_TYPE_ARRAY_LARGETEXT = "array_largetext";
    public static final Long NO_SUCH_LONG_ID = 3554207061629718180L;
    public static final Long INITIAL_CHANGE_TOKEN = 0L;
    public static final Long INITIAL_SYS_CHANGE_TOKEN = 0L;
    protected final boolean softDeleteEnabled;
    protected final boolean proxiesEnabled;
    protected final boolean changeTokenEnabled;
    protected final IdType idType;
    protected final PropertyType idPropertyType;
    protected final Type idCoreType;
    protected final boolean miscInHierarchy;
    protected final RepositoryDescriptor repositoryDescriptor;
    private final Map<String, Set<String>> allDocTypeSchemas;
    private final Map<String, Set<String>> allMixinSchemas;
    private final Set<String> allProxySchemas;
    private final Map<String, Set<String>> mixinsDocumentTypes;
    protected final Map<String, Set<String>> documentTypesMixins;
    private final Map<String, Type> specialPropertyTypes;
    private final Map<String, Map<String, ModelProperty>> fragmentPropertyInfos;
    private final Map<String, Map<String, ModelProperty>> schemaPropertyInfos;
    private final Map<String, Map<String, ModelProperty>> typePropertyInfos;
    private final Map<String, Map<String, ModelProperty>> mixinPropertyInfos;
    private final Map<String, ModelProperty> proxyPropertyInfos;
    private final Map<String, ModelProperty> sharedPropertyInfos;
    private final Map<String, ModelProperty> mergedPropertyInfos;
    private final Map<String, Map<String, ModelProperty>> schemaPathPropertyInfos;
    private final Map<String, String> prefixToSchema;
    private final Map<String, Set<String>> schemaSimpleTextPaths;
    private final Map<String, ModelProperty> allPathPropertyInfos;
    private final Map<String, Map<String, ColumnType>> fragmentKeyTypes;
    private final Map<String, List<String>> binaryFragmentKeys;
    private final Map<String, PropertyType> collectionTables;
    private final Map<String, String> collectionOrderBy;
    private final Map<String, Set<String>> schemaFragments;
    protected final Map<String, Set<String>> typeFragments;
    protected final Map<String, Set<String>> mixinFragments;
    private final Set<String> proxyFragments;
    protected final Map<String, Set<String>> docTypePrefetchedFragments;
    protected final Map<String, Map<String, String>> schemaComplexChildren;
    protected final Map<String, Map<String, String>> typeComplexChildren;
    protected final Map<String, Map<String, String>> mixinComplexChildren;
    protected final Map<String, String> documentSuperTypes;
    protected final Map<String, Set<String>> documentSubTypes;
    protected final Map<String, String> fieldFragment;
    protected final FulltextConfiguration fulltextConfiguration;
    protected final Set<String> noPerDocumentQueryFacets;
    protected final Map<String, PropertyType> fulltextInfoByFragment;
    private final boolean materializeFulltextSyntheticColumn;
    private final boolean supportsArrayColumns;

    public Model(ModelSetup modelSetup) {
        this.repositoryDescriptor = modelSetup.repositoryDescriptor;
        this.materializeFulltextSyntheticColumn = modelSetup.materializeFulltextSyntheticColumn;
        this.supportsArrayColumns = modelSetup.supportsArrayColumns;
        this.idType = modelSetup.idType;
        switch (this.idType) {
            case STRING: {
                this.idPropertyType = PropertyType.STRING;
                this.idCoreType = StringType.INSTANCE;
                break;
            }
            case LONG: {
                this.idPropertyType = PropertyType.LONG;
                this.idCoreType = LongType.INSTANCE;
                break;
            }
            default: {
                throw new AssertionError((Object)this.idType.toString());
            }
        }
        this.softDeleteEnabled = this.repositoryDescriptor.getSoftDeleteEnabled();
        this.proxiesEnabled = this.repositoryDescriptor.getProxiesEnabled();
        this.changeTokenEnabled = this.repositoryDescriptor.isChangeTokenEnabled();
        this.allDocTypeSchemas = new HashMap<String, Set<String>>();
        this.mixinsDocumentTypes = new HashMap<String, Set<String>>();
        this.documentTypesMixins = new HashMap<String, Set<String>>();
        this.allMixinSchemas = new HashMap<String, Set<String>>();
        this.allProxySchemas = new HashSet<String>();
        this.fragmentPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.schemaPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.typePropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.mixinPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.proxyPropertyInfos = new HashMap<String, ModelProperty>();
        this.sharedPropertyInfos = new HashMap<String, ModelProperty>();
        this.mergedPropertyInfos = new HashMap<String, ModelProperty>();
        this.schemaPathPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        this.prefixToSchema = new HashMap<String, String>();
        this.schemaSimpleTextPaths = new HashMap<String, Set<String>>();
        this.allPathPropertyInfos = new HashMap<String, ModelProperty>();
        this.fulltextInfoByFragment = new HashMap<String, PropertyType>();
        this.fragmentKeyTypes = new HashMap<String, Map<String, ColumnType>>();
        this.binaryFragmentKeys = new HashMap<String, List<String>>();
        this.collectionTables = new HashMap<String, PropertyType>();
        this.collectionOrderBy = new HashMap<String, String>();
        this.schemaFragments = new HashMap<String, Set<String>>();
        this.typeFragments = new HashMap<String, Set<String>>();
        this.mixinFragments = new HashMap<String, Set<String>>();
        this.proxyFragments = new HashSet<String>();
        this.docTypePrefetchedFragments = new HashMap<String, Set<String>>();
        this.fieldFragment = new HashMap<String, String>();
        this.schemaComplexChildren = new HashMap<String, Map<String, String>>();
        this.typeComplexChildren = new HashMap<String, Map<String, String>>();
        this.mixinComplexChildren = new HashMap<String, Map<String, String>>();
        this.documentSuperTypes = new HashMap<String, String>();
        this.documentSubTypes = new HashMap<String, Set<String>>();
        this.specialPropertyTypes = new HashMap<String, Type>();
        this.noPerDocumentQueryFacets = new HashSet<String>();
        this.miscInHierarchy = false;
        this.fulltextConfiguration = this.repositoryDescriptor.getFulltextDescriptor().getFulltextDisabled() ? null : FulltextConfigurationFactory.make((FulltextDescriptor)this.repositoryDescriptor.getFulltextDescriptor());
        this.initMainModel();
        this.initVersionsModel();
        if (this.proxiesEnabled) {
            this.initProxiesModel();
        }
        this.initLocksModel();
        this.initAclModel();
        this.initMiscModel();
        this.initModels();
        if (this.fulltextConfiguration != null) {
            this.inferFulltextInfoByFragment();
            this.initFullTextModel();
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public Serializable idFromString(String id) {
        switch (this.idType) {
            case STRING: {
                return id;
            }
            case LONG: {
                if (StringUtils.isNumeric((CharSequence)id)) {
                    return Long.valueOf(id);
                }
                return NO_SUCH_LONG_ID;
            }
        }
        throw new AssertionError((Object)this.idType.toString());
    }

    public String idToString(Serializable id) {
        return id.toString();
    }

    private void addPropertyInfo(String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        this.addPropertyInfo(null, false, propertyName, propertyType, fragmentName, fragmentKey, readonly, coreType, type);
    }

    private void addPropertyInfo(String typeName, String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        this.addPropertyInfo(typeName, false, propertyName, propertyType, fragmentName, fragmentKey, readonly, coreType, type);
    }

    private void addPropertyInfo(ComplexType complexType, String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        String typeName = complexType.getName();
        boolean isSchema = complexType instanceof Schema;
        this.addPropertyInfo(typeName, isSchema, propertyName, propertyType, fragmentName, fragmentKey, readonly, coreType, type);
    }

    private void addPropertyInfo(String typeName, boolean isSchema, String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        Map propertyInfos;
        ModelProperty propertyInfo = new ModelProperty(propertyType, fragmentName, fragmentKey, readonly);
        if (typeName == null) {
            propertyInfos = this.sharedPropertyInfos;
        } else {
            Map<String, Map<String, ModelProperty>> map = isSchema ? this.schemaPropertyInfos : this.typePropertyInfos;
            propertyInfos = map.computeIfAbsent(typeName, k -> new HashMap());
        }
        propertyInfos.put((String)propertyName, (ModelProperty)propertyInfo);
        ModelProperty previous = this.mergedPropertyInfos.get(propertyName);
        if (previous == null) {
            this.mergedPropertyInfos.put((String)propertyName, propertyInfo);
        } else {
            log.debug((Object)String.format("Schemas '%s' and '%s' both have a property '%s', unqualified reference in queries will use schema '%1$s'", previous.fragmentName, fragmentName, propertyName));
        }
        if (typeName != null && !((String)propertyName).contains(":")) {
            propertyName = typeName + ":" + (String)propertyName;
            this.mergedPropertyInfos.putIfAbsent((String)propertyName, propertyInfo);
        }
        if (coreType != null) {
            this.specialPropertyTypes.put((String)propertyName, coreType);
        }
        Map fragmentKeyInfos = this.fragmentPropertyInfos.computeIfAbsent(fragmentName, k -> new HashMap());
        if (fragmentKey != null) {
            fragmentKeyInfos.put(fragmentKey, propertyInfo);
        }
        if (fragmentKey != null && type != null) {
            this.fragmentKeyTypes.computeIfAbsent(fragmentName, k -> new LinkedHashMap()).put(fragmentKey, type);
            if (type.spec == ColumnSpec.BLOBID) {
                this.binaryFragmentKeys.computeIfAbsent(fragmentName, k -> new ArrayList(1)).add(fragmentKey);
            }
        }
    }

    private void addCollectionFragmentInfos(String fragmentName, PropertyType propertyType, String orderBy, Map<String, ColumnType> keysType) {
        this.collectionTables.put(fragmentName, propertyType);
        this.collectionOrderBy.put(fragmentName, orderBy);
        this.fragmentKeyTypes.put(fragmentName, keysType);
    }

    private void inferPropertyInfos(Map<String, Map<String, ModelProperty>> map, String key, Set<String> schemaNames) {
        Map propertyInfos = map.computeIfAbsent(key, k -> new HashMap());
        for (String schemaName : schemaNames) {
            Map<String, ModelProperty> infos = this.schemaPropertyInfos.get(schemaName);
            if (infos == null) continue;
            propertyInfos.putAll(infos);
        }
    }

    private void inferSchemaPropertyPaths(Schema schema) {
        String schemaName = schema.getName();
        if (this.schemaPathPropertyInfos.containsKey(schemaName)) {
            return;
        }
        HashMap<String, ModelProperty> propertyInfoByPath = new HashMap<String, ModelProperty>();
        this.inferTypePropertyPaths((ComplexType)schema, "", propertyInfoByPath, null);
        this.schemaPathPropertyInfos.put(schemaName, propertyInfoByPath);
        HashMap<String, ModelProperty> alsoWithPrefixes = new HashMap<String, ModelProperty>(propertyInfoByPath);
        String prefix = schema.getNamespace().prefix;
        if (prefix.isEmpty()) {
            for (Map.Entry e : propertyInfoByPath.entrySet()) {
                alsoWithPrefixes.put(schemaName + ":" + (String)e.getKey(), (ModelProperty)e.getValue());
            }
        } else {
            this.prefixToSchema.put(prefix, schemaName);
        }
        this.allPathPropertyInfos.putAll(alsoWithPrefixes);
        HashSet<String> simplePaths = new HashSet<String>();
        for (Map.Entry entry : propertyInfoByPath.entrySet()) {
            ModelProperty pi = (ModelProperty)entry.getValue();
            if (pi.isIntermediateSegment() || pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
            simplePaths.add((String)entry.getKey());
        }
        this.schemaSimpleTextPaths.put(schemaName, simplePaths);
    }

    private void inferTypePropertyPaths(ComplexType complexType, String prefix, Map<String, ModelProperty> propertyInfoByPath, Set<String> done) {
        String typeName;
        if (done == null) {
            done = new LinkedHashSet<String>();
        }
        if (done.contains(typeName = complexType.getName())) {
            log.warn((Object)("Complex type " + typeName + " refers to itself recursively: " + done));
            return;
        }
        done.add(typeName);
        for (Field field : complexType.getFields()) {
            Type listFieldType;
            String propertyName = field.getName().getPrefixedName();
            String path = prefix + propertyName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                propertyInfoByPath.put(path, new ModelProperty(propertyName));
                this.inferTypePropertyPaths((ComplexType)fieldType, path + "/", propertyInfoByPath, done);
                continue;
            }
            if (fieldType.isListType() && !(listFieldType = ((ListType)fieldType).getFieldType()).isSimpleType()) {
                propertyInfoByPath.put(path + "/*", new ModelProperty(propertyName));
                this.inferTypePropertyPaths((ComplexType)listFieldType, path + "/*/", propertyInfoByPath, done);
                continue;
            }
            Map<String, Map<String, ModelProperty>> map = complexType instanceof Schema ? this.schemaPropertyInfos : this.typePropertyInfos;
            ModelProperty pi = map.get(typeName).get(propertyName);
            propertyInfoByPath.put(path, pi);
            if (!pi.propertyType.isArray()) continue;
            propertyInfoByPath.put(path + "/*", pi);
            if (this.supportsArrayColumns) continue;
            String posPropertyName = propertyName + "#";
            ModelProperty posPi = map.get(typeName).get(posPropertyName);
            propertyInfoByPath.put(path + "#", posPi);
        }
        done.remove(typeName);
    }

    private void inferFulltextInfoByFragment() {
        String fragmentName;
        for (Map.Entry<String, Map<String, ModelProperty>> entry : this.fragmentPropertyInfos.entrySet()) {
            fragmentName = entry.getKey();
            Map<String, ModelProperty> infos = entry.getValue();
            if (infos == null) continue;
            PropertyType type = null;
            for (ModelProperty info : infos.values()) {
                PropertyType t;
                if (info == null || !info.fulltext || (t = info.propertyType) != PropertyType.STRING && t != PropertyType.BINARY) continue;
                if (type == null) {
                    type = t;
                    continue;
                }
                if (type == t) continue;
                type = PropertyType.BOOLEAN;
                break;
            }
            this.fulltextInfoByFragment.put(fragmentName, type);
        }
        for (Map.Entry<String, Object> entry : this.collectionTables.entrySet()) {
            fragmentName = entry.getKey();
            PropertyType type = (PropertyType)((Object)entry.getValue());
            if (type != PropertyType.ARRAY_STRING && type != PropertyType.ARRAY_BINARY) continue;
            this.fulltextInfoByFragment.put(fragmentName, type.getArrayBaseType());
        }
    }

    public ModelProperty getPropertyInfo(String typeName, String propertyName) {
        Map<String, ModelProperty> propertyInfos = this.typePropertyInfos.get(typeName);
        if (propertyInfos == null) {
            return null;
        }
        ModelProperty propertyInfo = propertyInfos.get(propertyName);
        return propertyInfo != null ? propertyInfo : this.sharedPropertyInfos.get(propertyName);
    }

    public Map<String, ModelProperty> getMixinPropertyInfos(String mixin) {
        return this.mixinPropertyInfos.get(mixin);
    }

    public ModelProperty getProxySchemasPropertyInfo(String propertyName) {
        ModelProperty propertyInfo = this.proxyPropertyInfos.get(propertyName);
        return propertyInfo != null ? propertyInfo : this.sharedPropertyInfos.get(propertyName);
    }

    public ModelProperty getMixinPropertyInfo(String mixin, String propertyName) {
        Map<String, ModelProperty> propertyInfos = this.mixinPropertyInfos.get(mixin);
        if (propertyInfos == null) {
            return null;
        }
        return propertyInfos.get(propertyName);
    }

    public ModelProperty getPropertyInfo(String propertyName) {
        return this.mergedPropertyInfos.get(propertyName);
    }

    public ModelProperty getPathPropertyInfo(String xpath) {
        return this.allPathPropertyInfos.get(xpath);
    }

    public Set<String> getPropertyInfoNames() {
        return this.mergedPropertyInfos.keySet();
    }

    public ModelProperty getPathPropertyInfo(String primaryType, String[] mixinTypes, String path) {
        for (String schema : this.getAllSchemas(primaryType, mixinTypes)) {
            ModelProperty pi;
            Map<String, ModelProperty> propertyInfoByPath = this.schemaPathPropertyInfos.get(schema);
            if (propertyInfoByPath == null || (pi = propertyInfoByPath.get(path)) == null) continue;
            return pi;
        }
        return null;
    }

    public Map<String, String> getTypeComplexChildren(String typeName) {
        return this.typeComplexChildren.get(typeName);
    }

    public Map<String, String> getMixinComplexChildren(String mixin) {
        return this.mixinComplexChildren.get(mixin);
    }

    public Set<String> getSimpleTextPropertyPaths(String primaryType, String[] mixinTypes) {
        HashSet<String> paths = new HashSet<String>();
        for (String schema : this.getAllSchemas(primaryType, mixinTypes)) {
            Set<String> p = this.schemaSimpleTextPaths.get(schema);
            if (p == null) continue;
            paths.addAll(p);
        }
        return paths;
    }

    public boolean isProxySchemaPath(String xpath) {
        int p = xpath.indexOf(58);
        if (p == -1) {
            return false;
        }
        String prefix = xpath.substring(0, p);
        String schema = this.prefixToSchema.get(prefix);
        if (schema == null) {
            schema = prefix;
        }
        return this.allProxySchemas.contains(schema);
    }

    private Set<String> getAllSchemas(String primaryType, String[] mixinTypes) {
        LinkedHashSet<String> schemas = new LinkedHashSet<String>();
        Set<String> s = this.allDocTypeSchemas.get(primaryType);
        if (s != null) {
            schemas.addAll(s);
        }
        for (String mixin : mixinTypes) {
            s = this.allMixinSchemas.get(mixin);
            if (s == null) continue;
            schemas.addAll(s);
        }
        return schemas;
    }

    public FulltextConfiguration getFulltextConfiguration() {
        return this.fulltextConfiguration;
    }

    public PropertyType getFulltextFieldType(String fragmentName, String fragmentKey) {
        if (fragmentKey == null) {
            PropertyType type = this.collectionTables.get(fragmentName);
            if (type == PropertyType.ARRAY_STRING || type == PropertyType.ARRAY_BINARY) {
                return type.getArrayBaseType();
            }
            return null;
        }
        Map<String, ModelProperty> infos = this.fragmentPropertyInfos.get(fragmentName);
        if (infos == null) {
            return null;
        }
        ModelProperty info = infos.get(fragmentKey);
        if (info != null && info.fulltext) {
            return info.propertyType;
        }
        return null;
    }

    public PropertyType getFulltextInfoForFragment(String fragmentName) {
        return this.fulltextInfoByFragment.get(fragmentName);
    }

    public Type getSpecialPropertyType(String propertyName) {
        return this.specialPropertyTypes.get(propertyName);
    }

    public PropertyType getCollectionFragmentType(String fragmentName) {
        return this.collectionTables.get(fragmentName);
    }

    public boolean isCollectionFragment(String fragmentName) {
        return this.collectionTables.containsKey(fragmentName);
    }

    public String getCollectionOrderBy(String fragmentName) {
        return this.collectionOrderBy.get(fragmentName);
    }

    public Set<String> getFragmentNames() {
        return this.fragmentKeyTypes.keySet();
    }

    public Map<String, ColumnType> getFragmentKeysType(String fragmentName) {
        return this.fragmentKeyTypes.get(fragmentName);
    }

    public Map<String, List<String>> getBinaryPropertyInfos() {
        return this.binaryFragmentKeys;
    }

    private void addTypeFragments(String typeName, Set<String> fragmentNames) {
        this.typeFragments.put(typeName, fragmentNames);
    }

    private void addFieldFragment(Field field, String fragmentName) {
        String fieldName = field.getName().toString();
        this.fieldFragment.put(fieldName, fragmentName);
    }

    private void addDocTypePrefetchedFragments(String docTypeName, Set<String> fragmentNames) {
        this.docTypePrefetchedFragments.computeIfAbsent(docTypeName, k -> new HashSet()).addAll(fragmentNames);
    }

    private Set<String> getTypeFragments(String docTypeName) {
        return this.typeFragments.get(docTypeName);
    }

    private Set<String> getMixinFragments(String mixin) {
        return this.mixinFragments.get(mixin);
    }

    public Set<String> getTypePrefetchedFragments(String typeName) {
        return this.docTypePrefetchedFragments.get(typeName);
    }

    public boolean isType(String typeName) {
        return this.typeFragments.containsKey(typeName);
    }

    public String getDocumentSuperType(String typeName) {
        return this.documentSuperTypes.get(typeName);
    }

    public Set<String> getDocumentSubTypes(String typeName) {
        return this.documentSubTypes.get(typeName);
    }

    public Set<String> getDocumentTypes() {
        return this.documentTypesMixins.keySet();
    }

    public Set<String> getDocumentTypeFacets(String typeName) {
        Set<String> facets = this.documentTypesMixins.get(typeName);
        return facets == null ? Collections.emptySet() : facets;
    }

    public Set<String> getMixinDocumentTypes(String mixin) {
        Set<String> types = this.mixinsDocumentTypes.get(mixin);
        return types == null ? Collections.emptySet() : types;
    }

    public Map<String, Set<Serializable>> getPerFragmentIds(Map<Serializable, RowMapper.IdWithTypes> idToTypes) {
        HashMap<String, Set<Serializable>> allFragmentIds = new HashMap<String, Set<Serializable>>();
        for (Map.Entry<Serializable, RowMapper.IdWithTypes> e : idToTypes.entrySet()) {
            Serializable id = e.getKey();
            RowMapper.IdWithTypes typeInfo = e.getValue();
            for (String fragmentName : this.getTypeFragments(typeInfo)) {
                allFragmentIds.computeIfAbsent(fragmentName, k -> new HashSet()).add(id);
            }
        }
        return allFragmentIds;
    }

    public Set<String> getTypeFragments(RowMapper.IdWithTypes typeInfo) {
        String[] mixins;
        HashSet<String> fragmentNames = new HashSet<String>();
        fragmentNames.add(HIER_TABLE_NAME);
        Set<String> tf = this.getTypeFragments(typeInfo.primaryType);
        if (tf != null) {
            fragmentNames.addAll(tf);
        }
        if ((mixins = typeInfo.mixinTypes) != null) {
            for (String mixin : mixins) {
                Set<String> mf = this.getMixinFragments(mixin);
                if (mf == null) continue;
                fragmentNames.addAll(mf);
            }
        }
        if (PROXY_TYPE.equals(typeInfo.primaryType)) {
            fragmentNames.addAll(this.proxyFragments);
        }
        return fragmentNames;
    }

    public Set<String> getNoPerDocumentQueryFacets() {
        return this.noPerDocumentQueryFacets;
    }

    private void initModels() {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        log.debug((Object)("Schemas fields from descriptor: " + this.repositoryDescriptor.schemaFields));
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            this.initDocTypeOrMixinModel(documentType.getName(), documentType.getSchemas(), this.allDocTypeSchemas, this.typeFragments, this.typePropertyInfos, this.typeComplexChildren, true);
            this.initDocTypePrefetch(documentType);
            this.initDocTypeMixins(documentType);
            this.inferSuperType(documentType);
        }
        for (DocumentType documentType : schemaManager.getFacets()) {
            this.initDocTypeOrMixinModel(documentType.getName(), documentType.getSchemas(), this.allMixinSchemas, this.mixinFragments, this.mixinPropertyInfos, this.mixinComplexChildren, false);
            log.debug((Object)("Fragments for facet " + documentType.getName() + ": " + this.getMixinFragments(documentType.getName())));
        }
        this.initProxySchemas(schemaManager.getProxySchemas(null));
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            this.inferSubTypes(documentType);
        }
        this.initNoPerDocumentQueryFacets(schemaManager);
    }

    private void initProxySchemas(List<Schema> proxySchemas) {
        HashMap<String, Set<String>> allSchemas = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> allFragments = new HashMap<String, Set<String>>();
        HashMap<String, Map<String, String>> allChildren = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, ModelProperty>> allPropertyInfos = new HashMap<String, Map<String, ModelProperty>>();
        String key = "__proxies__";
        this.initDocTypeOrMixinModel(key, proxySchemas, allSchemas, allFragments, allPropertyInfos, allChildren, false);
        this.allProxySchemas.addAll((Collection)allSchemas.get(key));
        this.proxyFragments.addAll((Collection)allFragments.get(key));
        this.proxyPropertyInfos.putAll((Map)allPropertyInfos.get(key));
        this.typeComplexChildren.put(PROXY_TYPE, (Map)allChildren.get(key));
    }

    private Set<String> getCommonFragments(String typeName) {
        HashSet<String> fragments = new HashSet<String>(5);
        fragments.add(VERSION_TABLE_NAME);
        fragments.add(ACL_TABLE_NAME);
        if (!this.miscInHierarchy) {
            fragments.add(MISC_TABLE_NAME);
        }
        if (this.fulltextConfiguration != null && this.fulltextConfiguration.isFulltextIndexable(typeName)) {
            fragments.add("fulltext");
        }
        return fragments;
    }

    private Set<String> getCommonFragmentsPrefetched() {
        HashSet<String> fragments = new HashSet<String>(5);
        fragments.add(VERSION_TABLE_NAME);
        fragments.add(ACL_TABLE_NAME);
        if (!this.miscInHierarchy) {
            fragments.add(MISC_TABLE_NAME);
        }
        return fragments;
    }

    private void initDocTypeOrMixinModel(String typeName, Collection<Schema> schemas, Map<String, Set<String>> schemasMap, Map<String, Set<String>> fragmentsMap, Map<String, Map<String, ModelProperty>> propertyInfoMap, Map<String, Map<String, String>> complexChildrenMap, boolean addCommonFragments) {
        HashSet<String> schemaNames = new HashSet<String>();
        HashSet<String> fragmentNames = new HashSet<String>();
        HashMap<String, String> complexChildren = new HashMap<String, String>();
        if (addCommonFragments) {
            fragmentNames.addAll(this.getCommonFragments(typeName));
        }
        for (Schema schema : schemas) {
            if (schema == null) continue;
            schemaNames.add(schema.getName());
            try {
                fragmentNames.addAll(this.initSchemaModel(schema));
            }
            catch (NuxeoException e) {
                e.addInfo(String.format("Error initializing schema '%s' for composite type '%s'", schema.getName(), typeName));
                throw e;
            }
            this.inferSchemaPropertyPaths(schema);
            complexChildren.putAll(this.schemaComplexChildren.get(schema.getName()));
        }
        schemasMap.put(typeName, schemaNames);
        fragmentsMap.put(typeName, fragmentNames);
        complexChildrenMap.put(typeName, complexChildren);
        this.inferPropertyInfos(propertyInfoMap, typeName, schemaNames);
    }

    private void initDocTypePrefetch(DocumentType docType) {
        String docTypeName = docType.getName();
        PrefetchInfo prefetch = docType.getPrefetchInfo();
        if (prefetch != null) {
            for (String schemaName : prefetch.getSchemas()) {
                Set<String> fragments = this.schemaFragments.get(schemaName);
                if (fragments == null) continue;
                this.addDocTypePrefetchedFragments(docTypeName, fragments);
            }
        }
        this.addDocTypePrefetchedFragments(docTypeName, this.getCommonFragmentsPrefetched());
        log.debug((Object)("Fragments for type " + docTypeName + ": " + this.getTypeFragments(docTypeName) + ", prefetch: " + this.getTypePrefetchedFragments(docTypeName)));
    }

    private void initDocTypeMixins(DocumentType docType) {
        String docTypeName = docType.getName();
        Set mixins = docType.getFacets();
        this.documentTypesMixins.put(docTypeName, new HashSet(mixins));
        for (String mixin : mixins) {
            this.mixinsDocumentTypes.computeIfAbsent(mixin, k -> new HashSet()).add(docTypeName);
        }
    }

    private void inferSuperType(DocumentType docType) {
        Type superType = docType.getSuperType();
        if (superType != null) {
            this.documentSuperTypes.put(docType.getName(), superType.getName());
        }
    }

    private void inferSubTypes(DocumentType docType) {
        String type;
        String superType = type = docType.getName();
        do {
            this.documentSubTypes.computeIfAbsent(superType, k -> new HashSet()).add(type);
        } while ((superType = this.documentSuperTypes.get(superType)) != null);
    }

    private void initNoPerDocumentQueryFacets(SchemaManager schemaManager) {
        this.noPerDocumentQueryFacets.addAll(schemaManager.getNoPerDocumentQueryFacets());
    }

    private void initMainModel() {
        this.addPropertyInfo(MAIN_PRIMARY_TYPE_PROP, PropertyType.STRING, HIER_TABLE_NAME, MAIN_PRIMARY_TYPE_KEY, true, null, ColumnType.SYSNAME);
        this.addPropertyInfo(MAIN_MIXIN_TYPES_PROP, PropertyType.STRING, HIER_TABLE_NAME, MAIN_MIXIN_TYPES_KEY, false, null, ColumnType.SYSNAMEARRAY);
        this.addPropertyInfo(MAIN_CHECKED_IN_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_CHECKED_IN_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(MAIN_BASE_VERSION_PROP, this.idPropertyType, HIER_TABLE_NAME, MAIN_BASE_VERSION_KEY, false, this.idCoreType, ColumnType.NODEVAL);
        this.addPropertyInfo(MAIN_MAJOR_VERSION_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_MAJOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
        this.addPropertyInfo(MAIN_MINOR_VERSION_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_MINOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
        this.addPropertyInfo(MAIN_IS_VERSION_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_IS_VERSION_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(MAIN_IS_RETENTION_ACTIVE_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_IS_RETENTION_ACTIVE_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(MAIN_IS_TRASHED_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_IS_TRASHED_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        if (this.changeTokenEnabled) {
            this.addPropertyInfo(MAIN_SYS_CHANGE_TOKEN_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_SYS_CHANGE_TOKEN_KEY, false, (Type)LongType.INSTANCE, ColumnType.LONG);
            this.addPropertyInfo(MAIN_CHANGE_TOKEN_PROP, PropertyType.LONG, HIER_TABLE_NAME, MAIN_CHANGE_TOKEN_KEY, false, (Type)LongType.INSTANCE, ColumnType.LONG);
        }
        if (this.softDeleteEnabled) {
            this.addPropertyInfo(MAIN_IS_DELETED_PROP, PropertyType.BOOLEAN, HIER_TABLE_NAME, MAIN_IS_DELETED_KEY, true, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
            this.addPropertyInfo(MAIN_DELETED_TIME_PROP, PropertyType.DATETIME, HIER_TABLE_NAME, MAIN_DELETED_TIME_KEY, true, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
        }
    }

    private void initMiscModel() {
        String fragmentName = this.miscInHierarchy ? HIER_TABLE_NAME : MISC_TABLE_NAME;
        this.addPropertyInfo(MISC_LIFECYCLE_POLICY_PROP, PropertyType.STRING, fragmentName, MISC_LIFECYCLE_POLICY_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(MISC_LIFECYCLE_STATE_PROP, PropertyType.STRING, fragmentName, MISC_LIFECYCLE_STATE_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
    }

    private void initVersionsModel() {
        this.addPropertyInfo(VERSION_VERSIONABLE_PROP, this.idPropertyType, VERSION_TABLE_NAME, "versionableid", false, this.idCoreType, ColumnType.NODEVAL);
        this.addPropertyInfo(VERSION_CREATED_PROP, PropertyType.DATETIME, VERSION_TABLE_NAME, "created", false, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
        this.addPropertyInfo(VERSION_LABEL_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_LABEL_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(VERSION_DESCRIPTION_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_DESCRIPTION_KEY, false, (Type)StringType.INSTANCE, ColumnType.STRING);
        this.addPropertyInfo(VERSION_IS_LATEST_PROP, PropertyType.BOOLEAN, VERSION_TABLE_NAME, VERSION_IS_LATEST_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(VERSION_IS_LATEST_MAJOR_PROP, PropertyType.BOOLEAN, VERSION_TABLE_NAME, VERSION_IS_LATEST_MAJOR_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
    }

    private void initProxiesModel() {
        String type = PROXY_TYPE;
        this.addPropertyInfo(type, PROXY_TARGET_PROP, this.idPropertyType, PROXY_TABLE_NAME, PROXY_TARGET_KEY, false, this.idCoreType, ColumnType.NODEIDFKNP);
        this.addPropertyInfo(type, PROXY_VERSIONABLE_PROP, this.idPropertyType, PROXY_TABLE_NAME, "versionableid", false, this.idCoreType, ColumnType.NODEVAL);
        this.addTypeFragments(type, Collections.singleton(PROXY_TABLE_NAME));
    }

    private void initLocksModel() {
        this.addPropertyInfo(LOCK_OWNER_PROP, PropertyType.STRING, LOCK_TABLE_NAME, LOCK_OWNER_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(LOCK_CREATED_PROP, PropertyType.DATETIME, LOCK_TABLE_NAME, "created", false, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
    }

    private void initFullTextModel() {
        this.addPropertyInfo(FULLTEXT_JOBID_PROP, PropertyType.STRING, "fulltext", FULLTEXT_JOBID_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        for (String indexName : this.fulltextConfiguration.indexNames) {
            String suffix = this.getFulltextIndexSuffix(indexName);
            if (this.materializeFulltextSyntheticColumn) {
                this.addPropertyInfo(FULLTEXT_FULLTEXT_PROP + suffix, PropertyType.STRING, "fulltext", "fulltext" + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTINDEXED);
            }
            this.addPropertyInfo(FULLTEXT_SIMPLETEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_SIMPLETEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
            this.addPropertyInfo(FULLTEXT_BINARYTEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_BINARYTEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
        }
    }

    public String getFulltextIndexSuffix(String indexName) {
        return indexName.equals(FULLTEXT_DEFAULT_INDEX) ? "" : "_" + indexName;
    }

    private void initAclModel() {
        LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
        keysType.put("pos", ColumnType.INTEGER);
        keysType.put("name", ColumnType.SYSNAME);
        keysType.put(ACL_GRANT_KEY, ColumnType.BOOLEAN);
        keysType.put(ACL_PERMISSION_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_CREATOR_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_BEGIN_KEY, ColumnType.TIMESTAMP);
        keysType.put(ACL_END_KEY, ColumnType.TIMESTAMP);
        keysType.put(ACL_STATUS_KEY, ColumnType.LONG);
        keysType.put(ACL_USER_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_GROUP_KEY, ColumnType.SYSNAME);
        String fragmentName = ACL_TABLE_NAME;
        this.addCollectionFragmentInfos(fragmentName, PropertyType.COLL_ACL, "pos", keysType);
        this.addPropertyInfo(ACL_PROP, PropertyType.COLL_ACL, fragmentName, null, false, null, null);
        this.allPathPropertyInfos.put("ecm:acl.principal/*", new ModelProperty(PropertyType.STRING, fragmentName, ACL_USER_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.permission/*", new ModelProperty(PropertyType.STRING, fragmentName, ACL_PERMISSION_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.grant/*", new ModelProperty(PropertyType.BOOLEAN, fragmentName, ACL_GRANT_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.name/*", new ModelProperty(PropertyType.STRING, fragmentName, "name", true));
        this.allPathPropertyInfos.put("ecm:acl.pos/*", new ModelProperty(PropertyType.LONG, fragmentName, "pos", true));
        this.allPathPropertyInfos.put("ecm:acl.creator/*", new ModelProperty(PropertyType.STRING, fragmentName, ACL_CREATOR_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.begin/*", new ModelProperty(PropertyType.DATETIME, fragmentName, ACL_BEGIN_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.end/*", new ModelProperty(PropertyType.DATETIME, fragmentName, ACL_END_KEY, true));
        this.allPathPropertyInfos.put("ecm:acl.status/*", new ModelProperty(PropertyType.LONG, fragmentName, ACL_STATUS_KEY, true));
    }

    private Set<String> initSchemaModel(Schema schema) {
        this.initComplexTypeModel((ComplexType)schema);
        return this.schemaFragments.get(schema.getName());
    }

    private void initComplexTypeModel(ComplexType complexType) {
        String typeName = complexType.getName();
        boolean isSchema = complexType instanceof Schema;
        if (isSchema && this.schemaFragments.containsKey(typeName)) {
            return;
        }
        if (!isSchema && this.typeFragments.containsKey(typeName)) {
            return;
        }
        HashSet<String> fragmentNames = new HashSet<String>(1);
        HashMap<String, String> complexChildren = new HashMap<String, String>(1);
        log.debug((Object)("Making model for type " + typeName));
        for (Field field : complexType.getFields()) {
            String propertyName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                propertyName = field.getName().getPrefixedName();
                complexChildren.put(propertyName, fieldType.getName());
                this.initComplexTypeModel((ComplexType)fieldType);
                continue;
            }
            propertyName = field.getName().getPrefixedName();
            RepositoryDescriptor.FieldDescriptor fieldDescriptor = null;
            for (RepositoryDescriptor.FieldDescriptor fd : this.repositoryDescriptor.schemaFields) {
                if (!propertyName.equals(fd.field)) continue;
                fieldDescriptor = fd;
                break;
            }
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (listFieldType.isSimpleType()) {
                    String fragmentName;
                    PropertyType propertyType = PropertyType.fromFieldType(listFieldType, true);
                    boolean useArray = false;
                    ColumnType columnType = null;
                    if (this.repositoryDescriptor.getArrayColumns() && fieldDescriptor == null) {
                        fieldDescriptor = new RepositoryDescriptor.FieldDescriptor();
                        fieldDescriptor.type = FIELD_TYPE_ARRAY;
                    }
                    if (fieldDescriptor != null) {
                        if (FIELD_TYPE_ARRAY.equals(fieldDescriptor.type)) {
                            if (!this.supportsArrayColumns) {
                                log.warn((Object)("  Field '" + propertyName + "' array specification is ignored since this database does not support arrays"));
                            }
                            useArray = this.supportsArrayColumns;
                            columnType = ColumnType.fromFieldType(listFieldType, useArray);
                        } else if (FIELD_TYPE_ARRAY_LARGETEXT.equals(fieldDescriptor.type)) {
                            boolean isStringColSpec;
                            boolean bl = isStringColSpec = ColumnType.fromFieldType((Type)listFieldType).spec == ColumnSpec.STRING;
                            if (this.supportsArrayColumns && !isStringColSpec) {
                                log.warn((Object)("  Field '" + propertyName + "' is not a String yet it is specified as array_largetext, using ARRAY_CLOB for it"));
                            } else if (!this.supportsArrayColumns && isStringColSpec) {
                                log.warn((Object)("  Field '" + propertyName + "' array specification is ignored since this database does not support arrays, using CLOB for it"));
                            } else if (!this.supportsArrayColumns && !isStringColSpec) {
                                log.warn((Object)("  Field '" + propertyName + "' array specification is ignored since this database does not support arrays, also Field is not a String yet it is specified as array_largetext, using CLOB for it"));
                            }
                            useArray = this.supportsArrayColumns;
                            columnType = this.supportsArrayColumns ? ColumnType.ARRAY_CLOB : ColumnType.CLOB;
                        } else if (FIELD_TYPE_LARGETEXT.equals(fieldDescriptor.type)) {
                            if (ColumnType.fromFieldType((Type)listFieldType).spec != ColumnSpec.STRING) {
                                log.warn((Object)("  Field '" + propertyName + "' is not a String yet it is specified  as largetext, using CLOB for it"));
                            }
                            columnType = ColumnType.CLOB;
                        } else {
                            log.warn((Object)("  Field '" + propertyName + "' specified but not successfully mapped"));
                        }
                    }
                    if (columnType == null) {
                        columnType = ColumnType.fromFieldType(listFieldType);
                    }
                    log.debug((Object)("  List field '" + propertyName + "' using column type " + columnType));
                    if (useArray) {
                        fragmentName = Model.typeFragmentName(complexType);
                        String fragmentKey = field.getName().getLocalName();
                        this.addPropertyInfo(complexType, propertyName, propertyType, fragmentName, fragmentKey, false, null, columnType);
                        this.addFieldFragment(field, fragmentName);
                        continue;
                    }
                    fragmentName = Model.collectionFragmentName(propertyName);
                    this.addPropertyInfo(complexType, propertyName, propertyType, fragmentName, COLL_TABLE_VALUE_KEY, false, null, columnType);
                    String posPropertyName = propertyName + "#";
                    PropertyType posPropertyType = PropertyType.LONG;
                    this.addPropertyInfo(complexType, posPropertyName, posPropertyType, fragmentName, "pos", false, null, ColumnType.INTEGER);
                    LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
                    keysType.put("pos", ColumnType.INTEGER);
                    keysType.put(COLL_TABLE_VALUE_KEY, columnType);
                    this.addCollectionFragmentInfos(fragmentName, propertyType, "pos", keysType);
                    fragmentNames.add(fragmentName);
                    this.addFieldFragment(field, fragmentName);
                    continue;
                }
                this.initComplexTypeModel((ComplexType)listFieldType);
                continue;
            }
            String fragmentName = Model.typeFragmentName(complexType);
            String fragmentKey = field.getName().getLocalName();
            PropertyType propertyType = PropertyType.fromFieldType(fieldType, false);
            ColumnType type = ColumnType.fromField(field);
            if (type.spec == ColumnSpec.STRING && fieldDescriptor != null && FIELD_TYPE_LARGETEXT.equals(fieldDescriptor.type)) {
                if (!type.isUnconstrained() && !type.isClob()) {
                    log.warn((Object)("  String field '" + propertyName + "' has a schema constraint to " + type + " but is specified as largetext, using CLOB for it"));
                }
                type = ColumnType.CLOB;
            }
            if (fieldDescriptor != null) {
                if (fieldDescriptor.table != null) {
                    fragmentName = fieldDescriptor.table;
                }
                if (fieldDescriptor.column != null) {
                    fragmentKey = fieldDescriptor.column;
                }
            }
            fragmentKey = this.checkReservedName(fragmentKey);
            if (fragmentName.equals(UID_SCHEMA_NAME) && (fragmentKey.equals(UID_MAJOR_VERSION_KEY) || fragmentKey.equals(UID_MINOR_VERSION_KEY))) {
                fragmentName = HIER_TABLE_NAME;
                fragmentKey = fragmentKey.equals(UID_MAJOR_VERSION_KEY) ? MAIN_MAJOR_VERSION_KEY : MAIN_MINOR_VERSION_KEY;
            }
            this.addPropertyInfo(complexType, propertyName, propertyType, fragmentName, fragmentKey, false, null, type);
            if (fragmentName.equals(HIER_TABLE_NAME)) continue;
            fragmentNames.add(fragmentName);
            this.addFieldFragment(field, fragmentName);
        }
        if (isSchema) {
            this.schemaFragments.put(typeName, fragmentNames);
            this.schemaComplexChildren.put(typeName, complexChildren);
        } else {
            this.addTypeFragments(typeName, fragmentNames);
            this.typeComplexChildren.put(typeName, complexChildren);
        }
    }

    protected String checkReservedName(String key) {
        String k = ((String)key).replaceAll("_+$", "");
        if (k.equalsIgnoreCase("id")) {
            key = (String)key + "_";
        }
        return key;
    }

    private static String typeFragmentName(ComplexType type) {
        return type.getName();
    }

    private static String collectionFragmentName(String propertyName) {
        return propertyName;
    }

    public static enum IdType {
        STRING,
        LONG;

    }
}

