/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.model.VersionNotModifiableException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLDocumentVersion
extends SQLDocumentLive {
    private final Node versionableNode;

    protected SQLDocumentVersion(Node node, ComplexType type, SQLSession session, boolean readonly) {
        super(node, type, session, readonly);
        Serializable versionSeriesId = this.getPropertyValue("ecm:versionableId");
        if (versionSeriesId == null) {
            throw new DocumentNotFoundException("Version was removed: " + node.getId());
        }
        this.versionableNode = session.getNodeById(versionSeriesId);
    }

    @Override
    public boolean isVersion() {
        return true;
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() {
        if (this.versionableNode == null) {
            return false;
        }
        return !Boolean.TRUE.equals(this.versionableNode.getSimpleProperty("ecm:isCheckedIn").getValue());
    }

    @Override
    public boolean isMajorVersion() {
        return Long.valueOf(0L).equals(this.getPropertyValue("ecm:minorVersion"));
    }

    @Override
    public boolean isLatestVersion() {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isLatestVersion"));
    }

    @Override
    public boolean isLatestMajorVersion() {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isLatestMajorVersion"));
    }

    @Override
    public Document getWorkingCopy() {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getDocumentByUUID(this.versionableNode.getId().toString());
    }

    @Override
    public Document getBaseVersion() {
        return null;
    }

    @Override
    public String getVersionSeriesId() {
        Serializable versionSeriesId = this.getPropertyValue("ecm:versionableId");
        return this.session.idToString(versionSeriesId);
    }

    @Override
    public Document getSourceDocument() {
        return this.getWorkingCopy();
    }

    @Override
    public String getPath() {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getPath(this.versionableNode);
    }

    @Override
    public Document getParent() {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getParent(this.versionableNode);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public void orderBefore(String src, String dest) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document addChild(String name, String typeName) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getChild(String name) {
        throw new DocumentNotFoundException(name);
    }

    @Override
    public List<Document> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getChildrenIds() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild(String name) {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public Document checkIn(String label, String description) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void checkOut() {
        throw new VersionNotModifiableException();
    }

    @Override
    public void restore(Document version) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getVersion(String label) {
        return null;
    }

    @Override
    public void setPropertyValue(String name, Serializable value) {
        if (this.isReadOnlyProperty(name)) {
            throw new VersionNotModifiableException(String.format("Cannot set property on a version: %s = %s", name, value));
        }
        super.setPropertyValue(name, value);
    }

    protected boolean isReadOnlyProperty(String name) {
        return this.isReadOnly() && !SQLDocumentVersion.isVersionWritableProperty((String)name);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentVersion)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentVersion other) {
        return this.getNode().equals((Object)other.getNode());
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }
}

