/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;

public class JDBCLogger {
    public static final Log log = LogFactory.getLog(JDBCLogger.class);
    public static final int DEBUG_MAX_STRING = 100;
    public static final int DEBUG_MAX_ARRAY = 10;
    public final String instance;
    private static final String CALLABLE_START = "{?=";

    public JDBCLogger(String instance) {
        this.instance = instance;
    }

    public boolean isLogEnabled() {
        return log.isTraceEnabled();
    }

    public String formatMessage(String message) {
        return "(" + this.instance + ") SQL: " + message;
    }

    public void error(String message) {
        log.error((Object)this.formatMessage(message));
    }

    public void error(String message, Throwable t) {
        log.error((Object)this.formatMessage(message), t);
    }

    public void warn(String message) {
        log.warn((Object)this.formatMessage(message));
    }

    public void info(String message) {
        log.info((Object)this.formatMessage(message));
    }

    public void log(String message) {
        log.trace((Object)this.formatMessage(message));
    }

    public void logCount(int count) {
        if (count > 0 && this.isLogEnabled()) {
            this.log("  -> " + count + " row" + (count > 1 ? "s" : ""));
        }
    }

    public void logResultSet(ResultSet rs, List<Column> columns) throws SQLException {
        LinkedList<CallSite> res = new LinkedList<CallSite>();
        int i = 0;
        for (Column column : columns) {
            Serializable v = column.getFromResultSet(rs, ++i);
            res.add((CallSite)((Object)(column.getKey() + "=" + JDBCLogger.loggedValue(v))));
        }
        this.log("  -> " + String.join((CharSequence)", ", res));
    }

    public void logMap(Map<String, Serializable> map) throws SQLException {
        String result = map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + JDBCLogger.loggedValue(entry.getValue())).collect(Collectors.joining(", "));
        this.log("  -> " + result);
    }

    public void logMaps(List<Map<String, Serializable>> maps, boolean countTotal, long totalSize) {
        List<Map<String, Serializable>> debugMaps = maps;
        Object end = "";
        if (maps.size() > 10) {
            debugMaps = new ArrayList<Map<String, Serializable>>(10);
            int i = 0;
            for (Map<String, Serializable> map2 : maps) {
                debugMaps.add(map2);
                if (++i != 10) continue;
                break;
            }
            end = "...(" + maps.size() + " ids)...";
        }
        if (countTotal) {
            end = (String)end + " (total " + totalSize + ")";
        }
        String result = debugMaps.stream().map(map -> map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + JDBCLogger.loggedValue(entry.getValue())).collect(Collectors.joining(", "))).collect(Collectors.joining(",", "{", "}"));
        this.log("  -> " + result + (String)end);
    }

    public void logIds(List<Serializable> ids, boolean countTotal, long totalSize) {
        List<Serializable> debugIds = ids;
        Object end = "";
        if (ids.size() > 10) {
            debugIds = new ArrayList<Serializable>(10);
            int i = 0;
            for (Serializable id : ids) {
                debugIds.add(id);
                if (++i != 10) continue;
                break;
            }
            end = "...(" + ids.size() + " ids)...";
        }
        if (countTotal) {
            end = (String)end + " (total " + totalSize + ")";
        }
        this.log("  -> " + debugIds + (String)end);
    }

    public void logSQL(String sql, List<Column> columns, Row row) {
        this.logSQL(sql, columns, row, Collections.emptyList(), Collections.emptyMap());
    }

    public void logSQL(String sql, List<Column> columns, Row row, List<Column> whereColumns, Map<String, Serializable> conditions) {
        Serializable value;
        String key;
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (Column column : columns) {
            Delta delta;
            key = column.getKey();
            value = row.get(key);
            if (value instanceof Delta && (delta = (Delta)value).getBase() != null) {
                value = delta.getDeltaValue();
            }
            values.add(value);
        }
        for (Column column : whereColumns) {
            key = column.getKey();
            value = column.getKey().equals("id") ? row.get(key) : conditions.get(key);
            values.add(value);
        }
        this.logSQL(sql, values);
    }

    public void logSQL(String sql, Collection<? extends Serializable> values) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        if (sql.startsWith(CALLABLE_START)) {
            sb.append(CALLABLE_START);
            start = CALLABLE_START.length();
        }
        for (Serializable serializable : values) {
            int index = sql.indexOf(63, start);
            if (index == -1) break;
            sb.append(sql, start, index);
            sb.append(JDBCLogger.loggedValue(serializable));
            start = index + 1;
        }
        sb.append(sql, start, sql.length());
        this.log(sb.toString());
    }

    public static String loggedValue(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String) {
            Object v = (String)value;
            if (((String)v).length() > 100) {
                v = ((String)v).substring(0, 100) + "...(" + ((String)v).length() + " chars)...";
            }
            return "'" + ((String)v).replace("'", "''") + "'";
        }
        if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            return String.format("TIMESTAMP '%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d'", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60);
        }
        if (value instanceof Date) {
            return "DATE '" + value.toString() + "'";
        }
        if (value instanceof byte[]) {
            return "(" + ((byte[])value).length + " bytes)";
        }
        if (value instanceof Object[]) {
            Object[] v = (Object[])value;
            StringBuilder b = new StringBuilder();
            b.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    b.append(',');
                    if (i > 10) {
                        b.append("...(").append(v.length).append(" items)...");
                        break;
                    }
                }
                b.append(JDBCLogger.loggedValue(v[i]));
            }
            b.append(']');
            return b.toString();
        }
        return value.toString();
    }
}

