/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.ScrollResultImpl;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCRowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerService;
import org.nuxeo.ecm.core.storage.sql.jdbc.ResultSetQueryResult;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.TableUpgrader;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;
import org.nuxeo.runtime.api.Framework;

public class JDBCMapper
extends JDBCRowMapper
implements Mapper {
    private static final Log log = LogFactory.getLog(JDBCMapper.class);
    public static Map<String, Serializable> testProps = new HashMap<String, Serializable>();
    protected static Map<String, CursorResult> cursorResults = new ConcurrentHashMap<String, CursorResult>();
    public static final String TEST_UPGRADE = "testUpgrade";
    public static final String TEST_UPGRADE_VERSIONS = "testUpgradeVersions";
    public static final String TEST_UPGRADE_LAST_CONTRIBUTOR = "testUpgradeLastContributor";
    public static final String TEST_UPGRADE_LOCKS = "testUpgradeLocks";
    public static final String TEST_UPGRADE_SYS_CHANGE_TOKEN = "testUpgradeSysChangeToken";
    protected TableUpgrader tableUpgrader;
    private final QueryMakerService queryMakerService;
    private final Session.PathResolver pathResolver;
    private final RepositoryImpl repository;
    protected static final String NOSCROLL_ID = "noscroll";

    public JDBCMapper(Model model, Session.PathResolver pathResolver, SQLInfo sqlInfo, ClusterInvalidator clusterInvalidator, RepositoryImpl repository) {
        super(model, sqlInfo, clusterInvalidator, repository.getInvalidationsPropagator());
        this.pathResolver = pathResolver;
        this.repository = repository;
        this.queryMakerService = (QueryMakerService)Framework.getService(QueryMakerService.class);
        this.tableUpgrader = new TableUpgrader(this);
        this.tableUpgrader.add("versions", "islatest", "upgradeVersions", TEST_UPGRADE_VERSIONS);
        this.tableUpgrader.add("dublincore", "lastContributor", "upgradeLastContributor", TEST_UPGRADE_LAST_CONTRIBUTOR);
        this.tableUpgrader.add("locks", "owner", "upgradeLocks", TEST_UPGRADE_LOCKS);
        this.tableUpgrader.add("hierarchy", "systemchangetoken", "upgradeSysChangeToken", TEST_UPGRADE_SYS_CHANGE_TOKEN);
    }

    @Override
    public int getTableSize(String tableName) {
        return this.sqlInfo.getDatabase().getTable(tableName).getColumns().size();
    }

    @Override
    public void createDatabase(String ddlMode) {
        try {
            if (!this.connection.getAutoCommit()) {
                throw new NuxeoException("connection should not run in transactional mode for DDL operations");
            }
            this.createTables(ddlMode);
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected String getTableName(String origName) {
        if (this.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    /*
     * WARNING - void declaration
     */
    protected void createTables(String ddlMode) throws SQLException {
        SQLStatement.ListCollector ddlCollector = new SQLStatement.ListCollector();
        this.sqlInfo.executeSQLStatements(null, ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("first", ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("beforeTableCreation", ddlMode, this.connection, this.logger, ddlCollector);
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements(TEST_UPGRADE, ddlMode, this.connection, this.logger, null);
        }
        String schemaName = this.dialect.getConnectionSchema(this.connection);
        DatabaseMetaData metadata = this.connection.getMetaData();
        Set<String> tableNames = JDBCMapper.findTableNames(metadata, schemaName);
        Database database = this.sqlInfo.getDatabase();
        HashMap added = new HashMap();
        for (Table table : database.getTables()) {
            String tableName = this.getTableName(table.getPhysicalName());
            if (!tableNames.contains(tableName.toUpperCase())) {
                ddlCollector.add(table.getCreateSql());
                ddlCollector.addAll(table.getPostCreateSqls(this.model));
                added.put(table.getKey(), null);
                this.sqlInfo.sqlStatementsProperties.put("create_table_" + tableName.toLowerCase(), Boolean.TRUE);
                continue;
            }
            HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
            HashMap<String, String> columnTypeNames = new HashMap<String, String>();
            HashMap<String, Integer> columnTypeSizes = new HashMap<String, Integer>();
            try (ResultSet rs = metadata.getColumns(null, schemaName, tableName, "%");){
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    if (schema != null && "INFORMATION_SCHEMA".equals(schema.toUpperCase())) continue;
                    String string = rs.getString("COLUMN_NAME").toUpperCase();
                    columnTypes.put(string, rs.getInt("DATA_TYPE"));
                    columnTypeNames.put(string, rs.getString("TYPE_NAME"));
                    columnTypeSizes.put(string, rs.getInt("COLUMN_SIZE"));
                }
            }
            LinkedList<Column> addedColumns = new LinkedList<Column>();
            for (Column column : table.getColumns()) {
                String upperName = column.getPhysicalName().toUpperCase();
                Integer type = (Integer)columnTypes.remove(upperName);
                if (type == null) {
                    log.warn((Object)("Adding missing column in database: " + column.getFullQuotedName()));
                    ddlCollector.add(table.getAddColumnSql(column));
                    ddlCollector.addAll(table.getPostAddSqls(column, this.model));
                    addedColumns.add(column);
                    continue;
                }
                String actualName = (String)columnTypeNames.get(upperName);
                Integer actualSize = (Integer)columnTypeSizes.get(upperName);
                String message = column.checkJdbcType(type, actualName, actualSize);
                if (message == null) continue;
                log.error((Object)message);
                Framework.getRuntime().getMessageHandler().addError(message);
            }
            for (String string : this.dialect.getIgnoredColumns(table)) {
                columnTypes.remove(string.toUpperCase());
            }
            if (!columnTypes.isEmpty()) {
                log.warn((Object)("Database contains additional unused columns for table " + table.getQuotedName() + ": " + String.join((CharSequence)", ", columnTypes.keySet())));
            }
            if (addedColumns.isEmpty()) continue;
            if (added.containsKey(table.getKey())) {
                throw new AssertionError();
            }
            added.put(table.getKey(), addedColumns);
        }
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements("testUpgradeOldTables", ddlMode, this.connection, this.logger, ddlCollector);
        }
        for (Map.Entry entry : added.entrySet()) {
            List addedColumns = (List)entry.getValue();
            String tableKey = (String)entry.getKey();
            this.upgradeTable(tableKey, addedColumns, ddlMode, ddlCollector);
        }
        this.sqlInfo.executeSQLStatements("afterTableCreation", ddlMode, this.connection, this.logger, ddlCollector);
        this.sqlInfo.executeSQLStatements("last", ddlMode, this.connection, this.logger, ddlCollector);
        this.dialect.performAdditionalStatements(this.connection);
        List<String> ddl = ddlCollector.getStrings();
        boolean bl = ddlMode.contains("ignore");
        boolean dump = ddlMode.contains("dump");
        boolean abort = ddlMode.contains("abort");
        if ((dump || abort) && !ddl.isEmpty()) {
            File dumpFile = new File(Environment.getDefault().getLog(), "ddl-vcs-" + this.repository.getName() + ".sql");
            try (FileOutputStream out = new FileOutputStream(dumpFile);
                 PrintStream ps = new PrintStream(out);){
                for (String string : this.dialect.getDumpStart()) {
                    ps.println(string);
                }
                for (String string : ddl) {
                    void var16_43;
                    String string2 = string.trim();
                    if (string2.endsWith(";")) {
                        String string3 = string2.substring(0, string2.length() - 1);
                    }
                    ps.println(this.dialect.getSQLForDump((String)var16_43));
                }
                for (String string : this.dialect.getDumpStop()) {
                    ps.println(string);
                }
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            if (abort) {
                log.error((Object)("Dumped DDL to: " + dumpFile));
                throw new NuxeoException("Database initialization failed for: " + this.repository.getName() + ", DDL must be executed: " + dumpFile);
            }
        }
        if (!bl) {
            try (Statement st = this.connection.createStatement();){
                for (String sql : ddl) {
                    this.logger.log(sql.replace("\n", "\n    "));
                    try {
                        st.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new SQLException("Error executing: " + sql + " : " + e.getMessage(), e);
                    }
                    this.countExecute();
                }
            }
            st = this.connection.createStatement();
            try {
                for (String sql : this.dialect.getStartupSqls(this.model, this.sqlInfo.database)) {
                    this.logger.log(sql.replace("\n", "\n    "));
                    try {
                        st.execute(sql);
                    }
                    catch (SQLException e) {
                        throw new SQLException("Error executing: " + sql + " : " + e.getMessage(), e);
                    }
                    this.countExecute();
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    protected void upgradeTable(String tableKey, List<Column> addedColumns, String ddlMode, SQLStatement.ListCollector ddlCollector) throws SQLException {
        this.tableUpgrader.upgrade(tableKey, addedColumns, ddlMode, ddlCollector);
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName.toUpperCase());
        }
        rs.close();
        return tableNames;
    }

    @Override
    public int getClusterNodeIdType() {
        return this.sqlInfo.getClusterNodeIdType();
    }

    @Override
    public void createClusterNode(Serializable nodeId) {
        Calendar now = Calendar.getInstance();
        String sql = this.sqlInfo.getCreateClusterNodeSql();
        List<Column> columns = this.sqlInfo.getCreateClusterNodeColumns();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Arrays.asList(nodeId, now));
            }
            columns.get(0).setToPreparedStatement(ps, 1, nodeId);
            columns.get(1).setToPreparedStatement(ps, 2, now);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                this.checkConcurrentUpdate(e);
            }
            catch (ConcurrentUpdateException cue) {
                cue.addInfo("Duplicate cluster node with id: " + nodeId + " (a crashed node must be cleaned up, or the cluster configuration fixed)");
                throw cue;
            }
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void removeClusterNode(Serializable nodeId) {
        String sql = this.sqlInfo.getDeleteClusterNodeSql();
        Column column = this.sqlInfo.getDeleteClusterNodeColumn();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(nodeId));
            }
            column.setToPreparedStatement(ps, 1, nodeId);
            ps.execute();
            this.deleteClusterInvals(nodeId);
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void deleteClusterInvals(Serializable nodeId) throws SQLException {
        String sql = this.sqlInfo.getDeleteClusterInvalsSql();
        Column column = this.sqlInfo.getDeleteClusterInvalsColumn();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(nodeId));
            }
            column.setToPreparedStatement(ps, 1, nodeId);
            int n = ps.executeUpdate();
            this.countExecute();
            if (this.logger.isLogEnabled()) {
                this.logger.logCount(n);
            }
        }
    }

    @Override
    public void insertClusterInvalidations(Serializable nodeId, Invalidations invalidations) {
        String sql = this.dialect.getClusterInsertInvalidations();
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            int kind = 1;
            while (true) {
                Set<RowId> rowIds = invalidations.getKindSet(kind);
                HashMap<Serializable, HashSet<String>> res = new HashMap<Serializable, HashSet<String>>();
                for (RowId rowId : rowIds) {
                    HashSet<String> tableNames = (HashSet<String>)res.get(rowId.id);
                    if (tableNames == null) {
                        tableNames = new HashSet<String>();
                        res.put(rowId.id, tableNames);
                    }
                    tableNames.add(rowId.tableName);
                }
                for (Map.Entry entry : res.entrySet()) {
                    Serializable id = (Serializable)entry.getKey();
                    String[] fragments = JDBCMapper.join((Collection)entry.getValue(), ' ');
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(sql, Arrays.asList(nodeId, id, fragments, Long.valueOf(kind)));
                    }
                    String[] frags = this.dialect.supportsArrays() && columns.get(2).getJdbcType() == 2003 ? fragments.split(" ") : fragments;
                    columns.get(0).setToPreparedStatement(ps, 1, nodeId);
                    columns.get(1).setToPreparedStatement(ps, 2, id);
                    columns.get(2).setToPreparedStatement(ps, 3, (Serializable)frags);
                    columns.get(3).setToPreparedStatement(ps, 4, Long.valueOf(kind));
                    ps.execute();
                    this.countExecute();
                }
                if (kind == 1) {
                    kind = 2;
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not invalidate", (Throwable)e);
        }
    }

    protected static String join(Collection<String> strings, char sep) {
        if (strings.isEmpty()) {
            throw new RuntimeException();
        }
        if (strings.size() == 1) {
            return strings.iterator().next();
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder sb = new StringBuilder(size);
        for (String word : strings) {
            sb.append(word);
            sb.append(sep);
        }
        sb.setLength(size - 1);
        return sb.toString();
    }

    @Override
    public Invalidations getClusterInvalidations(Serializable nodeId) {
        Invalidations invalidations;
        block19: {
            Invalidations invalidations2 = new Invalidations();
            String sql = this.dialect.getClusterGetInvalidations();
            List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(nodeId));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                this.setToPreparedStatement(ps, 1, nodeId);
                try (ResultSet rs = ps.executeQuery();){
                    this.countExecute();
                    while (rs.next()) {
                        Serializable id = columns.get(1).getFromResultSet(rs, 1);
                        Serializable frags = columns.get(2).getFromResultSet(rs, 2);
                        int kind = ((Long)columns.get(3).getFromResultSet(rs, 3)).intValue();
                        String[] fragments = this.dialect.supportsArrays() && frags instanceof String[] ? (String[])frags : ((String)((Object)frags)).split(" ");
                        invalidations2.add(id, fragments, kind);
                    }
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> " + invalidations2);
                }
                if (this.dialect.isClusteringDeleteNeeded()) {
                    this.deleteClusterInvals(nodeId);
                }
                invalidations = invalidations2;
                if (ps == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NuxeoException("Could not invalidate", (Throwable)e);
                }
            }
            ps.close();
        }
        return invalidations;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable getRootId(String repositoryId) {
        String sql = this.sqlInfo.getSelectRootIdSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(repositoryId));
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            Serializable serializable;
            block22: {
                ResultSet rs;
                block20: {
                    Serializable serializable2;
                    block21: {
                        ps.setString(1, repositoryId);
                        rs = ps.executeQuery();
                        try {
                            this.countExecute();
                            if (rs.next()) break block20;
                            if (this.logger.isLogEnabled()) {
                                this.logger.log("  -> (none)");
                            }
                            serializable2 = null;
                            if (rs == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return serializable2;
                }
                Column column = this.sqlInfo.getSelectRootIdWhatColumn();
                Serializable id = column.getFromResultSet(rs, 1);
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> id=" + id);
                }
                if (rs.next()) {
                    throw new NuxeoException("Row query for " + repositoryId + " returned several rows: " + sql);
                }
                serializable = id;
                if (rs == null) break block22;
                rs.close();
            }
            return serializable;
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not select: " + sql, (Throwable)e);
        }
    }

    @Override
    public void setRootId(Serializable repositoryId, Serializable id) {
        String sql = this.sqlInfo.getInsertRootIdSql();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            List<Column> columns = this.sqlInfo.getInsertRootIdColumns();
            ArrayList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(2);
            }
            int i = 0;
            for (Column column : columns) {
                Serializable v;
                ++i;
                String key = column.getKey();
                if (key.equals("id")) {
                    v = id;
                } else if (key.equals("name")) {
                    v = repositoryId;
                } else {
                    throw new RuntimeException(key);
                }
                column.setToPreparedStatement(ps, i, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                this.logger.logSQL(sql, debugValues);
                debugValues.clear();
            }
            ps.execute();
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not insert: " + sql, (Throwable)e);
        }
    }

    protected QueryMaker findQueryMaker(String queryType) {
        for (Class<? extends QueryMaker> klass : this.queryMakerService.getQueryMakers()) {
            QueryMaker queryMaker;
            try {
                queryMaker = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
            if (!queryMaker.accepts(queryType)) continue;
            return queryMaker;
        }
        return null;
    }

    protected void prepareUserReadAcls(QueryFilter queryFilter) {
        String sql = this.dialect.getPrepareUserReadAclsSql();
        Object principals = queryFilter.getPrincipals();
        if (sql == null || principals == null) {
            return;
        }
        if (!this.dialect.supportsArrays()) {
            principals = String.join((CharSequence)"|", principals);
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singleton(principals));
            }
            this.setToPreparedStatement(ps, 1, (Serializable)principals);
            ps.execute();
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to prepare user read acl cache", (Throwable)e);
        }
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) {
        return this.query(query, queryType, queryFilter, countTotal ? -1L : 0L);
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        PartialList<Serializable> result = this.queryProjection(query, queryType, queryFilter, countUpTo, (info, rs) -> info.whatColumns.get(0).getFromResultSet((ResultSet)rs, 1), new Object[0]);
        if (this.logger.isLogEnabled()) {
            this.logger.logIds((List<Serializable>)result, countUpTo != 0L, result.totalSize());
        }
        return result;
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, Object ... params) {
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new NuxeoException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        query = this.computeDistinctDocuments(query, distinctDocuments);
        try {
            return new ResultSetQueryResult(queryMaker, query, queryFilter, this.pathResolver, this, params);
        }
        catch (SQLException e) {
            throw new NuxeoException("Invalid query: " + queryType + ": " + query, (Throwable)e);
        }
    }

    @Override
    public PartialList<Map<String, Serializable>> queryProjection(String query, String queryType, QueryFilter queryFilter, boolean distinctDocuments, long countUpTo, Object ... params) {
        query = this.computeDistinctDocuments(query, distinctDocuments);
        PartialList<Map> result = this.queryProjection(query, queryType, queryFilter, countUpTo, (info, rs) -> info.mapMaker.makeMap((ResultSet)rs), params);
        if (this.logger.isLogEnabled()) {
            this.logger.logMaps((List<Map<String, Serializable>>)result, countUpTo != 0L, result.totalSize());
        }
        return result;
    }

    protected String computeDistinctDocuments(String query, boolean distinctDocuments) {
        String q;
        if (distinctDocuments && (q = ((String)query).toLowerCase()).startsWith("select ") && !q.startsWith("select distinct ")) {
            query = "SELECT DISTINCT " + ((String)query).substring(7);
        }
        return query;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected <T> PartialList<T> queryProjection(String query, String queryType, QueryFilter queryFilter, long countUpTo, BiFunctionSQLException<SQLInfo.SQLInfoSelect, ResultSet, T> extractor, Object ... params) {
        Object sql;
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new NuxeoException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, this.pathResolver, query, queryFilter, params);
        if (q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            return new PartialList(Collections.emptyList(), 0L);
        }
        long limit = queryFilter.getLimit();
        long offset = queryFilter.getOffset();
        if (this.logger.isLogEnabled()) {
            sql = q.selectInfo.sql;
            if (limit != 0L) {
                sql = (String)sql + " -- LIMIT " + limit + " OFFSET " + offset;
            }
            if (countUpTo != 0L) {
                sql = (String)sql + " -- COUNT TOTAL UP TO " + countUpTo;
            }
            this.logger.logSQL((String)sql, q.selectParams);
        }
        sql = q.selectInfo.sql;
        if (countUpTo == 0L && limit > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause((String)sql, limit, offset);
            limit = 0L;
            offset = 0L;
        } else if (countUpTo > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause((String)sql, Math.max(countUpTo + 1L, limit + offset), 0L);
        }
        try (PreparedStatement ps = this.connection.prepareStatement((String)sql, 1004, 1007);){
            PartialList partialList;
            block35: {
                int i = 1;
                for (Serializable object : q.selectParams) {
                    this.setToPreparedStatement(ps, i++, object);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    boolean available;
                    this.countExecute();
                    long totalSize = -1L;
                    if (limit == 0L || offset == 0L) {
                        available = rs.first();
                        if (!available) {
                            totalSize = 0L;
                        }
                        if (limit == 0L) {
                            limit = -1L;
                        }
                    } else {
                        available = rs.absolute((int)offset + 1);
                    }
                    LinkedList<SQLInfo.SQLInfoSelect> projections = new LinkedList<SQLInfo.SQLInfoSelect>();
                    int rowNum = 0;
                    while (available && limit != 0L) {
                        try {
                            SQLInfo.SQLInfoSelect projection = extractor.apply(q.selectInfo, rs);
                            projections.add(projection);
                            rowNum = rs.getRow();
                            available = rs.next();
                            --limit;
                        }
                        catch (SQLDataException e) {
                            available = false;
                        }
                    }
                    if (countUpTo != 0L && totalSize == -1L) {
                        if (!available && rowNum != 0) {
                            totalSize = rowNum;
                        } else {
                            rs.last();
                            totalSize = rs.getRow();
                        }
                        if (countUpTo > 0L && totalSize > countUpTo) {
                            totalSize = -2L;
                        }
                    }
                    partialList = new PartialList(projections, totalSize);
                    if (rs == null) break block35;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return partialList;
        }
        catch (SQLException e) {
            throw new NuxeoException("Invalid query: " + query, (Throwable)e);
        }
    }

    public int setToPreparedStatement(PreparedStatement ps, int i, Serializable object) throws SQLException {
        if (object instanceof Calendar) {
            this.dialect.setToPreparedStatementTimestamp(ps, i, (Serializable)object, null);
        } else if (object instanceof Date) {
            ps.setDate(i, (Date)object);
        } else if (object instanceof Long) {
            ps.setLong(i, (Long)object);
        } else if (object instanceof ColumnType.WrappedId) {
            this.dialect.setId(ps, i, (Serializable)((Object)object.toString()));
        } else if (object instanceof Object[]) {
            int jdbcType;
            if (object instanceof String[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.STRING).jdbcType;
            } else if (object instanceof Boolean[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.BOOLEAN).jdbcType;
            } else if (object instanceof Long[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.LONG).jdbcType;
            } else if (object instanceof Double[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.DOUBLE).jdbcType;
            } else if (object instanceof Date[]) {
                jdbcType = 91;
            } else if (object instanceof Clob[]) {
                jdbcType = 2005;
            } else if (object instanceof Calendar[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.TIMESTAMP).jdbcType;
                object = this.dialect.getTimestampFromCalendar((Calendar[])object);
            } else {
                jdbcType = object instanceof Integer[] ? this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.INTEGER).jdbcType : this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.CLOB).jdbcType;
            }
            Array array = this.dialect.createArrayOf(jdbcType, object, this.connection);
            ps.setArray(i, array);
        } else {
            ps.setObject(i, object);
        }
        return i;
    }

    @Override
    public ScrollResult<String> scroll(String query, int batchSize, int keepAliveSeconds) {
        if (!this.dialect.supportsScroll()) {
            return this.defaultScroll(query);
        }
        this.checkForTimedoutScroll();
        QueryFilter queryFilter = new QueryFilter(null, null, null, null, Collections.emptyList(), 0L, 0L);
        return this.scrollSearch(query, queryFilter, batchSize, keepAliveSeconds);
    }

    @Override
    public ScrollResult<String> scroll(String query, QueryFilter queryFilter, int batchSize, int keepAliveSeconds) {
        if (!this.dialect.supportsScroll()) {
            return this.defaultScroll(query);
        }
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        this.checkForTimedoutScroll();
        return this.scrollSearch(query, queryFilter, batchSize, keepAliveSeconds);
    }

    protected void checkForTimedoutScroll() {
        cursorResults.forEach((id, cursor) -> cursor.timedOut((String)id));
    }

    protected ScrollResult<String> scrollSearch(String query, QueryFilter queryFilter, int batchSize, int keepAliveSeconds) {
        QueryMaker queryMaker = this.findQueryMaker("NXQL");
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, this.pathResolver, query, queryFilter, new Object[0]);
        if (q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            throw new NuxeoException("Query cannot return anything due to conflicting clauses");
        }
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(q.selectInfo.sql, q.selectParams);
        }
        try {
            if (this.connection.getAutoCommit()) {
                throw new NuxeoException("Scroll should be done inside a transaction");
            }
            PreparedStatement ps = this.connection.prepareStatement(q.selectInfo.sql, 1003, 1007, 1);
            ps.setFetchSize(batchSize);
            int i = 1;
            for (Serializable object : q.selectParams) {
                this.setToPreparedStatement(ps, i++, object);
            }
            ResultSet rs = ps.executeQuery();
            String scrollId = UUID.randomUUID().toString();
            this.registerCursor(scrollId, ps, rs, batchSize, keepAliveSeconds);
            return this.scroll(scrollId);
        }
        catch (SQLException e) {
            throw new NuxeoException("Error on query", (Throwable)e);
        }
    }

    protected void registerCursor(String scrollId, PreparedStatement ps, ResultSet rs, int batchSize, int keepAliveSeconds) {
        cursorResults.put(scrollId, new CursorResult(ps, rs, batchSize, keepAliveSeconds));
    }

    protected boolean unregisterCursor(String scrollId) {
        CursorResult cursor = cursorResults.remove(scrollId);
        if (cursor != null) {
            try {
                cursor.close();
                return true;
            }
            catch (SQLException e) {
                log.error((Object)("Failed to close cursor for scroll: " + scrollId), (Throwable)e);
            }
        }
        return false;
    }

    protected ScrollResult<String> defaultScroll(String query) {
        ArrayList<String> ids;
        QueryMaker queryMaker = this.findQueryMaker("NXQL");
        QueryFilter queryFilter = new QueryFilter(null, null, null, null, Collections.emptyList(), 0L, 0L);
        try (ResultSetQueryResult ret = new ResultSetQueryResult(queryMaker, query, queryFilter, this.pathResolver, this, new Object[0]);){
            ids = new ArrayList<String>((int)ret.size());
            Iterator iterator = ret.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                ids.add(((Serializable)map.get("ecm:uuid")).toString());
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Invalid scroll query: " + query, (Throwable)e);
        }
        return new ScrollResultImpl(NOSCROLL_ID, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollResult<String> scroll(String scrollId) {
        if (NOSCROLL_ID.equals(scrollId) || !this.dialect.supportsScroll()) {
            return ScrollResultImpl.emptyResult();
        }
        CursorResult cursorResult = cursorResults.get(scrollId);
        if (cursorResult == null) {
            throw new NuxeoException("Unknown or timed out scrollId");
        }
        if (cursorResult.timedOut(scrollId)) {
            throw new NuxeoException("Timed out scrollId");
        }
        cursorResult.touch();
        ArrayList<String> ids = new ArrayList<String>(cursorResult.batchSize);
        CursorResult cursorResult2 = cursorResult;
        synchronized (cursorResult2) {
            try {
                if (cursorResult.resultSet == null || cursorResult.resultSet.isClosed()) {
                    this.unregisterCursor(scrollId);
                    return ScrollResultImpl.emptyResult();
                }
                while (ids.size() < cursorResult.batchSize) {
                    if (cursorResult.resultSet.next()) {
                        ids.add(cursorResult.resultSet.getString(1));
                        continue;
                    }
                    cursorResult.close();
                    if (ids.isEmpty()) {
                        this.unregisterCursor(scrollId);
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new NuxeoException("Error during scroll", (Throwable)e);
            }
        }
        return new ScrollResultImpl(scrollId, ids);
    }

    @Override
    public Set<Serializable> getAncestorsIds(Collection<Serializable> ids) {
        HashSet<Serializable> hashSet;
        block22: {
            SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectAncestorsIds();
            if (select == null) {
                return this.getAncestorsIdsIterative(ids);
            }
            Serializable whereIds = this.newIdArray(ids);
            HashSet<Serializable> res = new HashSet<Serializable>();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(select.sql, Collections.singleton(whereIds));
            }
            Column what = select.whatColumns.get(0);
            PreparedStatement ps = this.connection.prepareStatement(select.sql);
            try {
                this.setToPreparedStatementIdArray(ps, 1, whereIds);
                try (ResultSet rs = ps.executeQuery();){
                    this.countExecute();
                    LinkedList<Serializable> debugIds = null;
                    if (this.logger.isLogEnabled()) {
                        debugIds = new LinkedList<Serializable>();
                    }
                    while (rs.next()) {
                        if (this.dialect.supportsArraysReturnInsteadOfRows()) {
                            Serializable[] resultIds;
                            for (Serializable id : resultIds = this.dialect.getArrayResult(rs.getArray(1))) {
                                if (id == null) continue;
                                res.add(id);
                                if (!this.logger.isLogEnabled()) continue;
                                debugIds.add(id);
                            }
                            continue;
                        }
                        Serializable id = what.getFromResultSet(rs, 1);
                        if (id == null) continue;
                        res.add(id);
                        if (!this.logger.isLogEnabled()) continue;
                        debugIds.add(id);
                    }
                    if (this.logger.isLogEnabled()) {
                        this.logger.logIds(debugIds, false, 0L);
                    }
                }
                hashSet = res;
                if (ps == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NuxeoException("Failed to get ancestors ids", (Throwable)e);
                }
            }
            ps.close();
        }
        return hashSet;
    }

    protected Set<Serializable> getAncestorsIdsIterative(Collection<Serializable> ids) {
        try {
            LinkedList<Serializable> todo = new LinkedList<Serializable>(ids);
            HashSet<Serializable> done = new HashSet<Serializable>();
            HashSet<Serializable> res = new HashSet<Serializable>();
            while (!todo.isEmpty()) {
                done.addAll(todo);
                SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectParentIds(todo.size());
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(select.sql, todo);
                }
                Column what = select.whatColumns.get(0);
                Column where = select.whereColumns.get(0);
                PreparedStatement ps = this.connection.prepareStatement(select.sql);
                try {
                    int i = 1;
                    for (Serializable id : todo) {
                        where.setToPreparedStatement(ps, i++, id);
                    }
                    ResultSet rs = ps.executeQuery();
                    try {
                        this.countExecute();
                        todo = new LinkedList();
                        LinkedList<Serializable> debugIds = null;
                        if (this.logger.isLogEnabled()) {
                            debugIds = new LinkedList<Serializable>();
                        }
                        while (rs.next()) {
                            Serializable id = what.getFromResultSet(rs, 1);
                            if (id == null) continue;
                            res.add(id);
                            if (!done.contains(id)) {
                                todo.add(id);
                            }
                            if (!this.logger.isLogEnabled()) continue;
                            debugIds.add(id);
                        }
                        if (!this.logger.isLogEnabled()) continue;
                        this.logger.logIds(debugIds, false, 0L);
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            return res;
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to get ancestors ids", (Throwable)e);
        }
    }

    @Override
    public void updateReadAcls() {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: updating");
        }
        try (Statement st = this.connection.createStatement();){
            String sql = this.dialect.getUpdateReadAclsSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql);
            }
            st.execute(sql);
            this.countExecute();
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new NuxeoException("Failed to update read acls", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: done.");
        }
    }

    @Override
    public void rebuildReadAcls() {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"rebuildReadAcls: rebuilding ...");
        try (Statement st = this.connection.createStatement();){
            String sql = this.dialect.getRebuildReadAclsSql();
            this.logger.log(sql);
            st.execute(sql);
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to rebuild read acls", (Throwable)e);
        }
        log.debug((Object)"rebuildReadAcls: done.");
    }

    @Override
    public Lock getLock(Serializable id) {
        RowId rowId;
        Row row;
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("getLock " + id + " while autoCommit=" + this.connection.getAutoCommit()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return (row = this.readSimpleRow(rowId = new RowId("locks", id))) == null ? null : new Lock((String)((Object)row.get("owner")), (Calendar)row.get("created"));
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) {
        Lock oldLock;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setLock " + id + " owner=" + lock.getOwner()));
        }
        if ((oldLock = this.getLock(id)) == null) {
            Row row = new Row("locks", id);
            row.put("owner", (Serializable)((Object)lock.getOwner()));
            row.put("created", lock.getCreated());
            this.insertSimpleRows("locks", Collections.singletonList(row));
        }
        return oldLock;
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) {
        Lock oldLock;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeLock " + id + " owner=" + owner + " force=" + force));
        }
        Lock lock = oldLock = force ? null : this.getLock(id);
        if (!force && owner != null) {
            if (oldLock == null) {
                return null;
            }
            if (!LockManager.canLockBeRemoved((String)oldLock.getOwner(), (String)owner)) {
                return new Lock(oldLock, true);
            }
        }
        if (force || oldLock != null) {
            this.deleteRows("locks", Collections.singleton(id));
        }
        return oldLock;
    }

    @Override
    public void markReferencedBinaries() {
        log.debug((Object)"Starting binaries GC mark");
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        String repositoryName = this.getRepositoryName();
        try (Statement st = this.connection.createStatement();){
            int i = -1;
            for (String sql : this.sqlInfo.getBinariesSql) {
                Column col = this.sqlInfo.getBinariesColumns.get(++i);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                ResultSet rs = st.executeQuery(sql);
                try {
                    this.countExecute();
                    int n = 0;
                    while (rs.next()) {
                        ++n;
                        String key = (String)((Object)col.getFromResultSet(rs, 1));
                        if (key == null) continue;
                        blobManager.markReferencedBinary(key, repositoryName);
                    }
                    if (!this.logger.isLogEnabled()) continue;
                    this.logger.logCount(n);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to mark binaries for gC", e);
        }
        log.debug((Object)"End of binaries GC mark");
    }

    protected static String systemToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.start(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA start on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NuxeoException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            this.logger.error("XA start error on " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA end on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NullPointerException e) {
            this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            if (flags != 0x20000000) {
                this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            }
            throw e;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaresource.prepare(xid);
        }
        catch (XAException e) {
            this.logger.error("XA prepare error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaresource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.logger.error("XA commit error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public void connect(boolean noSharing) {
        this.openConnections(noSharing);
    }

    @Override
    public void disconnect() {
        this.closeConnections();
    }

    @FunctionalInterface
    protected static interface BiFunctionSQLException<T, U, R> {
        public R apply(T var1, U var2) throws SQLException;
    }

    protected class CursorResult {
        protected final int keepAliveSeconds;
        protected final PreparedStatement preparedStatement;
        protected final ResultSet resultSet;
        protected final int batchSize;
        protected long lastCallTimestamp;

        CursorResult(PreparedStatement preparedStatement, ResultSet resultSet, int batchSize, int keepAliveSeconds) {
            this.preparedStatement = preparedStatement;
            this.resultSet = resultSet;
            this.batchSize = batchSize;
            this.keepAliveSeconds = keepAliveSeconds;
            this.lastCallTimestamp = System.currentTimeMillis();
        }

        boolean timedOut(String scrollId) {
            long now = System.currentTimeMillis();
            if (now - this.lastCallTimestamp > (long)(this.keepAliveSeconds * 1000)) {
                if (JDBCMapper.this.unregisterCursor(scrollId)) {
                    log.warn((Object)("Scroll " + scrollId + " timed out"));
                }
                return true;
            }
            return false;
        }

        void touch() {
            this.lastCallTimestamp = System.currentTimeMillis();
        }

        synchronized void close() throws SQLException {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }
    }
}

