/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.transaction.SystemException;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class JDBCMapperConnector
implements InvocationHandler {
    protected final Mapper mapper;
    protected final boolean noSharing;
    protected final Function<Supplier<Object>, Object> defaultRunner;

    protected JDBCMapperConnector(Mapper mapper, boolean noSharing) {
        this.mapper = mapper;
        this.noSharing = noSharing;
        this.defaultRunner = noSharing ? TransactionHelper::runInNewTransaction : TransactionHelper::runInTransaction;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (this.mapper.isConnected()) {
            if (Arrays.asList("start", "end", "prepare", "commit", "rollback").contains(name)) {
                throw new SystemException("wrong tx management invoke on managed connection");
            }
            return this.doDirectInvoke(method, args);
        }
        if ("start".equals(name)) {
            return 0;
        }
        if ("end".equals(name)) {
            return null;
        }
        if ("prepare".equals(name)) {
            return 0;
        }
        if ("commit".equals(name)) {
            return null;
        }
        if ("rollback".equals(name)) {
            return null;
        }
        if ("clearCache".equals(name)) {
            return this.doDirectInvoke(method, args);
        }
        if ("receiveInvalidations".equals(name)) {
            return this.doDirectInvoke(method, args);
        }
        if ("sendInvalidations".equals(name)) {
            return this.doDirectInvoke(method, args);
        }
        return this.doConnectAndInvoke(method, args);
    }

    protected Object doDirectInvoke(Method method, Object[] args) throws Throwable {
        Object result = this.doInvoke(method, args);
        JDBCMapperConnector.throwIfThrowable(result);
        return result;
    }

    protected Object doConnectAndInvoke(Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Object result = this.runnerOf(name).apply(() -> {
            this.mapper.connect(this.noSharingOf(name));
            try {
                Object object = this.doInvoke(method, args);
                return object;
            }
            finally {
                if (this.mapper.isConnected()) {
                    this.mapper.disconnect();
                }
            }
        });
        JDBCMapperConnector.throwIfThrowable(result);
        return result;
    }

    protected Object doInvoke(Method method, Object[] args) {
        try {
            return method.invoke((Object)this.mapper, args);
        }
        catch (InvocationTargetException cause) {
            return cause.getTargetException();
        }
        catch (Exception e) {
            return e;
        }
    }

    protected static void throwIfThrowable(Object result) throws Throwable {
        if (result instanceof Throwable) {
            if (result instanceof Exception) {
                ExceptionUtils.checkInterrupt((Exception)((Exception)result));
            }
            throw (Throwable)result;
        }
    }

    protected Function<Supplier<Object>, Object> runnerOf(String name) {
        if ("createDatabase".equals(name)) {
            return TransactionHelper::runWithoutTransaction;
        }
        return this.defaultRunner;
    }

    protected boolean noSharingOf(String name) {
        if ("createDatabase".equals(name)) {
            return true;
        }
        return this.noSharing;
    }

    public static Mapper newConnector(Mapper mapper, boolean noSharing) {
        return (Mapper)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Mapper.class}, (InvocationHandler)new JDBCMapperConnector(mapper, noSharing));
    }

    public static Mapper unwrap(Mapper mapper) {
        if (!Proxy.isProxyClass(mapper.getClass())) {
            return mapper;
        }
        return ((JDBCMapperConnector)Proxy.getInvocationHandler((Object)mapper)).mapper;
    }
}

