/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    protected final Dialect dialect;
    protected final String physicalName;
    private final String quotedName;
    private final String freeVariableSetter;
    private final ColumnType type;
    private int jdbcType;
    private final String jdbcTypeString;
    private int jdbcBaseType;
    private final String jdbcBaseTypeString;
    private final String key;
    private boolean identity;
    private boolean primary;
    private boolean nullable = true;
    private String defaultValue;
    private Table foreignTable;
    private String foreignKey;

    public Column(Table table, String physicalName, ColumnType type, String key) {
        this.table = table;
        this.dialect = table.getDialect();
        this.physicalName = physicalName;
        this.type = type;
        Dialect.JDBCInfo jdbcInfo = this.dialect.getJDBCTypeAndString(type);
        this.jdbcType = jdbcInfo.jdbcType;
        this.jdbcTypeString = jdbcInfo.string;
        this.jdbcBaseType = jdbcInfo.jdbcBaseType;
        this.jdbcBaseTypeString = jdbcInfo.jdbcBaseTypeString;
        this.key = key;
        this.quotedName = this.dialect.openQuote() + physicalName + this.dialect.closeQuote();
        this.freeVariableSetter = this.dialect.getFreeVariableSetterForType(type);
    }

    public Column(Column column, Table table) {
        this(table, column.physicalName, column.type, column.key);
    }

    public Table getTable() {
        return this.table;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public String getFullQuotedName() {
        return this.table.getQuotedName() + "." + this.quotedName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public int getJdbcBaseType() {
        return this.jdbcBaseType;
    }

    public ColumnType getType() {
        return this.type;
    }

    public ColumnType getBaseType() {
        ColumnType baseType = this.type == ColumnType.ARRAY_BLOBID ? ColumnType.BLOBID : (this.type == ColumnType.ARRAY_BOOLEAN ? ColumnType.BOOLEAN : (this.type == ColumnType.ARRAY_CLOB ? ColumnType.CLOB : (this.type == ColumnType.ARRAY_DOUBLE ? ColumnType.DOUBLE : (this.type == ColumnType.ARRAY_INTEGER ? ColumnType.INTEGER : (this.type == ColumnType.ARRAY_LONG ? ColumnType.LONG : (this.type == ColumnType.ARRAY_STRING ? ColumnType.STRING : (this.type == ColumnType.ARRAY_TIMESTAMP ? ColumnType.TIMESTAMP : this.type)))))));
        return baseType;
    }

    public String getFreeVariableSetter() {
        return this.freeVariableSetter;
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isOpaque() {
        return this.type == ColumnType.FTINDEXED || this.type == ColumnType.FTSTORED;
    }

    public String checkJdbcType(int actual, String actualName, int actualSize) {
        int expected = this.jdbcType;
        if (actual == expected) {
            return null;
        }
        if (this.dialect.isAllowedConversion(expected, actual, actualName, actualSize)) {
            return null;
        }
        return String.format("SQL type mismatch for %s: expected %s, database has %s / %s(%s)", this.getFullQuotedName(), Column.getJDBCTypeName(expected), Column.getJDBCTypeName(actual), actualName, actualSize);
    }

    protected static String getJDBCTypeName(int expected) {
        try {
            return JDBCType.valueOf(expected).getName();
        }
        catch (IllegalArgumentException e) {
            return String.valueOf(expected);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setReferences(Table foreignTable, String foreignKey) {
        this.foreignTable = foreignTable;
        this.foreignKey = foreignKey;
    }

    public Table getForeignTable() {
        return this.foreignTable;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public String getSqlTypeString() {
        return this.jdbcTypeString;
    }

    public String getSqlBaseTypeString() {
        return this.jdbcBaseTypeString;
    }

    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value) throws SQLException {
        if (value == null) {
            ps.setNull(index, this.jdbcType);
            return;
        }
        if (this.jdbcType == 2003 && !(value instanceof Object[])) {
            throw new SQLException("Expected an array value instead of: " + value);
        }
        this.dialect.setToPreparedStatement(ps, index, value, this);
    }

    public Serializable getFromResultSet(ResultSet rs, int index) throws SQLException {
        Serializable result = this.dialect.getFromResultSet(rs, index, this);
        if (rs.wasNull()) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.physicalName + ")";
    }
}

