/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class TableImpl
implements Table {
    private static final long serialVersionUID = 1L;
    protected final Dialect dialect;
    protected final String key;
    protected final String name;
    private final LinkedHashMap<String, Column> columns;
    private Column primaryColumn;
    private final List<String[]> indexedColumns;
    private final Map<String[], String> indexNames;
    private final Map<String[], Table.IndexType> indexTypes;
    private boolean hasFulltextIndex;

    public TableImpl(Dialect dialect, String name, String key) {
        this.dialect = dialect;
        this.key = key;
        this.name = name;
        this.columns = new LinkedHashMap();
        this.indexedColumns = new LinkedList<String[]>();
        this.indexNames = new HashMap<String[], String>();
        this.indexTypes = new HashMap<String[], Table.IndexType>();
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public Table getRealTable() {
        return this;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getPhysicalName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.dialect.openQuote() + this.name + this.dialect.closeQuote();
    }

    @Override
    public String getQuotedSuffixedName(String suffix) {
        return this.dialect.openQuote() + this.name + suffix + this.dialect.closeQuote();
    }

    @Override
    public Column getColumn(String name) {
        return this.columns.get(name);
    }

    @Override
    public Column getPrimaryColumn() {
        if (this.primaryColumn == null) {
            for (Column column : this.columns.values()) {
                if (!column.isPrimary()) continue;
                this.primaryColumn = column;
                break;
            }
        }
        return this.primaryColumn;
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public Column addColumn(String name, Column column) {
        if (this.columns.containsKey(name)) {
            throw new IllegalArgumentException("duplicate column " + name);
        }
        this.columns.put(name, column);
        return column;
    }

    @Override
    public Column addColumn(String name, ColumnType type, String key, Model model) {
        String physicalName = this.dialect.getColumnName(name);
        Column column = new Column(this, physicalName, type, key);
        return this.addColumn(name, column);
    }

    @Override
    public void addIndex(String ... columnNames) {
        this.indexedColumns.add(columnNames);
    }

    @Override
    public void addIndex(String indexName, Table.IndexType indexType, String ... columnNames) {
        this.addIndex(columnNames);
        this.indexNames.put(columnNames, indexName);
        this.indexTypes.put(columnNames, indexType);
        if (indexType == Table.IndexType.FULLTEXT) {
            this.hasFulltextIndex = true;
        }
    }

    @Override
    public boolean hasFulltextIndex() {
        return this.hasFulltextIndex;
    }

    @Override
    public String getCreateSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getQuotedName());
        sb.append(" (");
        String custom = this.dialect.getCustomColumnDefinition(this);
        if (custom != null) {
            sb.append(custom);
            sb.append(", ");
        }
        Iterator<Column> it = this.columns.values().iterator();
        while (it.hasNext()) {
            this.addOneColumn(sb, it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        sb.append(this.dialect.getTableTypeString(this));
        return sb.toString();
    }

    @Override
    public String getAddColumnSql(Column column) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ");
        sb.append(this.getQuotedName());
        sb.append(' ');
        sb.append(this.dialect.getAddColumnString());
        sb.append(' ');
        this.addOneColumn(sb, column);
        return sb.toString();
    }

    protected void addOneColumn(StringBuilder sb, Column column) {
        sb.append(column.getQuotedName());
        sb.append(' ');
        sb.append(column.getSqlTypeString());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            sb.append(" DEFAULT ");
            sb.append(defaultValue);
        }
        if (column.isNullable()) {
            sb.append(this.dialect.getNullColumnString());
        } else {
            sb.append(" NOT NULL");
        }
    }

    @Override
    public List<String> getPostCreateSqls(Model model) {
        LinkedList<String> sqls = new LinkedList<String>();
        List<String> custom = this.dialect.getCustomPostCreateSqls(this, model);
        sqls.addAll(custom);
        for (Column column : this.columns.values()) {
            this.postAddColumn(column, sqls, model);
        }
        return sqls;
    }

    @Override
    public List<String> getPostAddSqls(Column column, Model model) {
        LinkedList<String> sqls = new LinkedList<String>();
        this.postAddColumn(column, sqls, model);
        return sqls;
    }

    protected void postAddColumn(Column column, List<String> sqls, Model model) {
        Table ft;
        if (!(!column.isPrimary() || column.isIdentity() && this.dialect.isIdentityAlreadyPrimary())) {
            StringBuilder sb = new StringBuilder();
            String constraintName = this.dialect.openQuote() + this.dialect.getPrimaryKeyConstraintName(this.key) + this.dialect.closeQuote();
            sb.append("ALTER TABLE ");
            sb.append(this.getQuotedName());
            sb.append(this.dialect.getAddPrimaryKeyConstraintString(constraintName));
            sb.append('(');
            sb.append(column.getQuotedName());
            sb.append(')');
            sqls.add(sb.toString());
        }
        if (column.isIdentity()) {
            sqls.addAll(this.dialect.getPostCreateIdentityColumnSql(column));
        }
        if ((ft = column.getForeignTable()) != null) {
            Column fc = ft.getColumn(column.getForeignKey());
            String constraintName = this.dialect.openQuote() + this.dialect.getForeignKeyConstraintName(this.key, column.getPhysicalName(), ft.getPhysicalName()) + this.dialect.closeQuote();
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ");
            sb.append(this.getQuotedName());
            sb.append(this.dialect.getAddForeignKeyConstraintString(constraintName, new String[]{column.getQuotedName()}, ft.getQuotedName(), new String[]{fc.getQuotedName()}, true));
            if (this.dialect.supportsCircularCascadeDeleteConstraints() || "id".equals(fc.getPhysicalName()) && "id".equals(column.getPhysicalName())) {
                sb.append(" ON DELETE CASCADE");
            }
            sqls.add(sb.toString());
        }
        String columnName = column.getKey();
        block0: for (String[] columnNames : this.indexedColumns) {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(columnNames));
            if (!names.contains(columnName)) continue;
            for (Column column2 : this.getColumns()) {
                String key = column2.getKey();
                names.remove(key);
                if (!names.isEmpty()) continue;
                if (!columnName.equals(key)) continue block0;
            }
            ArrayList<Column> cols = new ArrayList<Column>(columnNames.length);
            for (String name : columnNames) {
                Column col = this.getColumn(name);
                cols.add(col);
            }
            String string = this.indexNames.get(columnNames);
            Table.IndexType indexType = this.indexTypes.get(columnNames);
            String createIndexSql = this.dialect.getCreateIndexSql(string, indexType, this, cols, model);
            sqls.add(createIndexSql);
        }
    }

    @Override
    public String getDropSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            sb.append("IF EXISTS ");
        }
        sb.append(this.getQuotedName());
        sb.append(this.dialect.getCascadeDropConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            sb.append(" IF EXISTS");
        }
        return sb.toString();
    }

    public String toString() {
        return "Table(" + this.name + ")";
    }
}

