/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ServerConfigurator;

public class TomcatConfigurator
extends ServerConfigurator {
    public static final String STARTUP_CLASS = "org.apache.catalina.startup.Bootstrap";
    private String contextName = null;
    public static final String TOMCAT_HOME = "tomcat.home";
    public static final String PARAM_HTTP_TOMCAT_ADMIN_PORT = "nuxeo.server.tomcat_admin.port";

    public TomcatConfigurator(ConfigurationGenerator configurationGenerator) {
        super(configurationGenerator);
        log.debug((Object)"Detected Tomcat server.");
    }

    @Override
    protected boolean isConfigured() {
        return new File(this.generator.getNuxeoHome(), this.getTomcatConfig()).exists();
    }

    @Override
    protected String getDefaultDataDir() {
        return "nxserver" + File.separator + "data";
    }

    @Override
    public void checkPaths() throws ConfigurationException {
        super.checkPaths();
        File oldPath = new File(this.getRuntimeHome(), "data" + File.separator + "vcsh2repo");
        Object message = String.format("NXP-5370, NXP-5460. Please rename 'vcsh2repo' directory from %s to %s", oldPath, new File(this.generator.getDataDir(), "h2" + File.separator + "nuxeo"));
        this.checkPath(oldPath, (String)message);
        oldPath = new File(this.getRuntimeHome(), "data" + File.separator + "derby" + File.separator + "nxsqldirectory");
        message = "NXP-5370, NXP-5460. It is not possible to migrate Derby data." + System.getProperty("line.separator") + "Please remove 'nx*' directories from " + oldPath.getParent() + System.getProperty("line.separator") + "or edit templates/default/" + this.getTomcatConfig() + System.getProperty("line.separator") + "following https://github.com/nuxeo/nuxeo-distribution/blob/release-5.3.2/nuxeo-distribution-resources/src/main/resources/templates-tomcat/default/conf/Catalina/localhost/nuxeo.xml";
        this.checkPath(oldPath, (String)message);
    }

    @Override
    public File getLogConfFile() {
        return new File(this.getServerLibDir(), "log4j2.xml");
    }

    @Override
    public File getConfigDir() {
        return new File(this.getRuntimeHome(), "config");
    }

    public String getTomcatConfig() {
        return "conf" + File.separator + "Catalina" + File.separator + "localhost" + File.separator + this.getContextName() + ".xml";
    }

    public String getContextName() {
        if (this.contextName == null) {
            CryptoProperties userConfig = this.generator.getUserConfig();
            this.contextName = userConfig != null ? this.generator.getUserConfig().getProperty("org.nuxeo.ecm.contextPath", "/nuxeo").substring(1) : "/nuxeo".substring(1);
        }
        return this.contextName;
    }

    @Override
    public void prepareWizardStart() {
        try {
            File contextXML = new File(this.generator.getNuxeoHome(), this.getTomcatConfig());
            contextXML.delete();
            File wizardWAR = new File(this.generator.getNuxeoHome(), "templates" + File.separator + "nuxeo-wizard.war");
            File nuxeoWAR = new File(this.generator.getNuxeoHome(), "webapps" + File.separator + this.getContextName() + ".war");
            nuxeoWAR.delete();
            FileUtils.copyFile((File)wizardWAR, (File)nuxeoWAR);
        }
        catch (IOException e) {
            log.error((Object)"Could not change Tomcat configuration to run wizard instead of Nuxeo.", (Throwable)e);
        }
    }

    @Override
    public void cleanupPostWizard() {
        File nuxeoWAR = new File(this.generator.getNuxeoHome(), "webapps" + File.separator + this.getContextName());
        if (nuxeoWAR.exists()) {
            try {
                FileUtils.deleteDirectory((File)nuxeoWAR);
            }
            catch (IOException e) {
                log.error((Object)("Could not delete " + nuxeoWAR), (Throwable)e);
            }
        }
        if ((nuxeoWAR = new File(nuxeoWAR.getPath() + ".war")).exists() && !FileUtils.deleteQuietly((File)nuxeoWAR)) {
            log.warn((Object)("Could not delete " + nuxeoWAR));
            try {
                nuxeoWAR.deleteOnExit();
            }
            catch (SecurityException e) {
                log.warn((Object)("Cannot delete " + nuxeoWAR));
            }
        }
    }

    @Override
    public boolean isWizardAvailable() {
        File wizardWAR = new File(this.generator.getNuxeoHome(), "templates" + File.separator + "nuxeo-wizard.war");
        return wizardWAR.exists();
    }

    @Override
    public File getRuntimeHome() {
        return new File(this.generator.getNuxeoHome(), "nxserver");
    }

    @Override
    public File getServerLibDir() {
        return new File(this.generator.getNuxeoHome(), "lib");
    }

    @Override
    protected void checkNetwork() throws ConfigurationException {
        InetAddress bindAddress = this.generator.getBindAddress();
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.generator.getUserConfig().getProperty(PARAM_HTTP_TOMCAT_ADMIN_PORT)));
    }

    @Override
    protected void addServerSpecificParameters(Map<String, String> parametersmigration) {
        parametersmigration.put("nuxeo.server.tomcat-admin.port", PARAM_HTTP_TOMCAT_ADMIN_PORT);
    }
}

