/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.Comments;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class AnnotationServiceImpl
extends DefaultComponent
implements AnnotationService {
    private static final Log log = LogFactory.getLog(AnnotationServiceImpl.class);
    protected static final String GET_ANNOTATION_PAGEPROVIDER_NAME = "GET_ANNOTATION_AS_EXTERNAL_ENTITY";
    protected static final String GET_ANNOTATIONS_FOR_DOC_PAGEPROVIDER_NAME = "GET_ANNOTATIONS_FOR_DOCUMENT";

    public Annotation createAnnotation(CoreSession session, Annotation annotation) throws CommentSecurityException {
        String parentId = annotation.getParentId();
        if (!session.hasPermission((DocumentRef)new IdRef(parentId), "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " can not create annotations on document " + parentId);
        }
        return (Annotation)CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel docToAnnotate = s.getDocument((DocumentRef)new IdRef(annotation.getParentId()));
            DocumentModel annotationModel = s.createDocumentModel("Annotation");
            Comments.annotationToDocumentModel((Annotation)annotation, (DocumentModel)annotationModel);
            if (annotation instanceof ExternalEntity) {
                annotationModel.addFacet("ExternalEntity");
                Comments.externalEntityToDocumentModel((ExternalEntity)((ExternalEntity)annotation), (DocumentModel)annotationModel);
            }
            annotationModel = ((CommentManager)Framework.getService(CommentManager.class)).createComment(docToAnnotate, annotationModel);
            return Comments.newAnnotation((DocumentModel)annotationModel);
        });
    }

    public Annotation getAnnotation(CoreSession session, String annotationId) throws CommentNotFoundException, CommentSecurityException {
        IdRef annotationRef = new IdRef(annotationId);
        if (!session.exists((DocumentRef)annotationRef)) {
            throw new CommentNotFoundException("The document " + annotationId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        return (Annotation)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> AnnotationServiceImpl.lambda$getAnnotation$1((DocumentRef)annotationRef, principal, arg_0));
    }

    public List<Annotation> getAnnotations(CoreSession session, String documentId, String xpath) throws CommentNotFoundException, CommentSecurityException {
        IdRef docRef = new IdRef(documentId);
        if (!session.exists((DocumentRef)docRef)) {
            throw new CommentNotFoundException("The document " + documentId + " does not exist.");
        }
        if (!session.hasPermission((DocumentRef)docRef, "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " does not have access to the annotations of document " + documentId);
        }
        DocumentModel annotatedDoc = session.getDocument((DocumentRef)docRef);
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        if (commentManager.hasFeature(CommentManager.Feature.COMMENTS_LINKED_WITH_PROPERTY)) {
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            return (List)CoreInstance.doPrivileged((CoreSession)session, s -> {
                Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)s);
                PageProvider pageProvider = ppService.getPageProvider(GET_ANNOTATIONS_FOR_DOC_PAGEPROVIDER_NAME, null, null, null, props, new Object[]{documentId, xpath});
                return pageProvider.getCurrentPage().stream().map(Comments::newAnnotation).collect(Collectors.toList());
            });
        }
        return (List)CoreInstance.doPrivileged((CoreSession)session, s -> commentManager.getComments(s, annotatedDoc).stream().filter(annotationModel -> "Annotation".equals(annotationModel.getType()) && xpath.equals(annotationModel.getPropertyValue("annotation:xpath"))).map(Comments::newAnnotation).collect(Collectors.toList()));
    }

    public void updateAnnotation(CoreSession session, String annotationId, Annotation annotation) throws CommentNotFoundException, CommentSecurityException {
        IdRef annotationRef = new IdRef(annotationId);
        if (!session.exists((DocumentRef)annotationRef)) {
            throw new CommentNotFoundException("The annotation " + annotationId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        if (!principal.isAdministrator() && !annotation.getAuthor().equals(principal.getName())) {
            throw new CommentSecurityException("The user " + principal.getName() + " can not edit annotations of document " + annotation.getParentId());
        }
        CoreInstance.doPrivileged((CoreSession)session, s -> {
            DocumentModel annotationModel = s.getDocument((DocumentRef)annotationRef);
            Comments.annotationToDocumentModel((Annotation)annotation, (DocumentModel)annotationModel);
            if (annotation instanceof ExternalEntity) {
                Comments.externalEntityToDocumentModel((ExternalEntity)((ExternalEntity)annotation), (DocumentModel)annotationModel);
            }
            s.saveDocument(annotationModel);
        });
    }

    public void deleteAnnotation(CoreSession session, String annotationId) throws CommentNotFoundException {
        NuxeoPrincipal principal = session.getPrincipal();
        CoreInstance.doPrivileged((CoreSession)session, s -> {
            try {
                DocumentModel annotation = s.getDocument((DocumentRef)new IdRef(annotationId));
                String parentId = (String)((Object)annotation.getPropertyValue("comment:parentId"));
                IdRef parentRef = new IdRef(parentId);
                if (!(principal.isAdministrator() || annotation.getPropertyValue("comment:author").equals(principal.getName()) || s.hasPermission(principal, (DocumentRef)parentRef, "Everything"))) {
                    throw new CommentSecurityException("The user " + principal.getName() + " can not delete annotations of document " + parentId);
                }
            }
            catch (DocumentNotFoundException e) {
                throw new CommentNotFoundException((Throwable)e);
            }
            ((CommentManager)Framework.getService(CommentManager.class)).deleteComment(s, annotationId);
        });
    }

    public Annotation getExternalAnnotation(CoreSession session, String entityId) throws CommentNotFoundException, CommentSecurityException {
        DocumentModel annotationModel = this.getAnnotationModel(session, entityId);
        if (annotationModel == null) {
            throw new CommentNotFoundException("The external annotation " + entityId + " does not exist.");
        }
        String parentId = (String)((Object)annotationModel.getPropertyValue("comment:parentId"));
        if (!session.hasPermission((DocumentRef)new IdRef(parentId), "Read")) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " does not have access to the annotations of document " + parentId);
        }
        return Comments.newAnnotation((DocumentModel)annotationModel);
    }

    public void updateExternalAnnotation(CoreSession session, String entityId, Annotation annotation) throws CommentNotFoundException, CommentSecurityException {
        NuxeoPrincipal principal = session.getPrincipal();
        if (!principal.isAdministrator() && !annotation.getAuthor().equals(principal.getName())) {
            throw new CommentSecurityException("The user " + session.getPrincipal().getName() + " can not edit annotations of document " + annotation.getParentId());
        }
        DocumentModel annotationModel = this.getAnnotationModel(session, entityId);
        if (annotationModel == null) {
            throw new CommentNotFoundException("The external annotation " + entityId + " does not exist.");
        }
        Comments.annotationToDocumentModel((Annotation)annotation, (DocumentModel)annotationModel);
        if (annotation instanceof ExternalEntity) {
            Comments.externalEntityToDocumentModel((ExternalEntity)((ExternalEntity)annotation), (DocumentModel)annotationModel);
        }
        session.saveDocument(annotationModel);
    }

    public void deleteExternalAnnotation(CoreSession session, String entityId) throws CommentNotFoundException, CommentSecurityException {
        DocumentModel annotationModel = this.getAnnotationModel(session, entityId);
        if (annotationModel == null) {
            throw new CommentNotFoundException("The external annotation " + entityId + " does not exist.");
        }
        NuxeoPrincipal principal = session.getPrincipal();
        String parentId = (String)((Object)annotationModel.getPropertyValue("comment:parentId"));
        if (!(principal.isAdministrator() || annotationModel.getPropertyValue("comment:author").equals(principal.getName()) || session.hasPermission((DocumentRef)new IdRef(parentId), "Everything"))) {
            throw new CommentSecurityException("The user " + principal.getName() + " can not delete annotations of document " + parentId);
        }
        ((CommentManager)Framework.getService(CommentManager.class)).deleteComment(session, annotationModel.getId());
    }

    protected DocumentModel getAnnotationModel(CoreSession session, String entityId) {
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        Map<String, Serializable> props = Collections.singletonMap("coreSession", (Serializable)session);
        List results = ppService.getPageProvider(GET_ANNOTATION_PAGEPROVIDER_NAME, null, Long.valueOf(1L), Long.valueOf(0L), props, new Object[]{entityId}).getCurrentPage();
        if (results.isEmpty()) {
            return null;
        }
        return (DocumentModel)results.get(0);
    }

    private static /* synthetic */ Annotation lambda$getAnnotation$1(DocumentRef annotationRef, NuxeoPrincipal principal, CoreSession s) {
        DocumentModel annotationModel = s.getDocument(annotationRef);
        String parentId = (String)((Object)annotationModel.getPropertyValue("comment:parentId"));
        if (!s.hasPermission(principal, (DocumentRef)new IdRef(parentId), "Read")) {
            throw new CommentSecurityException("The user " + principal.getName() + " does not have access to the annotations of document " + parentId);
        }
        return Comments.newAnnotation((DocumentModel)annotationModel);
    }
}

