/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentConverter;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.Comments;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.comment.impl.AbstractCommentManager;
import org.nuxeo.ecm.platform.comment.impl.CommentSorter;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public class CommentManagerImpl
extends AbstractCommentManager {
    private static final Log log = LogFactory.getLog(CommentManagerImpl.class);
    final SimpleDateFormat timeFormat = new SimpleDateFormat("dd-HHmmss.S");
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
    final CommentServiceConfig config;
    final CommentConverter commentConverter;

    public CommentManagerImpl(CommentServiceConfig config) {
        this.config = config;
        this.commentConverter = config.getCommentConverter();
    }

    public List<DocumentModel> getComments(CoreSession s, DocumentModel docModel) throws CommentSecurityException {
        return this.doPrivileged(s, docModel.getRepositoryName(), session -> {
            Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", session);
            RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
            Graph graph = relationManager.getGraph(this.config.graphName, session);
            Resource docResource = relationManager.getResource(this.config.documentNamespace, (Serializable)docModel, ctxMap);
            if (docResource == null) {
                throw new NuxeoException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
            }
            List statementList = graph.getStatements(null, null, (Node)docResource);
            if (graph instanceof JenaGraph) {
                QNameResourceImpl oldDocResource = new QNameResourceImpl(this.config.documentNamespace, docModel.getId());
                statementList.addAll(graph.getStatements(null, null, (Node)oldDocResource));
            }
            ArrayList<DocumentModel> commentList = new ArrayList<DocumentModel>();
            for (Statement stmt : statementList) {
                QNameResourceImpl subject = (QNameResourceImpl)stmt.getSubject();
                DocumentModel commentDocModel = (DocumentModel)relationManager.getResourceRepresentation(this.config.commentNamespace, (Resource)subject, ctxMap);
                if (commentDocModel == null) {
                    log.warn((Object)"Could not adapt comment relation subject to a document model; check the service relation adapters configur  ation");
                    continue;
                }
                commentList.add(commentDocModel);
            }
            CommentSorter sorter = new CommentSorter(true);
            Collections.sort(commentList, sorter);
            return commentList;
        });
    }

    public DocumentModel createComment(DocumentModel docModel, String comment, String author) {
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel commentDM = session.createDocumentModel("Comment");
            commentDM.setPropertyValue("comment:text", (Serializable)((Object)comment));
            commentDM.setPropertyValue("comment:author", (Serializable)((Object)author));
            commentDM.setPropertyValue("comment:creationDate", (Serializable)Calendar.getInstance());
            commentDM = this.internalCreateComment((CoreSession)session, docModel, commentDM, null);
            session.save();
            DocumentModel documentModel = commentDM;
            return documentModel;
        }
    }

    public DocumentModel createComment(DocumentModel docModel, String comment) {
        String author = CommentManagerImpl.getCurrentUser(docModel);
        return this.createComment(docModel, comment, author);
    }

    private static String updateAuthor(DocumentModel docModel, DocumentModel comment) {
        String author = (String)comment.getProperty("comment", "author");
        if (author == null) {
            log.debug((Object)"deprecated use of createComment: the client should set the author property on document");
            author = CommentManagerImpl.getCurrentUser(docModel);
            comment.setProperty("comment", "author", (Object)author);
        }
        return author;
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel comment) throws CommentSecurityException {
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            comment.setPropertyValue("comment:ancestorIds", (Serializable)((Object)this.computeAncestorIds((CoreSession)session, docModel.getId())));
            DocumentModel doc = this.internalCreateComment((CoreSession)session, docModel, comment, null);
            session.save();
            doc.detach(true);
            DocumentModel documentModel = doc;
            return documentModel;
        }
    }

    protected DocumentModel internalCreateComment(CoreSession session, DocumentModel docModel, DocumentModel comment, String path) {
        DocumentModel createdComment = this.createCommentDocModel(session, docModel, comment, path);
        RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
        Resource commentRes = relationManager.getResource(this.config.commentNamespace, (Serializable)createdComment, null);
        Resource documentRes = relationManager.getResource(this.config.documentNamespace, (Serializable)docModel, null);
        if (commentRes == null || documentRes == null) {
            throw new NuxeoException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
        }
        ResourceImpl predicateRes = new ResourceImpl(this.config.predicateNamespace);
        StatementImpl stmt = new StatementImpl((Node)commentRes, (Node)predicateRes, (Node)documentRes);
        relationManager.getGraph(this.config.graphName, session).add((Statement)stmt);
        this.notifyEvent(session, "commentAdded", docModel, createdComment);
        return createdComment;
    }

    private DocumentModel createCommentDocModel(CoreSession mySession, DocumentModel docModel, DocumentModel comment, String path) {
        CommentManagerImpl.updateAuthor(docModel, comment);
        String[] pathList = this.getCommentPathList(comment);
        Object domainPath = path == null ? "/" + docModel.getPath().segment(0) : path;
        if (mySession == null) {
            return null;
        }
        DocumentModel parent = mySession.getDocument((DocumentRef)new PathRef((String)domainPath));
        for (String name : pathList) {
            String pathStr = parent.getPathAsString();
            PathRef ref = new PathRef(pathStr, name);
            if (mySession.exists((DocumentRef)ref)) {
                parent = mySession.getDocument((DocumentRef)ref);
                if (parent.isFolder()) continue;
                throw new NuxeoException(parent.getPathAsString() + " is not folderish");
            }
            parent = this.createHiddenFolder(mySession, pathStr, name);
        }
        String pathStr = parent.getPathAsString();
        String commentName = this.getCommentName(docModel, comment);
        CommentConverter converter = this.config.getCommentConverter();
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel commentDocModel = mySession.createDocumentModel(comment.getType());
        commentDocModel.setProperty("dublincore", "title", (Object)commentName);
        converter.updateDocumentModel(commentDocModel, comment);
        commentDocModel.setPathInfo(pathStr, pss.generatePathSegment(commentDocModel));
        commentDocModel = mySession.createDocument(commentDocModel);
        log.debug((Object)("created comment with id=" + commentDocModel.getId()));
        return commentDocModel;
    }

    protected DocumentModel createHiddenFolder(CoreSession session, String parentPath, String name) {
        DocumentModel dm = session.createDocumentModel(parentPath, name, "HiddenFolder");
        dm.setProperty("dublincore", "title", (Object)name);
        dm.setProperty("dublincore", "description", (Object)"");
        Framework.doPrivileged(() -> dm.setProperty("dublincore", "created", (Object)Calendar.getInstance()));
        DocumentModel parent = session.createDocument(dm);
        this.setFolderPermissions(session, parent);
        return parent;
    }

    private String[] getCommentPathList(DocumentModel comment) {
        String[] pathList = new String[]{"Comments", this.dateFormat.format(CommentManagerImpl.getCommentTimeStamp(comment))};
        return pathList;
    }

    @Deprecated
    private static String getCurrentUser(DocumentModel target) {
        CoreSession userSession = target.getCoreSession();
        if (userSession == null) {
            throw new NuxeoException("userSession is null, do not invoke this method when the user is not local");
        }
        return userSession.getPrincipal().getName();
    }

    private String getCommentName(DocumentModel target, DocumentModel comment) {
        String author = (String)comment.getProperty("comment", "author");
        if (author == null) {
            author = CommentManagerImpl.getCurrentUser(target);
        }
        Date creationDate = CommentManagerImpl.getCommentTimeStamp(comment);
        return "COMMENT-" + author + "-" + this.timeFormat.format(creationDate.getTime());
    }

    private static Date getCommentTimeStamp(DocumentModel comment) {
        Calendar creationDate;
        try {
            creationDate = (Calendar)comment.getProperty("dublincore", "created");
        }
        catch (PropertyException e) {
            creationDate = null;
        }
        if (creationDate == null) {
            creationDate = Calendar.getInstance();
        }
        return creationDate.getTime();
    }

    public void deleteComment(DocumentModel docModel, DocumentModel comment) {
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentRef ref = comment.getRef();
            if (!session.exists(ref)) {
                throw new NuxeoException("Comment Document does not exist: " + comment.getId());
            }
            session.removeDocument(ref);
            this.notifyEvent((CoreSession)session, "commentRemoved", docModel, comment);
            session.save();
        }
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel parent, DocumentModel child) {
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel parentDocModel = session.getDocument(parent.getRef());
            String containerPath = parent.getPath().removeLastSegments(1).toString();
            DocumentModel newComment = this.internalCreateComment((CoreSession)session, parentDocModel, child, containerPath);
            session.save();
            DocumentModel documentModel = newComment;
            return documentModel;
        }
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) {
        return this.doPrivileged(comment.getCoreSession(), comment.getRepositoryName(), session -> {
            Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", session);
            RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
            Graph graph = relationManager.getGraph(this.config.graphName, session);
            Resource commentResource = relationManager.getResource(this.config.commentNamespace, (Serializable)comment, ctxMap);
            if (commentResource == null) {
                throw new NuxeoException("Could not adapt document model to relation resource ; check the service relation adapters configuration");
            }
            ResourceImpl predicate = new ResourceImpl(this.config.predicateNamespace);
            List statementList = graph.getStatements((Node)commentResource, (Node)predicate, null);
            if (graph instanceof JenaGraph) {
                QNameResourceImpl oldDocResource = new QNameResourceImpl(this.config.commentNamespace, comment.getId());
                statementList.addAll(graph.getStatements((Node)oldDocResource, (Node)predicate, null));
            }
            ArrayList<DocumentModel> docList = new ArrayList<DocumentModel>();
            for (Statement stmt : statementList) {
                QNameResourceImpl subject = (QNameResourceImpl)stmt.getObject();
                DocumentModel docModel = (DocumentModel)relationManager.getResourceRepresentation(this.config.documentNamespace, (Resource)subject, ctxMap);
                if (docModel == null) {
                    log.warn((Object)"Could not adapt comment relation subject to a document model; check the service relation adapters configuration");
                    continue;
                }
                docModel.detach(true);
                docList.add(docModel);
            }
            return docList;
        });
    }

    protected List<DocumentModel> doPrivileged(CoreSession session, String repositoryName, Function<CoreSession, List<DocumentModel>> function) {
        if (session == null) {
            return (List)CoreInstance.doPrivileged((String)repositoryName, function);
        }
        return (List)CoreInstance.doPrivileged((CoreSession)session, function);
    }

    public DocumentModel createLocatedComment(DocumentModel docModel, DocumentModel comment, String path) throws CommentSecurityException {
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)docModel.getRepositoryName());){
            DocumentModel createdComment = this.internalCreateComment((CoreSession)session, docModel, comment, path);
            session.save();
            DocumentModel documentModel = createdComment;
            return documentModel;
        }
    }

    public DocumentModel getThreadForComment(DocumentModel comment) throws CommentSecurityException {
        List<DocumentModel> threads = this.getDocumentsForComment(comment);
        if (threads.size() > 0) {
            DocumentModel thread = threads.get(0);
            while (thread.getType().equals("Post") || thread.getType().equals("Comment")) {
                thread = this.getThreadForComment(thread);
            }
            return thread;
        }
        return null;
    }

    public Comment createComment(CoreSession session, Comment comment) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(comment.getParentId());
        if (!session.exists((DocumentRef)commentRef)) {
            throw new CommentNotFoundException("The document " + comment.getParentId() + " does not exist.");
        }
        DocumentModel docToComment = session.getDocument((DocumentRef)commentRef);
        DocumentModel commentModel = session.createDocumentModel("Comment");
        commentModel.setPropertyValue("dc:created", (Serializable)Calendar.getInstance());
        Comments.commentToDocumentModel((Comment)comment, (DocumentModel)commentModel);
        if (comment instanceof ExternalEntity) {
            commentModel.addFacet("ExternalEntity");
            Comments.externalEntityToDocumentModel((ExternalEntity)((ExternalEntity)comment), (DocumentModel)commentModel);
        }
        DocumentModel createdCommentModel = this.createComment(docToComment, commentModel);
        return Comments.newComment((DocumentModel)createdCommentModel);
    }

    public Comment getComment(CoreSession session, String commentId) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        if (!session.exists((DocumentRef)commentRef)) {
            throw new CommentNotFoundException("The document " + commentId + " does not exist.");
        }
        DocumentModel commentModel = session.getDocument((DocumentRef)commentRef);
        return Comments.newComment((DocumentModel)commentModel);
    }

    public PartialList<Comment> getComments(CoreSession s, String documentId, Long pageSize, Long currentPageIndex, boolean sortAscending) throws CommentSecurityException {
        return (PartialList)CoreInstance.doPrivileged((CoreSession)s, session -> {
            IdRef docRef = new IdRef(documentId);
            if (!session.exists((DocumentRef)docRef)) {
                return new PartialList(Collections.emptyList(), 0L);
            }
            DocumentModel commentedDoc = session.getDocument((DocumentRef)docRef);
            List<DocumentModel> comments = this.getComments(commentedDoc);
            long maxSize = pageSize == null || pageSize <= 0L ? (long)comments.size() : pageSize;
            long offset = currentPageIndex == null || currentPageIndex <= 0L ? 0L : currentPageIndex * pageSize;
            return comments.stream().sorted(Comparator.comparing(doc -> (Calendar)doc.getPropertyValue("dc:created"))).skip(offset).limit(maxSize).map(Comments::newComment).collect(Collectors.collectingAndThen(Collectors.toList(), list -> new PartialList(list, (long)comments.size())));
        });
    }

    public Comment updateComment(CoreSession session, String commentId, Comment comment) throws NuxeoException {
        throw new UnsupportedOperationException("Update a comment is not possible through this implementation");
    }

    public void deleteComment(CoreSession s, String commentId) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        CoreInstance.doPrivileged((CoreSession)s, arg_0 -> this.lambda$deleteComment$6((DocumentRef)commentRef, commentId, arg_0));
    }

    public Comment getExternalComment(CoreSession session, String entityId) throws NuxeoException {
        throw new UnsupportedOperationException("Get a comment from its external entity id is not possible through this implementation");
    }

    public Comment updateExternalComment(CoreSession session, String entityId, Comment comment) throws NuxeoException {
        throw new UnsupportedOperationException("Update a comment from its external entity id is not possible through this implementation");
    }

    public void deleteExternalComment(CoreSession session, String entityId) throws NuxeoException {
        throw new UnsupportedOperationException("Delete a comment from its external entity id is not possible through this implementation");
    }

    public boolean hasFeature(CommentManager.Feature feature) {
        switch (feature) {
            case COMMENTS_LINKED_WITH_PROPERTY: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    private /* synthetic */ void lambda$deleteComment$6(DocumentRef commentRef, String commentId, CoreSession session) {
        if (!session.exists(commentRef)) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist.");
        }
        DocumentModel comment = session.getDocument(commentRef);
        DocumentModel commentedDoc = session.getDocument((DocumentRef)new IdRef((String)((Object)comment.getPropertyValue("comment:parentId"))));
        this.deleteComment(commentedDoc, comment);
    }
}

