/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.impl.BridgeCommentManager;
import org.nuxeo.ecm.platform.comment.impl.CommentManagerImpl;
import org.nuxeo.ecm.platform.comment.impl.PropertyCommentManager;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class CommentService
extends DefaultComponent {
    public static final String ID = "org.nuxeo.ecm.platform.comment.service.CommentService";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.comment.service.CommentService");
    public static final String VERSIONING_EXTENSION_POINT_RULES = "rules";
    private static final Log log = LogFactory.getLog(CommentService.class);
    protected volatile CommentManager commentManager;
    private CommentServiceConfig config;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("config".equals(extensionPoint)) {
            this.config = (CommentServiceConfig)contribution;
            log.debug((Object)("registered service config: " + this.config));
        } else {
            log.warn((Object)("unknown extension point: " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public CommentManager getCommentManager() {
        log.debug((Object)"getCommentManager");
        if (this.commentManager == null) {
            this.commentManager = new CommentManagerImpl(this.config);
        }
        return this.commentManager;
    }

    public CommentServiceConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommentService.class) {
            return adapter.cast((Object)this);
        }
        if (this.commentManager == null) {
            CommentService commentService = this;
            synchronized (commentService) {
                if (this.commentManager == null) {
                    this.commentManager = this.recomputeCommentManager();
                }
            }
        }
        return (T)this.commentManager;
    }

    protected CommentManager recomputeCommentManager() {
        MigrationService migrationService = (MigrationService)Framework.getService(MigrationService.class);
        MigrationService.MigrationStatus status = migrationService.getStatus("comment-storage");
        if (status == null) {
            throw new IllegalStateException("Unknown migration status for: comment-storage");
        }
        if (status.isRunning()) {
            String step = status.getStep();
            if ("relation-to-property".equals(step)) {
                return new BridgeCommentManager(new CommentManagerImpl(this.config), new PropertyCommentManager());
            }
            throw new IllegalStateException("Unknown migration step: " + step);
        }
        String state = status.getState();
        if ("relation".equals(state)) {
            return new CommentManagerImpl(this.config);
        }
        if ("property".equals(state)) {
            return new PropertyCommentManager();
        }
        throw new IllegalStateException("Unknown migration state: " + state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCommentManagerImplementation() {
        CommentService commentService = this;
        synchronized (commentService) {
            this.commentManager = this.recomputeCommentManager();
        }
    }
}

