/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.cache.CachableBlobHolder;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;

public class ConversionCacheEntry {
    protected Date lastAccessTime;
    protected BlobHolder bh;
    protected boolean persisted = false;
    protected String persistPath;
    protected long sizeInKB = 0L;

    public ConversionCacheEntry(BlobHolder bh) {
        this.bh = bh;
        this.updateAccessTime();
    }

    protected void updateAccessTime() {
        this.lastAccessTime = new Date();
    }

    public boolean persist(String basePath) throws IOException {
        if (this.bh instanceof CachableBlobHolder) {
            CachableBlobHolder cbh = (CachableBlobHolder)this.bh;
            this.persistPath = cbh.persist(basePath);
            if (this.persistPath != null) {
                this.sizeInKB = new File(this.persistPath).length() / 1024L;
                this.persisted = true;
            }
        }
        this.bh = null;
        return this.persisted;
    }

    public void remove() {
        if (this.persisted && this.persistPath != null) {
            new File(this.persistPath).delete();
        }
    }

    public BlobHolder restore() {
        this.updateAccessTime();
        if (this.persisted && this.persistPath != null) {
            try {
                SimpleCachableBlobHolder holder = new SimpleCachableBlobHolder();
                holder.load(this.persistPath);
                return holder;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public long getDiskSpaceUsageInKB() {
        return this.sizeInKB;
    }

    public Date getLastAccessedTime() {
        return this.lastAccessTime;
    }
}

