/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;

public interface DocumentModel
extends Serializable {
    public static final int REFRESH_STATE = 1;
    @Deprecated
    public static final int REFRESH_PREFETCH = 4;
    public static final int REFRESH_ACP_IF_LOADED = 8;
    public static final int REFRESH_ACP_LAZY = 16;
    public static final int REFRESH_ACP = 32;
    public static final int REFRESH_CONTENT_IF_LOADED = 64;
    public static final int REFRESH_CONTENT_LAZY = 128;
    public static final int REFRESH_CONTENT = 256;
    public static final int REFRESH_IF_LOADED = 73;
    public static final int REFRESH_LAZY = 145;
    public static final int REFRESH_ALL = 289;
    public static final int REFRESH_DEFAULT = 137;

    public DocumentType getDocumentType();

    public String getSessionId();

    public CoreSession getCoreSession();

    public void detach(boolean var1);

    public void attach(String var1);

    public DocumentRef getRef();

    public DocumentRef getParentRef();

    public String getId();

    public String getName();

    public Long getPos();

    public String getTitle();

    public String getPathAsString();

    public Path getPath();

    public String getType();

    public String[] getSchemas();

    public boolean hasSchema(String var1);

    public Set<String> getFacets();

    public boolean hasFacet(String var1);

    public boolean addFacet(String var1);

    public boolean removeFacet(String var1);

    @Deprecated
    public Collection<DataModel> getDataModelsCollection();

    @Deprecated
    public Map<String, DataModel> getDataModels();

    @Deprecated
    public DataModel getDataModel(String var1);

    public void setPathInfo(String var1, String var2);

    public boolean isLocked();

    public Lock setLock() throws LockException;

    public Lock getLockInfo();

    public Lock removeLock() throws LockException;

    public boolean isCheckedOut();

    public void checkOut();

    public DocumentRef checkIn(VersioningOption var1, String var2);

    public String getVersionLabel();

    public String getCheckinComment();

    public String getVersionSeriesId();

    public boolean isLatestVersion();

    public boolean isMajorVersion();

    public boolean isLatestMajorVersion();

    public boolean isVersionSeriesCheckedOut();

    public ACP getACP();

    public void setACP(ACP var1, boolean var2);

    public Object getProperty(String var1, String var2);

    public Property getPropertyObject(String var1, String var2);

    public void setProperty(String var1, String var2, Object var3);

    public Map<String, Object> getProperties(String var1);

    public void setProperties(String var1, Map<String, Object> var2);

    public boolean isTrashed();

    public boolean isFolder();

    public boolean isVersionable();

    public boolean isDownloadable();

    public boolean isVersion();

    public boolean isProxy();

    public boolean isImmutable();

    public boolean isDirty();

    public void accept(PropertyVisitor var1, Object var2);

    public <T> T getAdapter(Class<T> var1);

    public <T> T getAdapter(Class<T> var1, boolean var2);

    public String getCurrentLifeCycleState();

    public String getLifeCyclePolicy();

    public boolean followTransition(String var1);

    public Collection<String> getAllowedStateTransitions();

    public Map<String, Serializable> getContextData();

    public Serializable getContextData(String var1);

    public void putContextData(String var1, Serializable var2);

    public void copyContextData(DocumentModel var1);

    public void copyContent(DocumentModel var1);

    public String getRepositoryName();

    public String getCacheKey();

    public String getSourceId();

    @Deprecated
    public boolean isPrefetched(String var1);

    @Deprecated
    public boolean isPrefetched(String var1, String var2);

    public void prefetchCurrentLifecycleState(String var1);

    public void prefetchLifeCyclePolicy(String var1);

    public boolean isLifeCycleLoaded();

    public <T extends Serializable> T getSystemProp(String var1, Class<T> var2);

    @Deprecated
    public DocumentPart getPart(String var1);

    @Deprecated
    public DocumentPart[] getParts();

    public Collection<Property> getPropertyObjects(String var1);

    public Property getProperty(String var1) throws PropertyException;

    public Serializable getPropertyValue(String var1) throws PropertyException;

    public void setPropertyValue(String var1, Serializable var2) throws PropertyException;

    public void reset();

    public void refresh(int var1, String[] var2);

    public void refresh();

    public DocumentModel clone() throws CloneNotSupportedException;

    public String getChangeToken();

    public Map<String, String> getBinaryFulltext();

    public PropertyObjectResolver getObjectResolver(String var1);

    public static class DocumentModelRefresh {
        public String lifeCycleState;
        public String lifeCyclePolicy;
        public boolean isCheckedOut;
        public boolean isLatestVersion;
        public boolean isMajorVersion;
        public boolean isLatestMajorVersion;
        public boolean isVersionSeriesCheckedOut;
        public String versionSeriesId;
        public String checkinComment;
        public ACP acp;
        public Set<String> instanceFacets;
        public DocumentPart[] documentParts;
        public boolean isTrashed;
    }
}

