/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.runtime.api.login.LoginComponent;

public class ClientLoginModule
implements LoginModule {
    protected static final LoginStack globalInstance = LoginStack.synchronizedStack();
    protected static final ThreadLocal<LoginStack> threadInstance = new ThreadLocal<LoginStack>(){

        @Override
        protected LoginStack initialValue() {
            return new LoginStack();
        }
    };
    private Subject subject;
    private Map<String, ?> sharedState;
    private LoginStack stack;
    private boolean commited = false;

    public static void clearThreadLocalLogin() {
        threadInstance.remove();
    }

    public static LoginStack getThreadLocalLogin() {
        return threadInstance.get();
    }

    public static LoginStack.Entry getCurrentLogin() {
        LoginStack.Entry entry = threadInstance.get().peek();
        if (entry == null) {
            entry = globalInstance.peek();
        }
        return entry;
    }

    public static NuxeoPrincipal getCurrentPrincipal() {
        LoginStack.Entry entry = ClientLoginModule.getCurrentLogin();
        if (entry != null) {
            Principal p = entry.getPrincipal();
            if (p instanceof NuxeoPrincipal) {
                return (NuxeoPrincipal)p;
            }
            if (LoginComponent.isSystemLogin((Object)p)) {
                return new SystemPrincipal(p.getName());
            }
        }
        return null;
    }

    public static boolean isCurrentAdministrator() {
        NuxeoPrincipal principal = ClientLoginModule.getCurrentPrincipal();
        return principal != null && principal.isAdministrator();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.sharedState = sharedState;
        boolean globalLogin = true;
        String global = (String)options.get("global");
        if (global != null) {
            globalLogin = Boolean.parseBoolean(global);
        }
        this.stack = globalLogin ? threadInstance.get() : globalInstance;
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Principal p = null;
        Object user = this.sharedState.get("javax.security.auth.login.name");
        if (user instanceof Principal) {
            p = (Principal)user;
        } else {
            Set<Principal> principals = this.subject.getPrincipals();
            if (!principals.isEmpty()) {
                p = principals.iterator().next();
            }
        }
        if (p != null) {
            Object credential = this.sharedState.get("javax.security.auth.login.password");
            this.stack.push(p, credential, this.subject);
            this.commited = true;
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.commited = false;
        this.stack.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.commited) {
            this.stack.pop();
            this.commited = false;
        }
        return true;
    }
}

