/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public class ConstraintViolation
implements Serializable {
    private static final Log log = LogFactory.getLog(ConstraintViolation.class);
    private static final long serialVersionUID = 1L;
    private final Schema schema;
    private final List<PathNode> path;
    private final Constraint constraint;
    private final Object invalidValue;

    public ConstraintViolation(Schema schema, List<PathNode> fieldPath, Constraint constraint, Object invalidValue) {
        this.schema = schema;
        this.path = new ArrayList<PathNode>(fieldPath);
        this.constraint = constraint;
        this.invalidValue = invalidValue;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<PathNode> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public String getMessage(Locale locale) {
        String message;
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(this.constraint.getDescription().getName());
        pathTokens.add(this.schema.getName());
        for (PathNode node : this.path) {
            String name = node.getField().getName().getLocalName();
            pathTokens.add(name);
        }
        String key = StringUtils.join(pathTokens, (char)'.');
        Object computedInvalidValue = "null";
        if (this.invalidValue != null) {
            String invalidValueString = this.invalidValue.toString();
            computedInvalidValue = invalidValueString.length() > 20 ? invalidValueString.substring(0, 15) + "..." : invalidValueString;
        }
        Object[] params = new Object[]{computedInvalidValue};
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        try {
            message = I18NUtils.getMessageString((String)"messages", (String)key, (Object[])params, (Locale)computedLocale);
        }
        catch (MissingResourceException e) {
            log.trace((Object)"No bundle found", (Throwable)e);
            message = null;
        }
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        if (locale != null && Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            return this.constraint.getErrorMessage(this.invalidValue, locale);
        }
        return this.getMessage(Locale.ENGLISH);
    }

    public String toString() {
        return this.getMessage(Locale.ENGLISH);
    }

    public static class PathNode {
        private Field field;
        private boolean listItem = false;
        int index = 0;

        public PathNode(Field field) {
            this.field = field;
        }

        public PathNode(Field field, int index) {
            this.field = field;
            this.index = index;
            this.listItem = true;
        }

        public Field getField() {
            return this.field;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isListItem() {
            return this.listItem;
        }

        public String toString() {
            if (this.listItem) {
                return this.field.getName().getPrefixedName();
            }
            return this.field.getName().getPrefixedName() + "[" + this.index + "]";
        }
    }
}

