/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;

public class DocumentValidationReport {
    protected List<ConstraintViolation> violations;

    public DocumentValidationReport(List<ConstraintViolation> violations) {
        this.violations = violations;
    }

    public boolean hasError() {
        return !this.violations.isEmpty();
    }

    public int numberOfErrors() {
        return this.violations.size();
    }

    public List<ConstraintViolation> asList() {
        return Collections.unmodifiableList(this.violations);
    }

    public String toString() {
        if (this.violations != null) {
            StringBuilder res = new StringBuilder();
            for (ConstraintViolation violation : this.violations) {
                res.append(violation.getMessage(Locale.ENGLISH)).append('\n');
            }
            return res.toString();
        }
        return "no error";
    }
}

