/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;

public interface BlobProvider {
    public void initialize(String var1, Map<String, String> var2) throws IOException;

    public void close();

    default public boolean isTransient() {
        return false;
    }

    public Blob readBlob(BlobInfo var1) throws IOException;

    public String writeBlob(Blob var1) throws IOException;

    public boolean supportsUserUpdate();

    default public InputStream getStream(ManagedBlob blob) throws IOException {
        return null;
    }

    default public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        return null;
    }

    default public URI getURI(ManagedBlob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        return null;
    }

    default public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        return Collections.emptyMap();
    }

    default public boolean canConvert(ManagedBlob blob, String mimeType) {
        try {
            Map<String, URI> availableConversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
            return availableConversions.containsKey(mimeType);
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    default public boolean isVersion(ManagedBlob blob) {
        return false;
    }

    default public List<AppLink> getAppLinks(String user, ManagedBlob blob) throws IOException {
        return Collections.emptyList();
    }

    default public BinaryManager getBinaryManager() {
        return null;
    }

    default public boolean performsExternalAccessControl(BlobInfo blobInfo) {
        return false;
    }

    public Map<String, String> getProperties();

    default public boolean hasCreateFromKeyPermission() {
        return false;
    }
}

