/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.collections.api.FavoritesManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class FavoritesJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "favorites";
    public static final String IS_FAVORITE = "isFavorite";

    public FavoritesJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartObject();
        boolean isFavorite = false;
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            isFavorite = ((FavoritesManager)Framework.getService(FavoritesManager.class)).isFavorite(document, wrapper.getSession());
        }
        jg.writeBooleanField(IS_FAVORITE, isFavorite);
        jg.writeEndObject();
    }
}

