/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.adapter;

import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.io.TaskCompletionRequest;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="task", type="taskAdapter")
public class TaskAdapter
extends DefaultAdapter {
    public static final String NAME = "task";

    @PUT
    @Path(value="{taskId}/{action}")
    public Response completeTask(@PathParam(value="taskId") String taskId, @PathParam(value="action") String action, TaskCompletionRequest taskCompletionRequest) {
        Map data = taskCompletionRequest.getDataMap();
        CoreSession session = this.getContext().getCoreSession();
        ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).endTask(session, (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class), data, action);
        Task completedTask = (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class);
        return Response.ok((Object)completedTask).status(Response.Status.OK).build();
    }

    @GET
    public List<Task> doGet(@QueryParam(value="userId") String userId, @QueryParam(value="workflowInstanceId") String workflowInstanceId, @QueryParam(value="workflowModelName") String workflowModelName) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getTasks(doc, userId, workflowInstanceId, workflowModelName, this.getContext().getCoreSession());
    }
}

