/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;

public class DocumentTypeImpl
extends CompositeTypeImpl
implements DocumentType {
    private static final long serialVersionUID = 1L;
    protected Set<String> facets;
    protected PrefetchInfo prefetchInfo;
    protected Set<String> subtypes;
    protected Set<String> forbiddenSubtypes;
    protected Set<String> allowedSubtypes;

    public DocumentTypeImpl(String name, DocumentType superType, List<Schema> schemas, Collection<String> facets, PrefetchInfo prefetchInfo) {
        super(superType, "@doctypes", name, schemas);
        this.facets = facets == null ? Collections.emptySet() : new HashSet<String>(facets);
        this.prefetchInfo = prefetchInfo;
    }

    public DocumentTypeImpl(String name) {
        this(name, null, Collections.emptyList(), Collections.emptySet(), null);
    }

    public void setPrefetchInfo(PrefetchInfo prefetchInfo) {
        this.prefetchInfo = prefetchInfo;
    }

    @Override
    public PrefetchInfo getPrefetchInfo() {
        return this.prefetchInfo;
    }

    @Override
    public boolean isFile() {
        return !this.facets.contains("Folderish");
    }

    @Override
    public boolean isFolder() {
        return this.facets.contains("Folderish");
    }

    @Override
    public boolean isOrdered() {
        return this.facets.contains("Orderable");
    }

    @Override
    public Set<String> getFacets() {
        return this.facets;
    }

    @Override
    public boolean hasFacet(String facetName) {
        return this.facets.contains(facetName);
    }

    @Override
    public Set<String> getSubtypes() {
        return this.subtypes;
    }

    @Override
    public void setSubtypes(Collection<String> subtypes) {
        this.subtypes = subtypes == null ? Collections.emptySet() : new HashSet<String>(subtypes);
        this.allowedSubtypes = new HashSet<String>(this.subtypes);
        if (this.forbiddenSubtypes != null) {
            this.allowedSubtypes.removeAll(this.forbiddenSubtypes);
        }
    }

    @Override
    public boolean hasSubtype(String subtype) {
        return this.subtypes.contains(subtype);
    }

    @Override
    public Set<String> getForbiddenSubtypes() {
        return this.forbiddenSubtypes;
    }

    @Override
    public void setForbiddenSubtypes(Collection<String> forbiddenSubtypes) {
        this.forbiddenSubtypes = forbiddenSubtypes == null ? Collections.emptySet() : new HashSet<String>(forbiddenSubtypes);
        if (this.subtypes != null) {
            this.allowedSubtypes = new HashSet<String>(this.subtypes);
            this.allowedSubtypes.removeAll(this.forbiddenSubtypes);
        }
    }

    @Override
    public boolean hasForbiddenSubtype(String subtype) {
        return this.forbiddenSubtypes.contains(subtype);
    }

    @Override
    public Set<String> getAllowedSubtypes() {
        return this.allowedSubtypes;
    }

    @Override
    public boolean hasAllowedSubtype(String subtype) {
        return this.allowedSubtypes.contains(subtype);
    }
}

