/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.EnumConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.LengthConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.PatternConstraint;

public final class StringType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "string";
    public static final StringType INSTANCE = new StringType();

    private StringType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return true;
    }

    @Override
    public Object convert(Object value) {
        return value.toString();
    }

    @Override
    public Object decode(String str) {
        return str;
    }

    @Override
    public String encode(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public Object newInstance() {
        return "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public boolean support(Class<? extends Constraint> constraint) {
        if (NotNullConstraint.class.equals(constraint)) {
            return true;
        }
        if (EnumConstraint.class.equals(constraint)) {
            return true;
        }
        if (PatternConstraint.class.equals(constraint)) {
            return true;
        }
        return LengthConstraint.class.equals(constraint);
    }
}

