/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public abstract class AbstractObjectResolver
implements ObjectResolver {
    private static final long serialVersionUID = 1L;
    protected Map<String, Serializable> parameters;
    protected boolean validation;

    @Override
    public void configure(Map<String, String> parameters) throws IllegalArgumentException, IllegalStateException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        this.validation = Boolean.parseBoolean(parameters.getOrDefault("validation", Boolean.TRUE.toString()));
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put("validation", Boolean.valueOf(this.validation));
    }

    @Override
    public Map<String, Serializable> getParameters() {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        return !this.validation || this.fetch(value) != null;
    }

    @Override
    public boolean validate(Object value, Object context) throws IllegalStateException {
        this.checkConfig();
        return !this.validation || this.fetch(value, context) != null;
    }

    protected void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }
}

