/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;

public class NotificationCheckedInListener
implements EventListener {
    private static final Log log = LogFactory.getLog(NotificationCheckedInListener.class);

    public void handleEvent(Event event) {
        if (!"documentCheckedIn".equals(event.getName())) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            log.warn((Object)"Can not handle event that is not bound to a DocumentEventContext");
            return;
        }
        DocumentEventContext context = (DocumentEventContext)event.getContext();
        CoreSession session = context.getCoreSession();
        DocumentModel docModel = context.getSourceDocument();
        if (docModel.hasFacet("Notifiable")) {
            DocumentRef versionRef = (DocumentRef)context.getProperty("checkedInVersionRef");
            DocumentModel version = session.getDocument(versionRef);
            ((SubscriptionAdapter)version.getAdapter(SubscriptionAdapter.class)).clearNotification();
            session.saveDocument(version);
        }
    }
}

