/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.EnumSet;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class FilterAllocationDecider
extends AllocationDecider {
    public static final String NAME = "filter";
    private static final String CLUSTER_ROUTING_REQUIRE_GROUP_PREFIX = "cluster.routing.allocation.require";
    private static final String CLUSTER_ROUTING_INCLUDE_GROUP_PREFIX = "cluster.routing.allocation.include";
    private static final String CLUSTER_ROUTING_EXCLUDE_GROUP_PREFIX = "cluster.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.require.", key -> Setting.simpleString(key, (value, map) -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.include.", key -> Setting.simpleString(key, (value, map) -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.exclude.", key -> Setting.simpleString(key, (value, map) -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    static EnumSet<RecoverySource.Type> INITIAL_RECOVERY_TYPES = EnumSet.of(RecoverySource.Type.EMPTY_STORE, RecoverySource.Type.LOCAL_SHARDS);
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    public FilterAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.setClusterRequireFilters(CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(settings));
        this.setClusterExcludeFilters(CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(settings));
        this.setClusterIncludeFilters(CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(settings));
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_REQUIRE_GROUP_SETTING, this::setClusterRequireFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING, this::setClusterExcludeFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_INCLUDE_GROUP_SETTING, this::setClusterIncludeFilters, (a, b) -> {});
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd;
        DiscoveryNodeFilters initialRecoveryFilters;
        if (shardRouting.unassigned() && (initialRecoveryFilters = (indexMd = allocation.metaData().getIndexSafe(shardRouting.index())).getInitialRecoveryFilters()) != null && INITIAL_RECOVERY_TYPES.contains((Object)shardRouting.recoverySource().getType()) && !initialRecoveryFilters.match(node.node())) {
            String explanation = shardRouting.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS ? "initial allocation of the shrunken index is only allowed on nodes [%s] that hold a copy of every shard in the index" : "initial allocation of the index is only allowed on nodes [%s]";
            return allocation.decision(Decision.NO, NAME, explanation, initialRecoveryFilters);
        }
        return this.shouldFilter(shardRouting, node, allocation);
    }

    @Override
    public Decision canAllocate(IndexMetaData indexMetaData, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetaData, node, allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation);
    }

    private Decision shouldFilter(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(allocation.metaData().getIndexSafe(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldFilter(IndexMetaData indexMd, RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldIndexFilter(IndexMetaData indexMd, RoutingNode node, RoutingAllocation allocation) {
        if (indexMd.requireFilters() != null && !indexMd.requireFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", "index.routing.allocation.require", indexMd.requireFilters());
        }
        if (indexMd.includeFilters() != null && !indexMd.includeFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", "index.routing.allocation.include", indexMd.includeFilters());
        }
        if (indexMd.excludeFilters() != null && indexMd.excludeFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node matches index setting [%s] filters [%s]", IndexMetaData.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey(), indexMd.excludeFilters());
        }
        return null;
    }

    private Decision shouldClusterFilter(RoutingNode node, RoutingAllocation allocation) {
        if (this.clusterRequireFilters != null && !this.clusterRequireFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match cluster setting [%s] filters [%s]", CLUSTER_ROUTING_REQUIRE_GROUP_PREFIX, this.clusterRequireFilters);
        }
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not cluster setting [%s] filters [%s]", CLUSTER_ROUTING_INCLUDE_GROUP_PREFIX, this.clusterIncludeFilters);
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node matches cluster setting [%s] filters [%s]", CLUSTER_ROUTING_EXCLUDE_GROUP_PREFIX, this.clusterExcludeFilters);
        }
        return null;
    }

    private void setClusterRequireFilters(Map<String, String> filters) {
        this.clusterRequireFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, filters);
    }

    private void setClusterIncludeFilters(Map<String, String> filters) {
        this.clusterIncludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, filters);
    }

    private void setClusterExcludeFilters(Map<String, String> filters) {
        this.clusterExcludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, filters);
    }
}

