/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Callback;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeCallback
implements Callback {
    private List<Callback> callbacks = new CopyOnWriteArrayList<Callback>();
    private boolean initialized;

    @Override
    public List<Callback> callbacks() {
        return this.callbacks;
    }

    @Override
    public void addCallback(Callback callback) {
        if (this.initialized) {
            callback.initialize();
        }
        this.callbacks.add(callback);
    }

    @Override
    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
        if (this.initialized) {
            callback.cleanup();
        }
    }

    @Override
    public void initialize() {
        this.initialized = true;
        for (Callback c : this.callbacks) {
            try {
                c.initialize();
            }
            catch (Exception e) {
                this.warning("Initialization error", e);
            }
        }
    }

    @Override
    public void cleanup() {
        this.initialized = false;
        for (Callback c : this.callbacks) {
            try {
                c.cleanup();
            }
            catch (Exception e) {
                this.warning("Deactivation error", e);
            }
        }
    }

    @Override
    public void reset(Simon simon) {
        for (Callback c : this.callbacks) {
            c.reset(simon);
        }
    }

    @Override
    public void stopwatchAdd(Stopwatch stopwatch, long ns) {
        for (Callback c : this.callbacks) {
            c.stopwatchAdd(stopwatch, ns);
        }
    }

    @Override
    public void stopwatchStart(Split split) {
        for (Callback c : this.callbacks) {
            c.stopwatchStart(split);
        }
    }

    @Override
    public void stopwatchStop(Split split) {
        for (Callback c : this.callbacks) {
            c.stopwatchStop(split);
        }
    }

    @Override
    public void counterDecrease(Counter counter, long dec) {
        for (Callback c : this.callbacks) {
            c.counterDecrease(counter, dec);
        }
    }

    @Override
    public void counterIncrease(Counter counter, long inc) {
        for (Callback c : this.callbacks) {
            c.counterIncrease(counter, inc);
        }
    }

    @Override
    public void counterSet(Counter counter, long val) {
        for (Callback c : this.callbacks) {
            c.counterSet(counter, val);
        }
    }

    @Override
    public void simonCreated(Simon simon) {
        for (Callback c : this.callbacks) {
            c.simonCreated(simon);
        }
    }

    @Override
    public void simonDestroyed(Simon simon) {
        for (Callback c : this.callbacks) {
            c.simonDestroyed(simon);
        }
    }

    @Override
    public void clear() {
        for (Callback c : this.callbacks) {
            c.clear();
        }
    }

    @Override
    public void message(String message) {
        for (Callback c : this.callbacks) {
            c.message(message);
        }
    }

    @Override
    public void warning(String warning, Exception cause) {
        for (Callback c : this.callbacks) {
            c.warning(warning, cause);
        }
    }
}

