/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.javasimon.Callback;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.SimonException;
import org.javasimon.SimonPattern;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.utils.Replacer;
import org.mvel2.MVEL;
import org.mvel2.compiler.ExecutableAccessor;

public interface FilterCallback
extends Callback {
    public void addRule(Rule.Type var1, String var2, String var3, Callback.Event ... var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rule {
        public static final String VAR_SPLIT = "split";
        public static final String VAR_ACTIVE = "active";
        public static final String VAR_MAX_ACTIVE = "maxactive";
        public static final String VAR_COUNTER = "counter";
        public static final String VAR_MAX = "max";
        public static final String VAR_MIN = "min";
        public static final String VAR_TOTAL = "total";
        public static final String VAR_VALUE = "value";
        private static final Replacer[] CONDITION_REPLACERS = new Replacer[]{new Replacer(" lt ", " < "), new Replacer(" le ", " <= "), new Replacer(" eq ", " == "), new Replacer(" ne ", " != "), new Replacer(" gt ", " > "), new Replacer(" ge ", " >= ")};
        private Type type;
        private String condition;
        private ExecutableAccessor expression;
        private SimonPattern pattern;

        Rule(Type type, String condition, SimonPattern pattern) {
            this.type = type;
            this.condition = condition;
            if (condition != null) {
                condition = condition.toLowerCase();
                for (Replacer conditionReplacer : CONDITION_REPLACERS) {
                    condition = conditionReplacer.process(condition);
                }
                try {
                    this.expression = (ExecutableAccessor)MVEL.compileExpression((String)condition);
                    if (!this.expression.getKnownEgressType().equals(Boolean.class)) {
                        throw new SimonException("Expression '" + condition + "' does not return boolean.");
                    }
                }
                catch (Exception e) {
                    throw new SimonException(e);
                }
            }
            this.pattern = pattern;
        }

        public Type getType() {
            return this.type;
        }

        public String getCondition() {
            return this.condition;
        }

        public SimonPattern getPattern() {
            return this.pattern;
        }

        boolean checkCondition(Simon simon, Object ... params) {
            if (this.condition == null) {
                return true;
            }
            if (simon instanceof Stopwatch) {
                return this.checkStopwtach((Stopwatch)simon, params);
            }
            if (simon instanceof Counter) {
                return this.checkCounter((Counter)simon, params);
            }
            return true;
        }

        private boolean checkCounter(Counter counter, Object ... params) {
            HashMap<String, BigDecimal> vars = new HashMap<String, BigDecimal>();
            this.processParams(vars, params);
            vars.put(VAR_COUNTER, BigDecimal.valueOf(counter.getCounter()));
            vars.put(VAR_MAX, BigDecimal.valueOf(counter.getMax()));
            vars.put(VAR_MIN, BigDecimal.valueOf(counter.getMin()));
            return this.eval(vars);
        }

        private boolean checkStopwtach(Stopwatch stopwatch, Object ... params) {
            HashMap<String, BigDecimal> vars = new HashMap<String, BigDecimal>();
            this.processParams(vars, params);
            vars.put(VAR_ACTIVE, BigDecimal.valueOf(stopwatch.getActive()));
            vars.put(VAR_COUNTER, BigDecimal.valueOf(stopwatch.getCounter()));
            vars.put(VAR_MAX, BigDecimal.valueOf(stopwatch.getMax()));
            vars.put(VAR_MIN, BigDecimal.valueOf(stopwatch.getMin()));
            vars.put(VAR_MAX_ACTIVE, BigDecimal.valueOf(stopwatch.getMaxActive()));
            vars.put(VAR_TOTAL, BigDecimal.valueOf(stopwatch.getTotal()));
            return this.eval(vars);
        }

        private void processParams(Map<String, BigDecimal> vars, Object ... params) {
            for (Object param : params) {
                if (param instanceof Split) {
                    vars.put(VAR_SPLIT, BigDecimal.valueOf(((Split)param).runningFor()));
                    continue;
                }
                if (!(param instanceof Long)) continue;
                vars.put(VAR_VALUE, BigDecimal.valueOf((Long)param));
            }
        }

        private boolean eval(Map<String, BigDecimal> vars) {
            return (Boolean)MVEL.executeExpression((Object)this.expression, vars);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            MUST,
            SUFFICE,
            MUST_NOT;

        }
    }
}

