/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.login.GroupImpl;

public abstract class NuxeoAbstractServerLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog(NuxeoAbstractServerLoginModule.class);
    protected Subject subject;
    protected Map<String, Object> sharedState;
    protected Map<String, Object> options;
    protected boolean loginOk;
    protected String principalClassName;
    protected NuxeoPrincipal unauthenticatedIdentity;
    protected CallbackHandler callbackHandler;
    protected boolean useFirstPass;

    protected abstract NuxeoPrincipal getIdentity();

    protected abstract Group[] getRoleSets() throws LoginException;

    protected abstract NuxeoPrincipal createIdentity(String var1) throws LoginException;

    @Override
    public boolean abort() throws LoginException {
        log.trace((Object)"abort");
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Group[] roleSets;
        log.trace((Object)("commit, loginOk=" + this.loginOk));
        if (!this.loginOk) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        NuxeoPrincipal identity = this.getIdentity();
        principals.add((Principal)identity);
        for (Group group : roleSets = this.getRoleSets()) {
            String name = group.getName();
            Group subjectGroup = this.createGroup(name, principals);
            Enumeration members = group.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String passwordStacking;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (log.isTraceEnabled()) {
            log.trace((Object)("initialize, instance=@" + System.identityHashCode(this)));
        }
        if ((passwordStacking = (String)options.get("password-stacking")) != null && passwordStacking.equalsIgnoreCase("useFirstPass")) {
            this.useFirstPass = true;
        }
        this.principalClassName = (String)options.get("principalClass");
        String name = (String)options.get("unauthenticatedIdentity");
        if (name != null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(name);
                log.trace((Object)("Saw unauthenticatedIdentity=" + name));
            }
            catch (LoginException e) {
                log.warn((Object)"Failed to create custom unauthenticatedIdentity", (Throwable)e);
            }
        }
    }

    @Override
    public boolean logout() throws LoginException {
        log.trace((Object)"logout");
        NuxeoPrincipal identity = this.getIdentity();
        Set<Principal> principals = this.subject.getPrincipals();
        principals.remove(identity);
        return true;
    }

    protected Group createGroup(String name, Set<Principal> principals) {
        GroupImpl roles = null;
        for (Principal principal : principals) {
            Group grp;
            if (!(principal instanceof Group) || !(grp = (Group)principal).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new GroupImpl(name);
            principals.add((Principal)((Object)roles));
        }
        return roles;
    }
}

