/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.impl;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="NXP_LOGS_EXTINFO")
@DiscriminatorColumn(name="DISCRIMINATOR")
public class ExtendedInfoImpl
implements ExtendedInfo {
    private static final long serialVersionUID = 1L;
    private Long id;

    private ExtendedInfoImpl() {
    }

    public static ExtendedInfoImpl createExtendedInfo(Serializable value) {
        Class<?> clazz = value.getClass();
        if (Long.class.isAssignableFrom(clazz)) {
            return new LongInfo((Long)value);
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return new DoubleInfo((Double)value);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateInfo((Date)value);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return new StringInfo((String)((Object)value));
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return new BooleanInfo((Boolean)value);
        }
        return new BlobInfo(value);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="LOG_EXTINFO_ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Transient
    public Serializable getSerializableValue() {
        throw new UnsupportedOperationException();
    }

    public <T> T getValue(Class<T> clazz) {
        return clazz.cast(this.getSerializableValue());
    }

    @Entity
    @DiscriminatorValue(value="BLOB")
    public static class BlobInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private Serializable blobValue;

        private BlobInfo() {
        }

        public BlobInfo(Serializable value) {
            this.blobValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return this.blobValue;
        }

        @Column(name="LOG_EXTINFO_BLOB")
        @Lob
        public Serializable getBlobValue() {
            return this.blobValue;
        }

        public void setBlobValue(Serializable value) {
            this.blobValue = value;
        }
    }

    @Entity
    @DiscriminatorValue(value="BOOLEAN")
    public static class BooleanInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private Boolean booleanValue;

        private BooleanInfo() {
        }

        public BooleanInfo(Boolean value) {
            this.booleanValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return this.booleanValue;
        }

        @Column(name="LOG_EXTINFO_BOOLEAN")
        public Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(Boolean value) {
            this.booleanValue = value;
        }
    }

    @Entity
    @DiscriminatorValue(value="DOUBLE")
    public static class DoubleInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private Double doubleValue;

        private DoubleInfo() {
        }

        public DoubleInfo(Double value) {
            this.doubleValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return this.doubleValue;
        }

        @Column(name="LOG_EXTINFO_DOUBLE")
        public Double getDoubleValue() {
            return this.doubleValue;
        }

        public void setDoubleValue(Double value) {
            this.doubleValue = value;
        }
    }

    @Entity
    @DiscriminatorValue(value="STRING")
    public static class StringInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private String stringValue;

        private StringInfo() {
        }

        public StringInfo(String value) {
            this.stringValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return this.stringValue;
        }

        @Column(name="LOG_EXTINFO_STRING", length=1024)
        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String value) {
            this.stringValue = value;
        }
    }

    @Entity
    @DiscriminatorValue(value="DATE")
    public static class DateInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private Date dateValue;

        private DateInfo() {
        }

        public DateInfo(Date value) {
            this.dateValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return this.dateValue;
        }

        @Column(name="LOG_EXTINFO_DATE")
        @Temporal(value=TemporalType.TIMESTAMP)
        public Date getDateValue() {
            return this.dateValue;
        }

        public void setDateValue(Date value) {
            this.dateValue = value;
        }
    }

    @Entity
    @DiscriminatorValue(value="LONG")
    public static class LongInfo
    extends ExtendedInfoImpl {
        private static final long serialVersionUID = 1L;
        private long longValue;

        private LongInfo() {
        }

        public LongInfo(long value) {
            this.longValue = value;
        }

        @Override
        @Transient
        public Serializable getSerializableValue() {
            return Long.valueOf(this.longValue);
        }

        @Column(name="LOG_EXTINFO_LONG")
        public Long getLongValue() {
            return this.longValue;
        }

        public void setLongValue(Long value) {
            this.longValue = value;
        }
    }
}

