/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.query.sql.model.Literals;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;

public class LogEntryProvider
implements BaseLogEntryProvider {
    private static final Log log = LogFactory.getLog(LogEntryProvider.class);
    public static final String LIKE = "LIKE";
    protected final EntityManager em;

    private LogEntryProvider(EntityManager em) {
        this.em = em;
    }

    public static LogEntryProvider createProvider(EntityManager em) {
        return new LogEntryProvider(em);
    }

    public void append(List<LogEntry> entries) {
        entries.forEach(e -> {
            if (this.em.contains(e)) {
                log.warn((Object)("Log entry already exists for id " + e.getId()));
            }
            this.em.merge(e);
        });
    }

    protected void doPersist(LogEntry entry) {
        entry.setLogDate(new Date());
        this.em.persist((Object)entry);
    }

    protected List<?> doPublishIfEntries(List<?> entries) {
        if (entries == null || entries.size() == 0) {
            return entries;
        }
        Object entry = entries.get(0);
        if (entry instanceof LogEntry) {
            for (Object logEntry : entries) {
                this.doPublish((LogEntry)logEntry);
            }
        }
        return entries;
    }

    protected List<LogEntry> doPublish(List<LogEntry> entries) {
        entries.forEach(this::doPublish);
        return entries;
    }

    protected LogEntry doPublish(LogEntry entry) {
        if (entry.getExtendedInfos() != null) {
            entry.getExtendedInfos().size();
        }
        return entry;
    }

    @Override
    public void addLogEntry(LogEntry entry) {
        this.doPersist(entry);
    }

    public void addLogEntries(List<LogEntry> entries) {
        entries.forEach(this::doPersist);
    }

    @Override
    public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() UUID=" + uuid + " and repositoryId=" + repositoryId));
        }
        Query query = this.em.createNamedQuery("LogEntry.findByDocumentAndRepository");
        query.setParameter("docUUID", (Object)uuid);
        query.setParameter("repositoryId", (Object)repositoryId);
        return this.doPublish(query.getResultList());
    }

    @Override
    public List<LogEntry> getLogEntriesFor(String uuid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() UUID=" + uuid));
        }
        Query query = this.em.createNamedQuery("LogEntry.findByDocument");
        query.setParameter("docUUID", (Object)uuid);
        return this.doPublish(query.getResultList());
    }

    @Override
    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() UUID=" + uuid));
        }
        if (filterMap == null) {
            filterMap = new HashMap<String, FilterMapEntry>();
        }
        StringBuilder queryStr = new StringBuilder();
        queryStr.append(" FROM LogEntry log WHERE log.docUUID=:uuid ");
        Set<String> filterMapKeySet = filterMap.keySet();
        for (String currentKey : filterMapKeySet) {
            FilterMapEntry currentFilterMapEntry = filterMap.get(currentKey);
            String currentOperator = currentFilterMapEntry.getOperator();
            String currentQueryParameterName = currentFilterMapEntry.getQueryParameterName();
            String currentColumnName = currentFilterMapEntry.getColumnName();
            if (LIKE.equals(currentOperator)) {
                queryStr.append(" AND log.").append(currentColumnName).append(" LIKE :").append(currentQueryParameterName).append(" ");
                continue;
            }
            queryStr.append(" AND log.").append(currentColumnName).append(currentOperator).append(":").append(currentQueryParameterName).append(" ");
        }
        if (doDefaultSort) {
            queryStr.append(" ORDER BY log.eventDate DESC");
        }
        Query query = this.em.createQuery(queryStr.toString());
        query.setParameter("uuid", (Object)uuid);
        for (String currentKey : filterMapKeySet) {
            FilterMapEntry currentFilterMapEntry = filterMap.get(currentKey);
            String currentOperator = currentFilterMapEntry.getOperator();
            String currentQueryParameterName = currentFilterMapEntry.getQueryParameterName();
            Object currentObject = currentFilterMapEntry.getObject();
            if (LIKE.equals(currentOperator)) {
                query.setParameter(currentQueryParameterName, (Object)("%" + currentObject + "%"));
                continue;
            }
            query.setParameter(currentQueryParameterName, currentObject);
        }
        return this.doPublish(query.getResultList());
    }

    public LogEntry getLogEntryByID(long id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLogEntriesFor() logID=" + id));
        }
        return this.doPublish((LogEntry)this.em.find(LogEntryImpl.class, (Object)id));
    }

    public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        Query query = this.em.createQuery("from LogEntry log where " + whereClause);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        } else if (pageNb == 0) {
            log.warn((Object)"Requested pageNb equals 0 but page index start at 1. Will fallback to fetch the first page");
        }
        query.setMaxResults(pageSize);
        return this.doPublish(query.getResultList());
    }

    public List<?> nativeQuery(String queryString, int pageNb, int pageSize) {
        Query query = this.em.createQuery(queryString);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return this.doPublishIfEntries(query.getResultList());
    }

    public List<?> nativeQuery(String queryString, Map<String, Object> params, int pageNb, int pageSize) {
        if (pageSize <= 0) {
            pageSize = 1000;
        }
        Query query = this.em.createQuery(queryString);
        for (Map.Entry<String, Object> en : params.entrySet()) {
            query.setParameter(en.getKey(), en.getValue());
        }
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return this.doPublishIfEntries(query.getResultList());
    }

    public List<LogEntry> queryLogs(QueryBuilder builder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryLogs() builder=" + builder));
        }
        MultiExpression multiExpression = builder.predicate();
        OrderByList orders = builder.orders();
        long offset = builder.offset();
        long limit = builder.limit();
        List predicates = multiExpression.predicates;
        Function<Operand, String> getFieldName = operand -> ((Reference)operand).name;
        StringBuilder queryStr = new StringBuilder(" FROM LogEntry log");
        boolean firstFilter = true;
        String op = multiExpression.operator == Operator.AND ? " AND" : " OR";
        for (Object predicate : predicates) {
            if (firstFilter) {
                queryStr.append(" WHERE");
                firstFilter = false;
            } else {
                queryStr.append(op);
            }
            String leftName = getFieldName.apply(((Predicate)predicate).lvalue);
            queryStr.append(" log.").append(leftName).append(" ").append(this.toString(((Predicate)predicate).operator)).append(" ");
            if (((Predicate)predicate).operator == Operator.IN) {
                queryStr.append("(");
            }
            queryStr.append(":");
            queryStr.append(leftName);
            if (((Predicate)predicate).operator != Operator.IN) continue;
            queryStr.append(")");
        }
        boolean firstOrder = true;
        for (OrderByExpr order : orders) {
            if (firstOrder) {
                queryStr.append(" ORDER BY");
                firstOrder = false;
            } else {
                queryStr.append(",");
            }
            queryStr.append(" log.").append(getFieldName.apply((Operand)order.reference));
        }
        if (!firstOrder) {
            if (((OrderByExpr)orders.get((int)0)).isDescending) {
                queryStr.append(" DESC");
            } else {
                queryStr.append(" ASC");
            }
        }
        Query query = this.em.createQuery(queryStr.toString());
        for (Predicate predicate : predicates) {
            String leftName = getFieldName.apply(predicate.lvalue);
            Operator operator = predicate.operator;
            Object rightValue = Literals.valueOf((Operand)predicate.rvalue);
            if (rightValue instanceof ZonedDateTime) {
                rightValue = Date.from(((ZonedDateTime)rightValue).toInstant());
            }
            if (Operator.LIKE.equals((Object)operator)) {
                rightValue = "%" + rightValue + "%";
            } else if (Operator.STARTSWITH.equals((Object)operator)) {
                rightValue = rightValue + "%";
            }
            query.setParameter(leftName, rightValue);
        }
        if (offset > 0L) {
            query.setFirstResult((int)offset);
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
        }
        return this.doPublish(query.getResultList());
    }

    protected String toString(Operator operator) {
        if (Operator.STARTSWITH.equals((Object)operator)) {
            return LIKE;
        }
        return operator.toString();
    }

    public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        Object queryStr;
        Date limit;
        try {
            limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
        }
        catch (AuditQueryException aqe) {
            aqe.addInfo("Wrong date range query. Query was " + dateRange);
            throw aqe;
        }
        if (eventIds == null || eventIds.length == 0) {
            queryStr = "from LogEntry log where log.eventDate >= :limit ORDER BY log.eventDate DESC";
        } else {
            Object inClause = "(";
            for (String eventId : eventIds) {
                inClause = (String)inClause + "'" + eventId + "',";
            }
            inClause = ((String)inClause).substring(0, ((String)inClause).length() - 1);
            inClause = (String)inClause + ")";
            queryStr = "from LogEntry log where log.eventId in " + (String)inClause + " AND log.eventDate >= :limit ORDER BY log.eventDate DESC";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("queryLogs() =" + (String)queryStr));
        }
        Query query = this.em.createQuery((String)queryStr);
        query.setParameter("limit", (Object)limit);
        return this.doPublish(query.getResultList());
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        Date limit;
        try {
            limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
        }
        catch (AuditQueryException aqe) {
            aqe.addInfo("Wrong date range query. Query was " + dateRange);
            throw aqe;
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        Object inClause;
        if (eventIds == null) {
            eventIds = new String[]{};
        }
        if (categories == null) {
            categories = new String[]{};
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("from LogEntry log where ");
        if (eventIds.length > 0) {
            inClause = "(";
            for (String eventId : eventIds) {
                inClause = (String)inClause + "'" + eventId + "',";
            }
            inClause = ((String)inClause).substring(0, ((String)inClause).length() - 1);
            inClause = (String)inClause + ")";
            queryString.append(" log.eventId IN ").append((String)inClause);
            queryString.append(" AND ");
        }
        if (categories.length > 0) {
            inClause = "(";
            for (String cat : categories) {
                inClause = (String)inClause + "'" + cat + "',";
            }
            inClause = ((String)inClause).substring(0, ((String)inClause).length() - 1);
            inClause = (String)inClause + ")";
            queryString.append(" log.category IN ").append((String)inClause);
            queryString.append(" AND ");
        }
        if (path != null && !"".equals(path.trim())) {
            queryString.append(" log.docPath LIKE '").append(path).append("%'");
            queryString.append(" AND ");
        }
        queryString.append(" log.eventDate >= :limit");
        queryString.append(" ORDER BY log.eventDate DESC");
        Query query = this.em.createQuery(queryString.toString());
        query.setParameter("limit", (Object)limit);
        if (pageNb > 1) {
            query.setFirstResult((pageNb - 1) * pageSize);
        }
        query.setMaxResults(pageSize);
        return this.doPublish(query.getResultList());
    }

    @Override
    public int removeEntries(String eventId, String pathPattern) {
        Query query = this.em.createNamedQuery("LogEntry.findByEventIdAndPath");
        query.setParameter("eventId", (Object)eventId);
        query.setParameter("pathPattern", (Object)(pathPattern + "%"));
        int count = 0;
        for (LogEntry entry : query.getResultList()) {
            this.em.remove((Object)entry);
            ++count;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removed " + count + " entries from " + pathPattern));
        }
        return count;
    }

    public Long countEventsById(String eventId) {
        Query query = this.em.createNamedQuery("LogEntry.countEventsById");
        query.setParameter("eventId", (Object)eventId);
        return (Long)query.getSingleResult();
    }

    public List<String> findEventIds() {
        Query query = this.em.createNamedQuery("LogEntry.findEventIds");
        return query.getResultList();
    }
}

