/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.runtime.api.Framework;

public class DocumentTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) {
        NuxeoPrincipal principal = coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession);
    }

    public List<Task> getCurrentTaskInstances(CoreSession coreSession, List<SortInfo> sortInfos) {
        NuxeoPrincipal principal = coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession, sortInfos);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_ACTORS", coreSession, true, null, actors);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession, List<SortInfo> sortInfos) {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_ACTORS", coreSession, true, sortInfos, actors);
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) {
        if (user == null) {
            return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS", coreSession, true, null, dm.getId(), dm.getId());
        }
        List<String> actors = TaskActorsHelper.getTaskActors(user);
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", coreSession, true, null, dm.getId(), dm.getId(), actors);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", coreSession, true, null, dm.getId(), dm.getId(), actors);
    }

    public List<Task> getAllTaskInstances(String processId, CoreSession session) {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS", session, true, null, processId);
    }

    public List<Task> getAllTaskInstances(String processId, NuxeoPrincipal user, CoreSession session) {
        List<String> actors = TaskActorsHelper.getTaskActors(user);
        return this.getAllTaskInstances(processId, actors, session);
    }

    public List<Task> getAllTaskInstances(String processId, List<String> actors, CoreSession session) {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS_AND_ACTORS", session, true, null, processId, actors);
    }

    public static List<Task> wrapDocModelInTask(List<DocumentModel> taskDocuments) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    @Deprecated
    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments) {
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments, false);
    }

    @Deprecated
    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments, boolean detach) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            if (detach) {
                doc.detach(true);
            }
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    public String endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            task.addComment(principal.getName(), comment);
        }
        task.setVariable(TaskService.VariableName.validated.name(), String.valueOf(isValidated));
        task.end(coreSession);
        DocumentModel taskDocument = task.getDocument();
        if (taskDocument.getSessionId() == null) {
            taskDocument.attach(coreSession.getSessionId());
        }
        coreSession.saveDocument(taskDocument);
        if (StringUtils.isNotBlank((CharSequence)eventName)) {
            TaskEventNotificationHelper.notifyTaskEnded(coreSession, principal, task, comment, eventName, null);
        }
        return isValidated ? "workflowTaskCompleted" : "workflowTaskRejected";
    }

    public List<Task> getAllTaskInstances(String processId, String nodeId, CoreSession session) {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS_AND_NODE", session, true, null, processId, nodeId);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, boolean includeDelegatedTasks, CoreSession session) {
        if (includeDelegatedTasks) {
            return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS_OR_DELEGATED_ACTORS", session, true, null, dm.getId(), dm.getId(), actors, actors);
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", session, true, null, dm.getId(), dm.getId(), actors);
    }

    public List<Task> getAllCurrentTaskInstances(CoreSession session, List<SortInfo> sortInfos) {
        NuxeoPrincipal principal = session.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_ACTORS_OR_DELEGATED_ACTORS", session, true, sortInfos, actors, actors);
    }

    public static List<Task> getTasks(String pageProviderName, CoreSession session, boolean unrestricted, List<SortInfo> sortInfos, Object ... params) {
        PageProvider pp;
        Map defProps;
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        if (ppService == null) {
            throw new RuntimeException("Missing PageProvider service");
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        PageProviderDefinition def = ppService.getPageProviderDefinition(pageProviderName);
        if (def != null && (defProps = def.getProperties()) != null) {
            props.putAll(defProps);
        }
        props.put("coreSession", (Serializable)session);
        if (unrestricted) {
            props.put("useUnrestrictedSession", Boolean.TRUE);
        }
        if ((pp = ppService.getPageProvider(pageProviderName, sortInfos, null, null, props, params)) == null) {
            throw new NuxeoException("Page provider not found: " + pageProviderName);
        }
        return DocumentTaskProvider.wrapDocModelInTask(pp.getCurrentPage());
    }
}

