/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.consumers.OAuthConsumerRegistry;
import org.nuxeo.ecm.platform.oauth.keys.OAuthServerKeyManager;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoOAuth1Authenticator
implements NuxeoAuthenticationPlugin {
    private static final Logger log = LogManager.getLogger(NuxeoOAuth1Authenticator.class);

    public void initPlugin(Map<String, String> parameters) {
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.FALSE;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return Boolean.FALSE;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isOAuth1SignedRequest(request)) {
            log.trace("Not an OAuth 1 signed request");
            return null;
        }
        String username = this.getIdentity(request);
        if (username == null) {
            log.trace("OAuth 1 auth failed");
            return null;
        }
        log.trace("OAuth 1 auth for user: {}", (Object)username);
        return new UserIdentificationInfo(username, username);
    }

    protected boolean isOAuth1SignedRequest(HttpServletRequest request) {
        String auth = request.getHeader("Authorization");
        if (auth != null && auth.contains("OAuth")) {
            return true;
        }
        return request.getParameter("oauth_signature") != null;
    }

    protected String getIdentity(HttpServletRequest request) {
        return (String)TransactionHelper.runInTransaction(() -> {
            try {
                return this.getOAuth1Identity(request);
            }
            catch (IOException e) {
                log.debug((Object)e, (Throwable)e);
                return null;
            }
        });
    }

    protected String getOAuth1Identity(HttpServletRequest request) throws IOException {
        String username;
        OAuthServerKeyManager okm;
        String url = NuxeoOAuth1Authenticator.getRequestURL(request);
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)request, (String)url);
        String consumerKey = message.getConsumerKey();
        String signatureMethod = message.getSignatureMethod();
        OAuthConsumerRegistry consumerRegistry = (OAuthConsumerRegistry)Framework.getService(OAuthConsumerRegistry.class);
        NuxeoOAuthConsumer consumer = consumerRegistry.getConsumer(consumerKey, signatureMethod);
        if (consumer == null && consumerKey != null && consumerKey.equals((okm = (OAuthServerKeyManager)Framework.getService(OAuthServerKeyManager.class)).getInternalKey())) {
            consumer = okm.getInternalConsumer();
        }
        if (consumer == null) {
            return null;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        SimpleOAuthValidator validator = new SimpleOAuthValidator();
        OAuthTokenStore tokenStore = (OAuthTokenStore)Framework.getService(OAuthTokenStore.class);
        OAuthToken aToken = tokenStore.getAccessToken(message.getToken());
        if (aToken != null) {
            accessor.accessToken = aToken.getToken();
            accessor.tokenSecret = aToken.getTokenSecret();
            username = aToken.getNuxeoLogin();
        } else {
            if (!consumer.allowSignedFetch()) {
                return null;
            }
            username = consumer.getSignedFetchUser();
            if ("opensocial:viewer".equals(username)) {
                username = message.getParameter("opensocial_viewer_id");
            } else if ("opensocial:owner".equals(username)) {
                username = message.getParameter("opensocial_owner_id");
            }
        }
        try {
            validator.validateMessage(message, accessor);
            return username;
        }
        catch (URISyntaxException | OAuthException e) {
            log.debug("Invalid OAuth signature", e);
            return null;
        }
    }

    public static String getRequestURL(HttpServletRequest request) {
        Object url = request.getRequestURL().toString();
        String forwardedProto = request.getHeader("X-Forwarded-Proto");
        if (forwardedProto != null && !((String)url).startsWith(forwardedProto)) {
            url = forwardedProto + ((String)url).substring(((String)url).indexOf("://"));
        }
        return url;
    }
}

