/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.export.LayoutResource;
import org.nuxeo.ecm.platform.forms.layout.export.LayoutTypeResource;
import org.nuxeo.ecm.platform.forms.layout.export.WidgetTypeResource;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

@Path(value="layout-manager")
public class RootResource {
    protected TemplateView getTemplate(String name, UriInfo uriInfo) {
        Object baseURL = uriInfo.getAbsolutePath().toString();
        if (!((String)baseURL).endsWith("/")) {
            baseURL = (String)baseURL + "/";
        }
        return new TemplateView((Object)this, name).arg("baseURL", baseURL);
    }

    @GET
    public Object doGet(@Context UriInfo uriInfo) {
        LayoutStore service = (LayoutStore)Framework.getService(LayoutStore.class);
        int nbWidgetTypes = service.getWidgetTypeDefinitions("jsf").size();
        int nbLayoutTypes = service.getLayoutTypeDefinitions("jsf").size();
        int nbLayouts = service.getLayoutDefinitionNames("jsf").size();
        return this.getTemplate("index.ftl", uriInfo).arg("nbWidgetTypes", (Object)nbWidgetTypes).arg("nbLayouts", (Object)nbLayouts).arg("nbLayoutTypes", (Object)nbLayoutTypes);
    }

    @Path(value="layouts")
    public Object getLayouts() {
        return new LayoutResource("jsf");
    }

    @Path(value="widget-types")
    public Object getWidgetTypes(@QueryParam(value="widgetTypeCategory") String widgetTypeCategory) {
        if (StringUtils.isBlank((CharSequence)widgetTypeCategory)) {
            widgetTypeCategory = "jsf";
        }
        return new WidgetTypeResource(widgetTypeCategory);
    }

    @Path(value="layout-types")
    public Object getLayoutTypes(@QueryParam(value="layoutTypeCategory") String layoutTypeCategory) {
        if (StringUtils.isBlank((CharSequence)layoutTypeCategory)) {
            layoutTypeCategory = "jsf";
        }
        return new LayoutTypeResource(layoutTypeCategory);
    }
}

