/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.export.AbstractLayoutJsonWriter;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WidgetTypeConfigurationJsonWriter
extends AbstractLayoutJsonWriter<WidgetTypeConfiguration> {
    public void write(WidgetTypeConfiguration entity, JsonGenerator jg) throws IOException {
        Map defaultControlValues;
        Map defaultPropertyValues;
        Map propertyLayouts;
        Map fieldLayouts;
        List fieldDefinitions;
        List defaultTypes;
        List supportedControls;
        List supportedModes;
        Map confProperties;
        jg.writeStartObject();
        jg.writeStringField("title", entity.getTitle());
        jg.writeStringField("description", entity.getDescription());
        String demoId = entity.getDemoId();
        if (demoId != null) {
            jg.writeObjectFieldStart("demo");
            jg.writeStringField("id", demoId);
            jg.writeBooleanField("previewEnabled", entity.isDemoPreviewEnabled());
            jg.writeEndObject();
        }
        jg.writeStringField("sinceVersion", entity.getSinceVersion());
        String deprVersion = entity.getDeprecatedVersion();
        if (StringUtils.isNotBlank((CharSequence)deprVersion)) {
            jg.writeStringField("deprecatedVersion", deprVersion);
        }
        if (MapUtils.isNotEmpty((Map)(confProperties = entity.getConfProperties()))) {
            this.writeSerializableMapField("confProperties", confProperties, jg);
        }
        if (CollectionUtils.isNotEmpty((Collection)(supportedModes = entity.getSupportedModes()))) {
            this.writeSerializableListField("supportedModes", supportedModes, jg);
        }
        if (entity.isAcceptingSubWidgets()) {
            jg.writeBooleanField("acceptingSubWidgets", entity.isAcceptingSubWidgets());
        }
        if (entity.isHandlingLabels()) {
            jg.writeBooleanField("handlingLabels", entity.isHandlingLabels());
        }
        if (CollectionUtils.isNotEmpty((Collection)(supportedControls = entity.getSupportedControls()))) {
            this.writeSerializableListField("supportedControls", supportedControls, jg);
        }
        if (entity.isContainingForm()) {
            jg.writeBooleanField("containingForm", true);
        }
        jg.writeObjectFieldStart("fields");
        jg.writeBooleanField("list", entity.isList());
        jg.writeBooleanField("complex", entity.isComplex());
        List supportedTypes = entity.getSupportedFieldTypes();
        if (CollectionUtils.isNotEmpty((Collection)supportedTypes)) {
            this.writeSerializableListField("supportedTypes", supportedTypes, jg);
        }
        if (CollectionUtils.isNotEmpty((Collection)(defaultTypes = entity.getDefaultFieldTypes()))) {
            this.writeSerializableListField("defaultTypes", defaultTypes, jg);
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldDefinitions = entity.getDefaultFieldDefinitions()))) {
            this.writeSerializableListField("defaultConfiguration", fieldDefinitions, jg);
        }
        if (MapUtils.isNotEmpty((Map)(fieldLayouts = entity.getFieldLayouts())) && fieldLayouts.values().stream().anyMatch(CollectionUtils::isNotEmpty)) {
            jg.writeObjectFieldStart("layouts");
            for (Map.Entry entry : new TreeMap(fieldLayouts).entrySet()) {
                this.writeSerializableListField((String)entry.getKey(), (Collection)entry.getValue(), jg);
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
        List categories = entity.getCategories();
        if (CollectionUtils.isNotEmpty((Collection)categories)) {
            this.writeSerializableListField("categories", categories, jg);
        }
        if (MapUtils.isNotEmpty((Map)(propertyLayouts = entity.getPropertyLayouts())) && propertyLayouts.values().stream().anyMatch(CollectionUtils::isNotEmpty)) {
            jg.writeObjectFieldStart("properties");
            jg.writeObjectFieldStart("layouts");
            for (Map.Entry entry : new TreeMap(propertyLayouts).entrySet()) {
                this.writeSerializableListField((String)entry.getKey(), (Collection)entry.getValue(), jg);
            }
            jg.writeEndObject();
            jg.writeEndObject();
        }
        if (MapUtils.isNotEmpty((Map)(defaultPropertyValues = entity.getDefaultPropertyValues())) && defaultPropertyValues.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("defaultPropertyValues", this.cleanAndSort(defaultPropertyValues), jg);
        }
        if (MapUtils.isNotEmpty((Map)(defaultControlValues = entity.getDefaultControlValues())) && defaultControlValues.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("defaultControlValues", this.cleanAndSort(defaultControlValues), jg);
        }
        jg.writeEndObject();
    }
}

