/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;

public class CSVZipImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    private static final String MARKER = "meta-data.csv";
    private static final Log log = LogFactory.getLog(CSVZipImporter.class);

    public static ZipFile getArchiveFileIfValid(File file) throws IOException {
        ZipFile zip;
        try {
            zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug((Object)"file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug((Object)"can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = zip.getEntry(MARKER);
        if (marker == null) {
            zip.close();
            return null;
        }
        return zip;
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        CoreSession session = context.getSession();
        Blob blob = context.getBlob();
        try (CloseableFile source = blob.getCloseableFile();){
            ZipFile zip = CSVZipImporter.getArchiveFileIfValid(source.getFile());
            if (zip == null) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            String parentPath = context.getParentPath();
            DocumentModel container = session.getDocument((DocumentRef)new PathRef(parentPath));
            ZipEntry index = zip.getEntry(MARKER);
            try (InputStreamReader reader = new InputStreamReader(zip.getInputStream(index));
                 CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.withHeader(new String[0]));){
                Map header = csvParser.getHeaderMap();
                for (CSVRecord csvRecord : csvParser) {
                    String targetPath;
                    String type = null;
                    String id = null;
                    HashMap<String, String> stringValues = new HashMap<String, String>();
                    for (String headerValue : header.keySet()) {
                        String lineValue = csvRecord.get(headerValue);
                        if ("type".equalsIgnoreCase(headerValue)) {
                            type = lineValue;
                            continue;
                        }
                        if ("id".equalsIgnoreCase(headerValue)) {
                            id = lineValue;
                            continue;
                        }
                        stringValues.put(headerValue, lineValue);
                    }
                    boolean updateDoc = false;
                    DocumentModel targetDoc = null;
                    if (id != null && session.exists((DocumentRef)new PathRef(targetPath = new Path(parentPath).append(id).toString()))) {
                        targetDoc = session.getDocument((DocumentRef)new PathRef(targetPath));
                        updateDoc = true;
                    }
                    if (targetDoc == null) {
                        if (type == null) {
                            log.error((Object)"Can not create doc without a type, skipping line");
                            continue;
                        }
                        if (id == null) {
                            id = IdUtils.generateStringId();
                        }
                        targetDoc = session.createDocumentModel(parentPath, id, type);
                    }
                    DocumentType targetDocType = targetDoc.getDocumentType();
                    for (Map.Entry entry : stringValues.entrySet()) {
                        Serializable fieldValue;
                        String fname = (String)entry.getKey();
                        String stringValue = (String)entry.getValue();
                        Field field = null;
                        boolean usePrefix = false;
                        String schemaName = null;
                        String fieldName = null;
                        if (fname.contains(":")) {
                            if (targetDocType.hasField(fname)) {
                                field = targetDocType.getField(fname);
                                usePrefix = true;
                            }
                        } else if (fname.contains(".")) {
                            String[] parts = fname.split("\\.");
                            schemaName = parts[0];
                            fieldName = parts[1];
                            if (targetDocType.hasSchema(schemaName)) {
                                field = targetDocType.getField(fieldName);
                                usePrefix = false;
                            }
                        } else if (targetDocType.hasField(fname)) {
                            field = targetDocType.getField(fname);
                            usePrefix = false;
                            schemaName = field.getDeclaringType().getSchemaName();
                        }
                        if (field == null || (fieldValue = this.getFieldValue(field, stringValue, zip)) == null) continue;
                        if (usePrefix) {
                            targetDoc.setPropertyValue(fname, fieldValue);
                            continue;
                        }
                        targetDoc.setProperty(schemaName, fieldName, (Object)fieldValue);
                    }
                    if (updateDoc) {
                        session.saveDocument(targetDoc);
                        continue;
                    }
                    session.createDocument(targetDoc);
                }
            }
            DocumentModel documentModel = container;
            return documentModel;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable getFieldValue(Field field, String stringValue, ZipFile zip) {
        Blob blob;
        String fieldValue = null;
        Type type = field.getType();
        if (type.isSimpleType()) {
            if (type instanceof SimpleTypeImpl) {
                type = type.getSuperType();
            }
            if (type instanceof StringType) {
                return stringValue;
            }
            if (type instanceof IntegerType) {
                return Integer.valueOf(Integer.parseInt(stringValue));
            }
            if (type instanceof LongType) {
                return Long.valueOf(Long.parseLong(stringValue));
            }
            if (type instanceof DateType) {
                try {
                    Date date;
                    if (stringValue.length() == 10) {
                        date = new SimpleDateFormat("dd/MM/yyyy").parse(stringValue);
                        return date;
                    } else if (stringValue.length() == 8) {
                        date = new SimpleDateFormat("dd/MM/yy").parse(stringValue);
                        return date;
                    } else {
                        log.warn((Object)("Unknown date format :" + stringValue));
                        return null;
                    }
                }
                catch (ParseException e) {
                    log.error((Object)"Error during date parsing", (Throwable)e);
                }
                return fieldValue;
            }
            log.warn((Object)String.format("Unsupported field type '%s'", type));
            return null;
        }
        if (!type.isComplexType()) return fieldValue;
        if (!"content".equals(field.getName().getLocalName())) return fieldValue;
        ZipEntry blobIndex = zip.getEntry(stringValue);
        if (blobIndex == null) return fieldValue;
        try {
            blob = Blobs.createBlob((InputStream)zip.getInputStream(blobIndex));
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        blob.setFilename(stringValue);
        return (Serializable)blob;
    }
}

