/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.collections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Collection.Suggestion", category="Services", label="Get collection suggestion", description="Get the collection list accessible by the current user. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestCollectionEntry {
    public static final String ID = "Collection.Suggestion";
    private static final String PATH = "path";
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex = 0;
    @Param(name="pageSize", required=false)
    protected Integer pageSize = 20;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="lang", required=false)
    protected String lang;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() throws OperationException, IOException {
        ArrayList result = new ArrayList();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        StringList sl = new StringList();
        sl.add((Object)(this.searchTerm + (this.searchTerm.endsWith("%") ? "" : "%")));
        sl.add((Object)"$currentUser");
        vars.put("queryParams", sl);
        vars.put("providerName", "default_collection");
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters("Repository.PageProvider", vars);
        chain.add(oparams);
        List docs = (List)this.service.run(this.ctx, chain);
        boolean found = false;
        for (DocumentModel doc : docs) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            if (this.collectionManager.canAddToCollection(doc, this.session)) {
                obj.put("id", doc.getId());
            }
            if (doc.getTitle().equals(this.searchTerm)) {
                found = true;
            }
            obj.put("displayLabel", doc.getTitle());
            if (StringUtils.isNotBlank((CharSequence)((String)doc.getProperty("common", "icon")))) {
                obj.put("icon", doc.getProperty("common", "icon"));
            }
            obj.put(PATH, doc.getPath().toString());
            result.add(obj);
        }
        if (!found && StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            obj.put("displayLabel", this.searchTerm);
            obj.put("id", "-999999" + this.searchTerm);
            result.add(0, obj);
        }
        return Blobs.createJSONBlobFromValue(result);
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }
}

